/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int decodeMiddle(BitArray row, int[] startRange, StringBuilder resultString) throws NotFoundException {
        void var2_3;
        int n;
        int[] counters = this.decodeMiddleCounters;
        this.decodeMiddleCounters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        for (int x = 0; x < 6 && rowOffset < end; ++x) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            int[] nArray = counters;
            int n2 = counters.length;
            for (n = 0; n < n2; ++n) {
                int counter = nArray[n];
                rowOffset += counter;
            }
            if (bestMatch < 10) continue;
            lgPatternFound |= 1 << 5 - x;
        }
        EAN13Reader.determineFirstDigit(resultString, lgPatternFound);
        rowOffset = EAN13Reader.findGuardPattern(row, rowOffset, true, MIDDLE_PATTERN)[1];
        for (int x = 0; x < 6 && rowOffset < end; ++x) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            resultString.append((char)(bestMatch + 48));
            int[] nArray = counters;
            n = counters.length;
            for (int i = 0; i < n; ++i) {
                int counter = nArray[i];
                rowOffset += counter;
            }
        }
        return (int)var2_3;
    }

    @Override
    final BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }

    private static void determineFirstDigit(StringBuilder resultString, int lgPatternFound) throws NotFoundException {
        for (int d = 0; d < 10; ++d) {
            if (lgPatternFound != FIRST_DIGIT_ENCODINGS[d]) continue;
            resultString.insert(0, (char)(d + 48));
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

