/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public class Code93Writer
extends OneDimensionalCodeWriter {
    /*
     * WARNING - void declaration
     */
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (format != BarcodeFormat.CODE_93) {
            throw new IllegalArgumentException("Can only encode CODE_93, but got ".concat(String.valueOf((Object)format)));
        }
        return super.encode((String)var1_1, (BarcodeFormat)var2_2, (int)var3_3, height, hints);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean[] encode(String contents) {
        void var3_3;
        void var1_1;
        int length = contents.length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got ".concat(String.valueOf(length)));
        }
        int[] widths = new int[9];
        boolean[] result = new boolean[(contents.length() + 2 + 2) * 9 + 1];
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[47], widths);
        int pos = Code93Writer.appendPattern(result, 0, widths, true);
        for (int i = 0; i < length; ++i) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(contents.charAt(i));
            Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[indexInString], widths);
            pos += Code93Writer.appendPattern(result, pos, widths, true);
        }
        int check1 = Code93Writer.computeChecksumIndex(contents, 20);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[check1], widths);
        pos += Code93Writer.appendPattern(result, pos, widths, true);
        int check2 = Code93Writer.computeChecksumIndex((String)var1_1 + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(check1), 15);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[check2], widths);
        pos += Code93Writer.appendPattern(result, pos, widths, true);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[47], widths);
        pos += Code93Writer.appendPattern(result, pos, (int[])var3_3, true);
        result[pos] = true;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static void toIntArray(int a, int[] toReturn) {
        for (int i = 0; i < 9; ++i) {
            void var3_3;
            int temp = a & 1 << 8 - i;
            toReturn[i] = var3_3 == false ? 0 : 1;
        }
    }

    protected static int appendPattern(boolean[] target, int pos, int[] pattern, boolean startColor) {
        int[] nArray = pattern;
        int n = pattern.length;
        for (int i = 0; i < n; ++i) {
            int bit = nArray[i];
            target[pos++] = bit != 0;
        }
        return 9;
    }

    /*
     * WARNING - void declaration
     */
    private static int computeChecksumIndex(String contents, int maxWeight) {
        void var3_3;
        int weight = 1;
        int total = 0;
        for (int i = contents.length() - 1; i >= 0; --i) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(contents.charAt(i));
            total += indexInString * weight;
            if (++weight <= maxWeight) continue;
            weight = 1;
        }
        return (int)(var3_3 % 47);
    }
}

