/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_B = 100;

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (format != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got ".concat(String.valueOf((Object)format)));
        }
        return super.encode((String)var1_1, (BarcodeFormat)var2_2, (int)var3_3, height, hints);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean[] encode(String contents) {
        void var3_8;
        int length = contents.length();
        if (length <= 0 || length > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got ".concat(String.valueOf(length)));
        }
        block9: for (int i = 0; i < length; ++i) {
            char c = contents.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            switch (c) {
                case '\u00f1': 
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': {
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Bad character in input: ".concat(String.valueOf(c)));
                }
            }
        }
        ArrayList<int[]> patterns = new ArrayList<int[]>();
        int checkSum = 0;
        int checkWeight = 1;
        int codeSet = 0;
        int position = 0;
        while (position < length) {
            int patternIndex;
            int newCodeSet = Code128Writer.chooseCode(contents, position, codeSet);
            if (newCodeSet == codeSet) {
                switch (contents.charAt(position)) {
                    case '\u00f1': {
                        patternIndex = 102;
                        break;
                    }
                    case '\u00f2': {
                        patternIndex = 97;
                        break;
                    }
                    case '\u00f3': {
                        patternIndex = 96;
                        break;
                    }
                    case '\u00f4': {
                        patternIndex = 100;
                        break;
                    }
                    default: {
                        if (codeSet == 100) {
                            patternIndex = contents.charAt(position) - 32;
                            break;
                        }
                        int n = position++;
                        patternIndex = Integer.parseInt(contents.substring(n, n + 2));
                    }
                }
                ++position;
            } else {
                patternIndex = codeSet == 0 ? (newCodeSet == 100 ? 104 : 105) : newCodeSet;
                codeSet = newCodeSet;
            }
            patterns.add(Code128Reader.CODE_PATTERNS[patternIndex]);
            checkSum += patternIndex * checkWeight;
            if (position == 0) continue;
            ++checkWeight;
        }
        patterns.add(Code128Reader.CODE_PATTERNS[checkSum %= 103]);
        patterns.add(Code128Reader.CODE_PATTERNS[106]);
        int codeWidth = 0;
        Iterator patternIndex = patterns.iterator();
        while (patternIndex.hasNext()) {
            for (int width : (int[])patternIndex.next()) {
                codeWidth += width;
            }
        }
        boolean[] result = new boolean[codeWidth];
        int pos = 0;
        for (int[] pattern : var3_8) {
            pos += Code128Writer.appendPattern(result, pos, pattern, true);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static CType findCType(CharSequence value, int start) {
        void var3_3;
        void var1_1;
        CharSequence charSequence;
        void var2_2;
        int last = value.length();
        if (start >= last) {
            return CType.UNCODABLE;
        }
        char c = value.charAt(start);
        if (c == '\u00f1') {
            return CType.FNC_1;
        }
        if (c < '0' || c > '9') {
            return CType.UNCODABLE;
        }
        if (start + 1 >= var2_2) {
            return CType.ONE_DIGIT;
        }
        c = charSequence.charAt((int)(var1_1 + true));
        if (c < '0' || var3_3 > 57) {
            return CType.ONE_DIGIT;
        }
        return CType.TWO_DIGITS;
    }

    /*
     * WARNING - void declaration
     */
    private static int chooseCode(CharSequence value, int start, int oldCode) {
        void var3_3;
        CType lookahead = Code128Writer.findCType(value, start);
        if (lookahead == CType.UNCODABLE || lookahead == CType.ONE_DIGIT) {
            return 100;
        }
        if (oldCode == 99) {
            return oldCode;
        }
        if (oldCode == 100) {
            if (lookahead == CType.FNC_1) {
                return oldCode;
            }
            lookahead = Code128Writer.findCType(value, start + 2);
            if (lookahead == CType.UNCODABLE || lookahead == CType.ONE_DIGIT) {
                void var2_2;
                return (int)var2_2;
            }
            if (lookahead == CType.FNC_1) {
                if (Code128Writer.findCType(value, start + 3) == CType.TWO_DIGITS) {
                    return 99;
                }
                return 100;
            }
            int index = start + 4;
            while ((lookahead = Code128Writer.findCType(value, index)) == CType.TWO_DIGITS) {
                index += 2;
            }
            if (lookahead == CType.ONE_DIGIT) {
                return 100;
            }
            return 99;
        }
        if (lookahead == CType.FNC_1) {
            void var1_1;
            CharSequence charSequence;
            lookahead = Code128Writer.findCType(charSequence, (int)(var1_1 + true));
        }
        if (var3_3 == CType.TWO_DIGITS) {
            return 99;
        }
        return 100;
    }

    private static enum CType {
        UNCODABLE,
        ONE_DIGIT,
        TWO_DIGITS,
        FNC_1;

    }
}

