/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.multi.MultipleBarcodeReader;
import com.google.zxing.multi.qrcode.detector.MultiDetector;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class QRCodeMultiReader
extends QRCodeReader
implements MultipleBarcodeReader {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result[] decodeMultiple(BinaryBitmap image) throws NotFoundException {
        void var1_1;
        return this.decodeMultiple((BinaryBitmap)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result[] decodeMultiple(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        void var3_3;
        DetectorResult[] detectorResultArray;
        ArrayList<Result> results = new ArrayList<Result>();
        for (DetectorResult detectorResult : new MultiDetector(detectorResultArray.getBlackMatrix()).detectMulti(hints)) {
            try {
                String ecLevel;
                DecoderResult decoderResult = this.getDecoder().decode(detectorResult.getBits(), hints);
                ResultPoint[] points = detectorResult.getPoints();
                if (decoderResult.getOther() instanceof QRCodeDecoderMetaData) {
                    ((QRCodeDecoderMetaData)decoderResult.getOther()).applyMirroredCorrection(points);
                }
                Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.QR_CODE);
                List<byte[]> byteSegments = decoderResult.getByteSegments();
                if (byteSegments != null) {
                    result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, byteSegments);
                }
                if ((ecLevel = decoderResult.getECLevel()) != null) {
                    result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
                }
                if (decoderResult.hasStructuredAppend()) {
                    result.putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, decoderResult.getStructuredAppendSequenceNumber());
                    result.putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, decoderResult.getStructuredAppendParity());
                }
                results.add(result);
            }
            catch (ReaderException readerException) {}
        }
        if (results.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        List<Result> list = QRCodeMultiReader.processStructuredAppend((List<Result>)var3_3);
        return list.toArray(new Result[list.size()]);
    }

    private static List<Result> processStructuredAppend(List<Result> results) {
        StringBuilder stringBuilder;
        boolean bl;
        boolean bl2 = false;
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            if (!((Result)iterator.next()).getResultMetadata().containsKey((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return results;
        }
        ArrayList<Result> newResults = new ArrayList<Result>();
        ArrayList<Result> arrayList = new ArrayList<Result>();
        results = results.iterator();
        while (results.hasNext()) {
            Result result = (Result)results.next();
            newResults.add(result);
            if (!result.getResultMetadata().containsKey((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)) continue;
            arrayList.add(result);
        }
        Collections.sort(arrayList, new SAComparator());
        StringBuilder concatedText = new StringBuilder();
        int rawBytesLen = 0;
        int byteSegmentLength = 0;
        for (Result saResult : arrayList) {
            concatedText.append(saResult.getText());
            rawBytesLen += saResult.getRawBytes().length;
            if (!saResult.getResultMetadata().containsKey((Object)ResultMetadataType.BYTE_SEGMENTS)) continue;
            Iterator iterator2 = ((Iterable)saResult.getResultMetadata().get((Object)ResultMetadataType.BYTE_SEGMENTS)).iterator();
            while (iterator2.hasNext()) {
                Object segment = (byte[])iterator2.next();
                byteSegmentLength += ((Object)segment).length;
            }
        }
        byte[] newRawBytes = new byte[rawBytesLen];
        byte[] newByteSegment = new byte[byteSegmentLength];
        int newRawBytesIndex = 0;
        int byteSegmentIndex = 0;
        for (Result result : arrayList) {
            System.arraycopy(result.getRawBytes(), 0, newRawBytes, newRawBytesIndex, result.getRawBytes().length);
            newRawBytesIndex += result.getRawBytes().length;
            if (!result.getResultMetadata().containsKey((Object)ResultMetadataType.BYTE_SEGMENTS)) continue;
            for (byte[] segment : (Iterable)result.getResultMetadata().get((Object)ResultMetadataType.BYTE_SEGMENTS)) {
                System.arraycopy(segment, 0, newByteSegment, byteSegmentIndex, segment.length);
                byteSegmentIndex += segment.length;
            }
        }
        Result newResult = new Result(stringBuilder.toString(), newRawBytes, NO_POINTS, BarcodeFormat.QR_CODE);
        if (byteSegmentLength > 0) {
            ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
            arrayList2.add(newByteSegment);
            newResult.putMetadata(ResultMetadataType.BYTE_SEGMENTS, arrayList2);
        }
        newResults.add(newResult);
        return iterator;
    }

    private static final class SAComparator
    implements Serializable,
    Comparator<Result> {
        private SAComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(Result a, Result b) {
            void var2_4;
            void var1_2;
            int bNumber;
            int aNumber = (Integer)a.getResultMetadata().get((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE);
            if (aNumber < (bNumber = ((Integer)b.getResultMetadata().get((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)).intValue())) {
                return -1;
            }
            if (var1_2 > var2_4) {
                return 1;
            }
            return 0;
        }
    }
}

