/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.multi.MultipleBarcodeReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GenericMultipleBarcodeReader
implements MultipleBarcodeReader {
    private static final int MIN_DIMENSION_TO_RECUR = 100;
    private static final int MAX_DEPTH = 4;
    private final Reader delegate;

    /*
     * WARNING - void declaration
     */
    public GenericMultipleBarcodeReader(Reader delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result[] decodeMultiple(BinaryBitmap image) throws NotFoundException {
        void var1_1;
        return this.decodeMultiple((BinaryBitmap)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result[] decodeMultiple(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        ArrayList<Result> results = new ArrayList<Result>();
        this.doDecodeMultiple((BinaryBitmap)var1_1, (Map<DecodeHintType, ?>)var2_2, (List<Result>)results, 0, 0, 0);
        if (results.isEmpty()) {
            throw NotFoundException.getNotFoundInstance();
        }
        void v0 = var3_3;
        return v0.toArray(new Result[v0.size()]);
    }

    private void doDecodeMultiple(BinaryBitmap image, Map<DecodeHintType, ?> hints, List<Result> results, int xOffset, int yOffset, int currentDepth) {
        while (true) {
            ResultPoint[] resultPoints;
            Result result;
            if (currentDepth > 4) {
                return;
            }
            try {
                result = this.delegate.decode(image, hints);
            }
            catch (ReaderException readerException) {
                return;
            }
            boolean alreadyFound = false;
            ResultPoint[] resultPointArray = results.iterator();
            while (resultPointArray.hasNext()) {
                if (!resultPointArray.next().getText().equals(result.getText())) continue;
                alreadyFound = true;
                break;
            }
            if (!alreadyFound) {
                results.add(GenericMultipleBarcodeReader.translateResultPoints(result, xOffset, yOffset));
            }
            if ((resultPoints = result.getResultPoints()) == null || resultPoints.length == 0) {
                return;
            }
            int width = image.getWidth();
            int height = image.getHeight();
            float minX = width;
            float minY = height;
            float maxX = 0.0f;
            float maxY = 0.0f;
            resultPointArray = resultPoints;
            int n = resultPoints.length;
            for (int i = 0; i < n; ++i) {
                ResultPoint point = resultPointArray[i];
                if (point == null) continue;
                float x = point.getX();
                float y = point.getY();
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (!(y > maxY)) continue;
                maxY = y;
            }
            if (minX > 100.0f) {
                this.doDecodeMultiple(image.crop(0, 0, (int)minX, height), hints, results, xOffset, yOffset, currentDepth + 1);
            }
            if (minY > 100.0f) {
                this.doDecodeMultiple(image.crop(0, 0, width, (int)minY), hints, results, xOffset, yOffset, currentDepth + 1);
            }
            if (maxX < (float)(width - 100)) {
                this.doDecodeMultiple(image.crop((int)maxX, 0, width - (int)maxX, height), hints, results, xOffset + (int)maxX, yOffset, currentDepth + 1);
            }
            if (!(maxY < (float)(height - 100))) break;
            ++currentDepth;
            yOffset += (int)maxY;
            image = image.crop(0, (int)maxY, width, height - (int)maxY);
        }
    }

    private static Result translateResultPoints(Result result, int xOffset, int yOffset) {
        Result result2;
        ResultPoint[] oldResultPoints = result.getResultPoints();
        if (oldResultPoints == null) {
            return result;
        }
        ResultPoint[] newResultPoints = new ResultPoint[oldResultPoints.length];
        for (int i = 0; i < oldResultPoints.length; ++i) {
            ResultPoint oldPoint = oldResultPoints[i];
            if (oldPoint == null) continue;
            newResultPoints[i] = new ResultPoint(oldPoint.getX() + (float)xOffset, oldPoint.getY() + (float)yOffset);
        }
        Result newResult = new Result(result.getText(), result.getRawBytes(), result.getNumBits(), newResultPoints, result.getBarcodeFormat(), result.getTimestamp());
        newResult.putAllMetadata(result2.getResultMetadata());
        return newResult;
    }
}

