/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import java.util.Map;

public final class ByQuadrantReader
implements Reader {
    private final Reader delegate;

    /*
     * WARNING - void declaration
     */
    public ByQuadrantReader(Reader delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decode(BinaryBitmap image) throws NotFoundException, ChecksumException, FormatException {
        void var1_1;
        return this.decode((BinaryBitmap)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, ChecksumException, FormatException {
        int width = image.getWidth();
        int height = image.getHeight();
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        try {
            return this.delegate.decode(image.crop(0, 0, halfWidth, halfHeight), hints);
        }
        catch (NotFoundException notFoundException) {
            try {
                Result result = this.delegate.decode(image.crop(halfWidth, 0, halfWidth, halfHeight), hints);
                ByQuadrantReader.makeAbsolute(result.getResultPoints(), halfWidth, 0);
                return result;
            }
            catch (NotFoundException notFoundException2) {
                try {
                    Result result = this.delegate.decode(image.crop(0, halfHeight, halfWidth, halfHeight), hints);
                    ByQuadrantReader.makeAbsolute(result.getResultPoints(), 0, halfHeight);
                    return result;
                }
                catch (NotFoundException notFoundException3) {
                    try {
                        Result result = this.delegate.decode(image.crop(halfWidth, halfHeight, halfWidth, halfHeight), hints);
                        ByQuadrantReader.makeAbsolute(result.getResultPoints(), halfWidth, halfHeight);
                        return result;
                    }
                    catch (NotFoundException notFoundException4) {
                        void var1_1;
                        void var2_2;
                        void var3_3;
                        int quarterWidth = halfWidth / 2;
                        int quarterHeight = halfHeight / 2;
                        BinaryBitmap center = image.crop(quarterWidth, quarterHeight, (int)var3_3, halfHeight);
                        Result result = this.delegate.decode(center, (Map<DecodeHintType, ?>)var2_2);
                        ByQuadrantReader.makeAbsolute(result.getResultPoints(), quarterWidth, quarterHeight);
                        return var1_1;
                    }
                }
            }
        }
    }

    @Override
    public final void reset() {
        this.delegate.reset();
    }

    private static void makeAbsolute(ResultPoint[] points, int leftOffset, int topOffset) {
        if (points != null) {
            for (int i = 0; i < points.length; ++i) {
                ResultPoint relative = points[i];
                points[i] = new ResultPoint(relative.getX() + (float)leftOffset, relative.getY() + (float)topOffset);
            }
        }
    }
}

