/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.C40Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

final class X12Encoder
extends C40Encoder {
    X12Encoder() {
    }

    @Override
    public final int getEncodingMode() {
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void encode(EncoderContext context) {
        void var2_2;
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        while (context.hasMoreCharacters()) {
            void var3_3;
            char c = context.getCurrentChar();
            ++context.pos;
            this.encodeChar(c, buffer);
            if (buffer.length() % 3 != 0) continue;
            X12Encoder.writeNextTriplet(context, buffer);
            int newMode = HighLevelEncoder.lookAheadTest(context.getMessage(), context.pos, this.getEncodingMode());
            if (newMode == this.getEncodingMode()) continue;
            context.signalEncoderChange((int)var3_3);
            break;
        }
        this.handleEOD((EncoderContext)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int encodeChar(char c, StringBuilder sb) {
        if (c == '\r') {
            sb.append('\u0000');
        } else if (c == '*') {
            sb.append('\u0001');
        } else if (c == '>') {
            sb.append('\u0002');
        } else if (c == ' ') {
            sb.append('\u0003');
        } else if (c >= '0' && c <= '9') {
            sb.append((char)(c - 48 + 4));
        } else if (c >= 'A' && c <= 'Z') {
            void var2_2;
            var2_2.append((char)(c - 65 + 14));
        } else {
            void var1_1;
            HighLevelEncoder.illegalCharacter((char)var1_1);
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void handleEOD(EncoderContext context, StringBuilder buffer) {
        void var3_4;
        void var2_3;
        context.updateSymbolInfo();
        int available = context.getSymbolInfo().getDataCapacity() - context.getCodewordCount();
        int count = buffer.length();
        context.pos -= var2_3;
        if (context.getRemainingCharacters() > 1 || available > 1 || context.getRemainingCharacters() != var3_4) {
            context.writeCodeword('\u00fe');
        }
        if (context.getNewEncoding() < 0) {
            void var1_1;
            var1_1.signalEncoderChange(0);
        }
    }
}

