/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.Dimension;
import com.google.zxing.datamatrix.encoder.SymbolInfo;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import java.nio.charset.Charset;

final class EncoderContext {
    private final String msg;
    private SymbolShapeHint shape;
    private Dimension minSize;
    private Dimension maxSize;
    private final StringBuilder codewords;
    int pos;
    private int newEncoding;
    private SymbolInfo symbolInfo;
    private int skipAtEnd;

    /*
     * WARNING - void declaration
     */
    EncoderContext(String msg) {
        void var1_1;
        void var3_3;
        byte[] msgBinary = msg.getBytes(Charset.forName("ISO-8859-1"));
        StringBuilder sb = new StringBuilder(msgBinary.length);
        int c = msgBinary.length;
        for (int i = 0; i < c; ++i) {
            char ch = (char)(msgBinary[i] & 0xFF);
            if (ch == '?' && msg.charAt(i) != '?') {
                throw new IllegalArgumentException("Message contains characters outside ISO-8859-1 encoding.");
            }
            sb.append(ch);
        }
        this.msg = var3_3.toString();
        this.shape = SymbolShapeHint.FORCE_NONE;
        this.codewords = new StringBuilder(var1_1.length());
        this.newEncoding = -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSymbolShape(SymbolShapeHint shape) {
        void var1_1;
        this.shape = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSizeConstraints(Dimension minSize, Dimension maxSize) {
        void var2_2;
        void var1_1;
        this.minSize = var1_1;
        this.maxSize = var2_2;
    }

    public final String getMessage() {
        return this.msg;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSkipAtEnd(int count) {
        void var1_1;
        this.skipAtEnd = var1_1;
    }

    public final char getCurrentChar() {
        return this.msg.charAt(this.pos);
    }

    public final char getCurrent() {
        return this.msg.charAt(this.pos);
    }

    public final StringBuilder getCodewords() {
        return this.codewords;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeCodewords(String codewords) {
        void var1_1;
        this.codewords.append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeCodeword(char codeword) {
        void var1_1;
        this.codewords.append((char)var1_1);
    }

    public final int getCodewordCount() {
        return this.codewords.length();
    }

    public final int getNewEncoding() {
        return this.newEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public final void signalEncoderChange(int encoding) {
        void var1_1;
        this.newEncoding = var1_1;
    }

    public final void resetEncoderSignal() {
        this.newEncoding = -1;
    }

    public final boolean hasMoreCharacters() {
        return this.pos < this.getTotalMessageCharCount();
    }

    private int getTotalMessageCharCount() {
        return this.msg.length() - this.skipAtEnd;
    }

    public final int getRemainingCharacters() {
        return this.getTotalMessageCharCount() - this.pos;
    }

    public final SymbolInfo getSymbolInfo() {
        return this.symbolInfo;
    }

    public final void updateSymbolInfo() {
        EncoderContext encoderContext = this;
        encoderContext.updateSymbolInfo(encoderContext.getCodewordCount());
    }

    /*
     * WARNING - void declaration
     */
    public final void updateSymbolInfo(int len) {
        if (this.symbolInfo == null || len > this.symbolInfo.getDataCapacity()) {
            void var1_1;
            this.symbolInfo = SymbolInfo.lookup((int)var1_1, this.shape, this.minSize, this.maxSize, true);
        }
    }

    public final void resetSymbolInfo() {
        this.symbolInfo = null;
    }
}

