/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.common.detector.WhiteRectangleDetector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class Detector {
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    /*
     * WARNING - void declaration
     */
    public Detector(BitMatrix image) throws NotFoundException {
        void var1_1;
        this.image = image;
        this.rectangleDetector = new WhiteRectangleDetector((BitMatrix)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final DetectorResult detect() throws NotFoundException {
        void var1_1;
        BitMatrix bits;
        ResultPoint correctedTopRight;
        ResultPoint topRight;
        ResultPoint[] cornerPoints = this.rectangleDetector.detect();
        ResultPoint pointA = cornerPoints[0];
        ResultPoint pointB = cornerPoints[1];
        ResultPoint pointC = cornerPoints[2];
        ResultPoint pointD = cornerPoints[3];
        ArrayList<ResultPointsAndTransitions> transitions = new ArrayList<ResultPointsAndTransitions>(4);
        transitions.add(this.transitionsBetween(pointA, pointB));
        transitions.add(this.transitionsBetween(pointA, pointC));
        transitions.add(this.transitionsBetween(pointB, pointD));
        transitions.add(this.transitionsBetween(pointC, pointD));
        Collections.sort(transitions, new ResultPointsAndTransitionsComparator());
        ResultPointsAndTransitions lSideOne = (ResultPointsAndTransitions)transitions.get(0);
        ResultPointsAndTransitions lSideTwo = (ResultPointsAndTransitions)transitions.get(1);
        HashMap<ResultPoint, Integer> pointCount = new HashMap<ResultPoint, Integer>();
        Detector.increment(pointCount, lSideOne.getFrom());
        Detector.increment(pointCount, lSideOne.getTo());
        Detector.increment(pointCount, lSideTwo.getFrom());
        Detector.increment(pointCount, lSideTwo.getTo());
        ResultPoint maybeTopLeft = null;
        ResultPoint bottomLeft = null;
        ResultPoint maybeBottomRight = null;
        for (Map.Entry entry : pointCount.entrySet()) {
            ResultPoint point = (ResultPoint)entry.getKey();
            if ((Integer)entry.getValue() == 2) {
                bottomLeft = point;
                continue;
            }
            if (maybeTopLeft == null) {
                maybeTopLeft = point;
                continue;
            }
            maybeBottomRight = point;
        }
        if (maybeTopLeft == null || bottomLeft == null || maybeBottomRight == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        ResultPoint[] corners = new ResultPoint[]{maybeTopLeft, bottomLeft, maybeBottomRight};
        ResultPoint.orderBestPatterns(corners);
        ResultPoint bottomRight = corners[0];
        bottomLeft = corners[1];
        ResultPoint topLeft = corners[2];
        if (!pointCount.containsKey(pointA)) {
            topRight = pointA;
        } else if (!pointCount.containsKey(pointB)) {
            topRight = pointB;
        } else if (!pointCount.containsKey(pointC)) {
            topRight = pointC;
        }
        int dimensionTop = this.transitionsBetween(topLeft, topRight).getTransitions();
        int dimensionRight = this.transitionsBetween(bottomRight, topRight).getTransitions();
        if ((dimensionTop & 1) == 1) {
            ++dimensionTop;
        }
        dimensionTop += 2;
        if ((dimensionRight & 1) == 1) {
            ++dimensionRight;
        }
        if (4 * dimensionTop >= (dimensionRight += 2) * 7 || 4 * dimensionRight >= dimensionTop * 7) {
            correctedTopRight = this.correctTopRightRectangular(bottomLeft, bottomRight, topLeft, topRight, dimensionTop, dimensionRight);
            if (correctedTopRight == null) {
                correctedTopRight = topRight;
            }
            dimensionTop = this.transitionsBetween(topLeft, correctedTopRight).getTransitions();
            dimensionRight = this.transitionsBetween(bottomRight, correctedTopRight).getTransitions();
            if ((dimensionTop & 1) == 1) {
                ++dimensionTop;
            }
            if ((dimensionRight & 1) == 1) {
                ++dimensionRight;
            }
            bits = Detector.sampleGrid(this.image, topLeft, bottomLeft, bottomRight, correctedTopRight, dimensionTop, dimensionRight);
        } else {
            void var2_4;
            void var3_6;
            int dimension = Math.min((int)var3_6, dimensionTop);
            correctedTopRight = this.correctTopRight(bottomLeft, bottomRight, topLeft, (ResultPoint)((Object)bits), (int)var2_4);
            if (correctedTopRight == null) {
                correctedTopRight = bits;
            }
            int dimensionCorrected = Math.max(this.transitionsBetween(topLeft, correctedTopRight).getTransitions(), this.transitionsBetween(bottomRight, correctedTopRight).getTransitions());
            if ((++dimensionCorrected & 1) == 1) {
                // empty if block
            }
            int n = ++dimensionCorrected;
            bits = Detector.sampleGrid(this.image, topLeft, bottomLeft, bottomRight, correctedTopRight, n, n);
        }
        return new DetectorResult((BitMatrix)var1_1, new ResultPoint[]{topLeft, bottomLeft, bottomRight, correctedTopRight});
    }

    /*
     * WARNING - void declaration
     */
    private ResultPoint correctTopRightRectangular(ResultPoint bottomLeft, ResultPoint bottomRight, ResultPoint topLeft, ResultPoint topRight, int dimensionTop, int dimensionRight) {
        void var1_1;
        void var2_3;
        void var3_4;
        float corr = (float)Detector.distance(bottomLeft, bottomRight) / (float)dimensionTop;
        int norm = Detector.distance(topLeft, topRight);
        float cos = (topRight.getX() - topLeft.getX()) / (float)norm;
        float sin322 = (topRight.getY() - topLeft.getY()) / (float)norm;
        ResultPoint c1 = new ResultPoint(topRight.getX() + corr * cos, topRight.getY() + corr * sin322);
        corr = (float)Detector.distance(bottomLeft, topLeft) / (float)dimensionRight;
        int sin322 = Detector.distance(bottomRight, topRight);
        cos = (topRight.getX() - bottomRight.getX()) / (float)sin322;
        float sin322 = (topRight.getY() - bottomRight.getY()) / (float)sin322;
        ResultPoint c2 = new ResultPoint(topRight.getX() + corr * cos, topRight.getY() + corr * sin322);
        if (!this.isValid(c1)) {
            if (this.isValid(c2)) {
                return c2;
            }
            return null;
        }
        if (!this.isValid(c2)) {
            return c1;
        }
        int l1 = Math.abs(dimensionTop - this.transitionsBetween(topLeft, c1).getTransitions()) + Math.abs(dimensionRight - this.transitionsBetween(bottomRight, c1).getTransitions());
        int l2 = Math.abs(dimensionTop - this.transitionsBetween((ResultPoint)var3_4, c2).getTransitions()) + Math.abs(dimensionRight - this.transitionsBetween(bottomRight, c2).getTransitions());
        if (l1 <= var2_3) {
            return c1;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ResultPoint correctTopRight(ResultPoint bottomLeft, ResultPoint bottomRight, ResultPoint topLeft, ResultPoint topRight, int dimension) {
        void var1_1;
        void var2_3;
        void var3_4;
        float corr = (float)Detector.distance(bottomLeft, bottomRight) / (float)dimension;
        int norm = Detector.distance(topLeft, topRight);
        float cos = (topRight.getX() - topLeft.getX()) / (float)norm;
        float sin322 = (topRight.getY() - topLeft.getY()) / (float)norm;
        ResultPoint c1 = new ResultPoint(topRight.getX() + corr * cos, topRight.getY() + corr * sin322);
        corr = (float)Detector.distance(bottomLeft, topLeft) / (float)dimension;
        int sin322 = Detector.distance(bottomRight, topRight);
        cos = (topRight.getX() - bottomRight.getX()) / (float)sin322;
        float sin322 = (topRight.getY() - bottomRight.getY()) / (float)sin322;
        ResultPoint c2 = new ResultPoint(topRight.getX() + corr * cos, topRight.getY() + corr * sin322);
        if (!this.isValid(c1)) {
            if (this.isValid(c2)) {
                return c2;
            }
            return null;
        }
        if (!this.isValid(c2)) {
            return c1;
        }
        int l1 = Math.abs(this.transitionsBetween(topLeft, c1).getTransitions() - this.transitionsBetween(bottomRight, c1).getTransitions());
        int l2 = Math.abs(this.transitionsBetween((ResultPoint)var3_4, c2).getTransitions() - this.transitionsBetween(bottomRight, c2).getTransitions());
        if (l1 <= var2_3) {
            return c1;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValid(ResultPoint p) {
        void var1_1;
        return p.getX() >= 0.0f && p.getX() < (float)this.image.getWidth() && p.getY() > 0.0f && var1_1.getY() < (float)this.image.getHeight();
    }

    /*
     * WARNING - void declaration
     */
    private static int distance(ResultPoint a, ResultPoint b) {
        void var1_1;
        return MathUtils.round(ResultPoint.distance(a, (ResultPoint)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static void increment(Map<ResultPoint, Integer> table, ResultPoint key) {
        void var2_2;
        void var1_1;
        Map<ResultPoint, Integer> map;
        Integer value = table.get(key);
        map.put((ResultPoint)var1_1, value == null ? 1 : var2_2.intValue() + 1);
    }

    /*
     * WARNING - void declaration
     */
    private static BitMatrix sampleGrid(BitMatrix image, ResultPoint topLeft, ResultPoint bottomLeft, ResultPoint bottomRight, ResultPoint topRight, int dimensionX, int dimensionY) throws NotFoundException {
        void var2_2;
        void var3_3;
        void var1_1;
        BitMatrix bitMatrix;
        return GridSampler.getInstance().sampleGrid(bitMatrix, dimensionX, dimensionY, 0.5f, 0.5f, (float)dimensionX - 0.5f, 0.5f, (float)dimensionX - 0.5f, (float)dimensionY - 0.5f, 0.5f, (float)dimensionY - 0.5f, topLeft.getX(), var1_1.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), var3_3.getY(), bottomLeft.getX(), var2_2.getY());
    }

    /*
     * WARNING - void declaration
     */
    private ResultPointsAndTransitions transitionsBetween(ResultPoint from, ResultPoint to) {
        void var2_2;
        void var1_1;
        int x;
        int fromX = (int)from.getX();
        int fromY = (int)from.getY();
        int toX = (int)to.getX();
        int toY = (int)to.getY();
        boolean steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            int temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        int dx = Math.abs(toX - fromX);
        int dy = Math.abs(toY - fromY);
        int error = -dx / 2;
        int ystep = fromY < toY ? 1 : -1;
        int xstep = fromX < toX ? 1 : -1;
        int transitions = 0;
        boolean inBlack = this.image.get(steep ? fromY : fromX, steep ? fromX : fromY);
        int y = fromY;
        while (x != toX) {
            boolean isBlack = this.image.get(steep ? y : x, steep ? x : y);
            if (isBlack != inBlack) {
                ++transitions;
                inBlack = isBlack;
            }
            if ((error += dy) > 0) {
                if (y == toY) break;
                y += ystep;
                error -= dx;
            }
            x += xstep;
        }
        return new ResultPointsAndTransitions((ResultPoint)var1_1, (ResultPoint)var2_2, transitions);
    }

    private static final class ResultPointsAndTransitionsComparator
    implements Serializable,
    Comparator<ResultPointsAndTransitions> {
        private ResultPointsAndTransitionsComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(ResultPointsAndTransitions o1, ResultPointsAndTransitions o2) {
            void var2_2;
            return o1.getTransitions() - var2_2.getTransitions();
        }
    }

    private static final class ResultPointsAndTransitions {
        private final ResultPoint from;
        private final ResultPoint to;
        private final int transitions;

        /*
         * WARNING - void declaration
         */
        private ResultPointsAndTransitions(ResultPoint from, ResultPoint to, int transitions) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.from = var1_1;
            this.to = var2_2;
            this.transitions = var3_3;
        }

        final ResultPoint getFrom() {
            return this.from;
        }

        final ResultPoint getTo() {
            return this.to;
        }

        final int getTransitions() {
            return this.transitions;
        }

        public final String toString() {
            return this.from + "/" + this.to + '/' + this.transitions;
        }
    }
}

