/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.DecoderResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT2_SET_CHARS = C40_SHIFT2_SET_CHARS;
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};

    private DecodedBitStreamParser() {
    }

    /*
     * WARNING - void declaration
     */
    static DecoderResult decode(byte[] bytes) throws FormatException {
        void var2_2;
        byte[] byArray;
        BitSource bits = new BitSource(bytes);
        StringBuilder result = new StringBuilder(100);
        StringBuilder resultTrailer = new StringBuilder(0);
        ArrayList<byte[]> byteSegments = new ArrayList<byte[]>(1);
        Mode mode = Mode.ASCII_ENCODE;
        do {
            if (mode == Mode.ASCII_ENCODE) {
                mode = DecodedBitStreamParser.decodeAsciiSegment(bits, result, resultTrailer);
                continue;
            }
            switch (mode) {
                case C40_ENCODE: {
                    DecodedBitStreamParser.decodeC40Segment(bits, result);
                    break;
                }
                case TEXT_ENCODE: {
                    DecodedBitStreamParser.decodeTextSegment(bits, result);
                    break;
                }
                case ANSIX12_ENCODE: {
                    DecodedBitStreamParser.decodeAnsiX12Segment(bits, result);
                    break;
                }
                case EDIFACT_ENCODE: {
                    DecodedBitStreamParser.decodeEdifactSegment(bits, result);
                    break;
                }
                case BASE256_ENCODE: {
                    DecodedBitStreamParser.decodeBase256Segment(bits, result, byteSegments);
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
            mode = Mode.ASCII_ENCODE;
        } while (mode != Mode.PAD_ENCODE && bits.available() > 0);
        if (resultTrailer.length() > 0) {
            void var3_3;
            result.append((CharSequence)var3_3);
        }
        return new DecoderResult(byArray, var2_2.toString(), byteSegments.isEmpty() ? null : byteSegments, null);
    }

    /*
     * WARNING - void declaration
     */
    private static Mode decodeAsciiSegment(BitSource bits, StringBuilder result, StringBuilder resultTrailer) throws FormatException {
        boolean upperShift = false;
        do {
            void var4_4;
            int oneByte;
            if ((oneByte = bits.readBits(8)) == 0) {
                throw FormatException.getFormatInstance();
            }
            if (oneByte <= 128) {
                if (upperShift) {
                    oneByte += 128;
                }
                result.append((char)(oneByte - 1));
                return Mode.ASCII_ENCODE;
            }
            if (oneByte == 129) {
                return Mode.PAD_ENCODE;
            }
            if (oneByte <= 229) {
                int value = oneByte - 130;
                if (value < 10) {
                    result.append('0');
                }
                result.append(value);
                continue;
            }
            if (var4_4 == 230) {
                return Mode.C40_ENCODE;
            }
            if (var4_4 == 231) {
                return Mode.BASE256_ENCODE;
            }
            if (var4_4 == 232) {
                result.append('\u001d');
                continue;
            }
            if (var4_4 == 233 || var4_4 == 234) continue;
            if (var4_4 == 235) {
                upperShift = true;
                continue;
            }
            if (var4_4 == 236) {
                result.append("[)>\u001e05\u001d");
                resultTrailer.insert(0, "\u001e\u0004");
                continue;
            }
            if (var4_4 == 237) {
                result.append("[)>\u001e06\u001d");
                resultTrailer.insert(0, "\u001e\u0004");
                continue;
            }
            if (var4_4 == 238) {
                return Mode.ANSIX12_ENCODE;
            }
            if (var4_4 == 239) {
                return Mode.TEXT_ENCODE;
            }
            if (var4_4 == 240) {
                return Mode.EDIFACT_ENCODE;
            }
            if (var4_4 == 241 || var4_4 < 242 || var4_4 == 254 && bits.available() == 0) continue;
            throw FormatException.getFormatInstance();
        } while (bits.available() > 0);
        return Mode.ASCII_ENCODE;
    }

    /*
     * WARNING - void declaration
     */
    private static void decodeC40Segment(BitSource bits, StringBuilder result) throws FormatException {
        boolean upperShift = false;
        int[] cValues = new int[3];
        int shift = 0;
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            block7: for (int i = 0; i < 3; ++i) {
                int cValue = cValues[i];
                switch (shift) {
                    case 0: {
                        char c40char;
                        if (cValue < 3) {
                            shift = cValue + 1;
                            continue block7;
                        }
                        if (cValue < C40_BASIC_SET_CHARS.length) {
                            c40char = C40_BASIC_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append((char)(c40char + 128));
                                upperShift = false;
                                continue block7;
                            }
                            result.append(c40char);
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        char c40char;
                        if (upperShift) {
                            result.append((char)(c40char + 128));
                            upperShift = false;
                        } else {
                            result.append(c40char);
                        }
                        shift = 0;
                        continue block7;
                    }
                    case 2: {
                        void var6_6;
                        char c40char;
                        if (c40char < C40_SHIFT2_SET_CHARS.length) {
                            c40char = C40_SHIFT2_SET_CHARS[c40char];
                            if (upperShift) {
                                result.append((char)(c40char + 128));
                                upperShift = false;
                            } else {
                                result.append(c40char);
                            }
                        } else if (var6_6 == 27) {
                            result.append('\u001d');
                        } else if (var6_6 == 30) {
                            upperShift = true;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        shift = 0;
                        continue block7;
                    }
                    case 3: {
                        void var6_6;
                        if (upperShift) {
                            result.append((char)(var6_6 + 224));
                            upperShift = false;
                        } else {
                            result.append((char)(var6_6 + 96));
                        }
                        shift = 0;
                        continue block7;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bits.available() > 0);
    }

    private static void decodeTextSegment(BitSource bits, StringBuilder result) throws FormatException {
        boolean upperShift = false;
        int[] cValues = new int[3];
        int shift = 0;
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            block7: for (int i = 0; i < 3; ++i) {
                int cValue = cValues[i];
                switch (shift) {
                    case 0: {
                        char textChar;
                        if (cValue < 3) {
                            shift = cValue + 1;
                            continue block7;
                        }
                        if (cValue < TEXT_BASIC_SET_CHARS.length) {
                            textChar = TEXT_BASIC_SET_CHARS[cValue];
                            if (upperShift) {
                                result.append((char)(textChar + 128));
                                upperShift = false;
                                continue block7;
                            }
                            result.append(textChar);
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        char textChar;
                        if (upperShift) {
                            result.append((char)(textChar + 128));
                            upperShift = false;
                        } else {
                            result.append(textChar);
                        }
                        shift = 0;
                        continue block7;
                    }
                    case 2: {
                        char textChar;
                        if (textChar < TEXT_SHIFT2_SET_CHARS.length) {
                            textChar = TEXT_SHIFT2_SET_CHARS[textChar];
                            if (upperShift) {
                                result.append((char)(textChar + 128));
                                upperShift = false;
                            } else {
                                result.append(textChar);
                            }
                        } else if (textChar == '\u001b') {
                            result.append('\u001d');
                        } else if (textChar == '\u001e') {
                            upperShift = true;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        shift = 0;
                        continue block7;
                    }
                    case 3: {
                        char textChar;
                        if (textChar < TEXT_SHIFT3_SET_CHARS.length) {
                            textChar = TEXT_SHIFT3_SET_CHARS[textChar];
                            if (upperShift) {
                                result.append((char)(textChar + 128));
                                upperShift = false;
                            } else {
                                result.append(textChar);
                            }
                            shift = 0;
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bits.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bits, StringBuilder result) throws FormatException {
        int[] cValues = new int[3];
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            for (int i = 0; i < 3; ++i) {
                int cValue = cValues[i];
                if (cValue == 0) {
                    result.append('\r');
                    continue;
                }
                if (cValue == 1) {
                    result.append('*');
                    continue;
                }
                if (cValue == 2) {
                    result.append('>');
                    continue;
                }
                if (cValue == 3) {
                    result.append(' ');
                    continue;
                }
                if (cValue < 14) {
                    result.append((char)(cValue + 44));
                    continue;
                }
                if (cValue < 40) {
                    result.append((char)(cValue + 51));
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (bits.available() > 0);
    }

    /*
     * WARNING - void declaration
     */
    private static void parseTwoBytes(int firstByte, int secondByte, int[] result) {
        void var1_1;
        int n;
        int temp;
        int fullBitValue = (firstByte << 8) + secondByte - 1;
        result[0] = temp = fullBitValue / 1600;
        fullBitValue -= temp * 1600;
        result[1] = temp = fullBitValue / 40;
        var2_2[2] = n - var1_1 * 40;
    }

    /*
     * WARNING - void declaration
     */
    private static void decodeEdifactSegment(BitSource bits, StringBuilder result) {
        do {
            if (bits.available() <= 16) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                void var3_4;
                void var1_1;
                int edifactValue = bits.readBits(6);
                if (edifactValue == 31) {
                    int bitsLeft = 8 - bits.getBitOffset();
                    if (bitsLeft != 8) {
                        void var1_2;
                        bits.readBits((int)var1_2);
                    }
                    return;
                }
                if ((edifactValue & 0x20) == 0) {
                    edifactValue |= 0x40;
                }
                var1_1.append((char)var3_4);
            }
        } while (bits.available() > 0);
    }

    /*
     * WARNING - void declaration
     */
    private static void decodeBase256Segment(BitSource bits, StringBuilder result, Collection<byte[]> byteSegments) throws FormatException {
        void var2_2;
        int count;
        int codewordPosition = 1 + bits.getByteOffset();
        int d1 = DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++);
        if (d1 == 0) {
            count = bits.available() / 8;
        } else if (count >= 250) {
            count = 250 * (count - 249) + DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++);
        }
        if (count < 0) {
            throw FormatException.getFormatInstance();
        }
        byte[] bytes = new byte[count];
        for (int i = 0; i < count; ++i) {
            if (bits.available() < 8) {
                throw FormatException.getFormatInstance();
            }
            bytes[i] = (byte)DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++);
        }
        var2_2.add(bytes);
        try {
            void var1_1;
            var1_1.append(new String(bytes, "ISO8859_1"));
            return;
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException("Platform does not support required encoding: ".concat(String.valueOf(uee)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int unrandomize255State(int randomizedBase256Codeword, int base256CodewordPosition) {
        int n;
        void var1_1;
        int pseudoRandomNumber = base256CodewordPosition * 149 % 255 + 1;
        int tempVariable = randomizedBase256Codeword - var1_1;
        if (tempVariable >= 0) {
            return tempVariable;
        }
        return n + 256;
    }

    private static enum Mode {
        PAD_ENCODE,
        ASCII_ENCODE,
        C40_ENCODE,
        TEXT_ENCODE,
        ANSIX12_ENCODE,
        EDIFACT_ENCODE,
        BASE256_ENCODE;

    }
}

