/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.datamatrix.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    /*
     * WARNING - void declaration
     */
    private DataBlock(int numDataCodewords, byte[] codewords) {
        void var2_2;
        void var1_1;
        this.numDataCodewords = var1_1;
        this.codewords = var2_2;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version) {
        byte[] byArray;
        int i;
        Version.ECB[] ecBlockArray;
        Version.ECBlocks ecBlocks = version.getECBlocks();
        int totalBlocks = 0;
        Version.ECB[] eCBArray = ecBlockArray = ecBlocks.getECBlocks();
        int n = ecBlockArray.length;
        for (int j = 0; j < n; ++j) {
            Version.ECB ecBlock = eCBArray[j];
            totalBlocks += ecBlock.getCount();
        }
        DataBlock[] result = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        Version.ECB[] eCBArray2 = ecBlockArray;
        int ecBlock = ecBlockArray.length;
        for (totalBlocks = 0; totalBlocks < ecBlock; ++totalBlocks) {
            Version.ECB ecBlock2 = eCBArray2[totalBlocks];
            for (i = 0; i < ecBlock2.getCount(); ++i) {
                int numDataCodewords = ecBlock2.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewords() + numDataCodewords;
                result[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
            }
        }
        int longerBlocksNumDataCodewords = result[0].codewords.length - ecBlocks.getECCodewords();
        int shorterBlocksNumDataCodewords = longerBlocksNumDataCodewords - 1;
        int rawCodewordsOffset = 0;
        for (i = 0; i < shorterBlocksNumDataCodewords; ++i) {
            for (int j = 0; j < numResultBlocks; ++j) {
                result[j].codewords[i] = rawCodewords[rawCodewordsOffset++];
            }
        }
        boolean specialVersion = version.getVersionNumber() == 24;
        int numLongerBlocks = specialVersion ? 8 : numResultBlocks;
        for (int j = 0; j < numLongerBlocks; ++j) {
            result[j].codewords[longerBlocksNumDataCodewords - 1] = rawCodewords[rawCodewordsOffset++];
        }
        int max = result[0].codewords.length;
        for (int i2 = longerBlocksNumDataCodewords; i2 < max; ++i2) {
            for (int j = 0; j < numResultBlocks; ++j) {
                int jOffset = specialVersion ? (j + 8) % numResultBlocks : j;
                int iOffset = specialVersion && jOffset > 7 ? i2 - 1 : i2;
                result[var3_5].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
            }
        }
        if (rawCodewordsOffset != byArray.length) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    final int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    final byte[] getCodewords() {
        return this.codewords;
    }
}

