/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.GenericGFPoly;
import java.util.ArrayList;
import java.util.List;

public final class ReedSolomonEncoder {
    private final GenericGF field;
    private final List<GenericGFPoly> cachedGenerators;

    /*
     * WARNING - void declaration
     */
    public ReedSolomonEncoder(GenericGF field) {
        void var1_1;
        this.field = field;
        this.cachedGenerators = new ArrayList<GenericGFPoly>();
        this.cachedGenerators.add(new GenericGFPoly((GenericGF)var1_1, new int[]{1}));
    }

    /*
     * WARNING - void declaration
     */
    private GenericGFPoly buildGenerator(int degree) {
        void var1_1;
        if (degree >= this.cachedGenerators.size()) {
            GenericGFPoly lastGenerator = this.cachedGenerators.get(this.cachedGenerators.size() - 1);
            for (int d = this.cachedGenerators.size(); d <= degree; ++d) {
                GenericGFPoly nextGenerator = lastGenerator.multiply(new GenericGFPoly(this.field, new int[]{1, this.field.exp(d - 1 + this.field.getGeneratorBase())}));
                this.cachedGenerators.add(nextGenerator);
            }
        }
        return this.cachedGenerators.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void encode(int[] toEncode, int ecBytes) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (ecBytes == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int dataBytes = toEncode.length - ecBytes;
        if (dataBytes <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        GenericGFPoly generator = this.buildGenerator(ecBytes);
        int[] infoCoefficients = new int[dataBytes];
        System.arraycopy(toEncode, 0, infoCoefficients, 0, dataBytes);
        int[] coefficients = new GenericGFPoly(this.field, infoCoefficients).multiplyByMonomial(ecBytes, 1).divide(generator)[1].getCoefficients();
        int numZeroCoefficients = ecBytes - coefficients.length;
        for (int i = 0; i < numZeroCoefficients; ++i) {
            toEncode[dataBytes + i] = 0;
        }
        System.arraycopy(coefficients, 0, var1_1, (int)(var3_3 + var2_2), coefficients.length);
    }
}

