/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGFPoly;

public final class GenericGF {
    public static final GenericGF AZTEC_DATA_12 = new GenericGF(4201, 4096, 1);
    public static final GenericGF AZTEC_DATA_10 = new GenericGF(1033, 1024, 1);
    public static final GenericGF AZTEC_DATA_6 = new GenericGF(67, 64, 1);
    public static final GenericGF AZTEC_PARAM = new GenericGF(19, 16, 1);
    public static final GenericGF QR_CODE_FIELD_256 = new GenericGF(285, 256, 0);
    public static final GenericGF DATA_MATRIX_FIELD_256;
    public static final GenericGF AZTEC_DATA_8;
    public static final GenericGF MAXICODE_FIELD_64;
    private final int[] expTable;
    private final int[] logTable;
    private final GenericGFPoly zero;
    private final GenericGFPoly one;
    private final int size;
    private final int primitive;
    private final int generatorBase;

    public GenericGF(int primitive, int size, int b) {
        int i;
        this.primitive = primitive;
        this.size = size;
        this.generatorBase = b;
        this.expTable = new int[size];
        this.logTable = new int[size];
        int x = 1;
        for (i = 0; i < size; ++i) {
            this.expTable[i] = x;
            if ((x <<= 1) < size) continue;
            x = (x ^ primitive) & size - 1;
        }
        for (i = 0; i < size - 1; ++i) {
            this.logTable[this.expTable[i]] = i;
        }
        this.zero = new GenericGFPoly(this, new int[]{0});
        this.one = new GenericGFPoly(this, new int[]{1});
    }

    final GenericGFPoly getZero() {
        return this.zero;
    }

    final GenericGFPoly getOne() {
        return this.one;
    }

    /*
     * WARNING - void declaration
     */
    final GenericGFPoly buildMonomial(int degree, int coefficient) {
        void var1_2;
        void var2_3;
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.zero;
        }
        int[] nArray = new int[degree + 1];
        int[] coefficients = nArray;
        nArray[0] = var2_3;
        return new GenericGFPoly(this, (int[])var1_2);
    }

    /*
     * WARNING - void declaration
     */
    static int addOrSubtract(int a, int b) {
        void var1_1;
        return a ^ var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final int exp(int a) {
        void var1_1;
        return this.expTable[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    final int log(int a) {
        void var1_1;
        if (a == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    final int inverse(int a) {
        void var1_1;
        if (a == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.size - this.logTable[var1_1] - 1];
    }

    /*
     * WARNING - void declaration
     */
    final int multiply(int a, int b) {
        void var2_2;
        void var1_1;
        if (a == 0 || b == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[var1_1] + this.logTable[var2_2]) % (this.size - 1)];
    }

    public final int getSize() {
        return this.size;
    }

    public final int getGeneratorBase() {
        return this.generatorBase;
    }

    public final String toString() {
        return "GF(0x" + Integer.toHexString(this.primitive) + ',' + this.size + ')';
    }

    static {
        AZTEC_DATA_8 = DATA_MATRIX_FIELD_256 = new GenericGF(301, 256, 1);
        MAXICODE_FIELD_64 = AZTEC_DATA_6;
    }
}

