/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.detector.MathUtils;

public final class WhiteRectangleDetector {
    private static final int INIT_SIZE = 10;
    private static final int CORR = 1;
    private final BitMatrix image;
    private final int height;
    private final int width;
    private final int leftInit;
    private final int rightInit;
    private final int downInit;
    private final int upInit;

    /*
     * WARNING - void declaration
     */
    public WhiteRectangleDetector(BitMatrix image) throws NotFoundException {
        this(image, 10, image.getWidth() / 2, var1_1.getHeight() / 2);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WhiteRectangleDetector(BitMatrix image, int initSize, int x, int y) throws NotFoundException {
        void var1_2;
        void var3_4;
        void var2_3;
        this.image = image;
        this.height = image.getHeight();
        this.width = image.getWidth();
        void halfsize = var2_3 / 2;
        this.leftInit = x - halfsize;
        this.rightInit = var3_4 + halfsize;
        this.upInit = y - halfsize;
        this.downInit = y + var1_2;
        if (this.upInit < 0 || this.leftInit < 0 || this.downInit >= this.height || this.rightInit >= this.width) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ResultPoint[] detect() throws NotFoundException {
        int left = this.leftInit;
        int right = this.rightInit;
        int up = this.upInit;
        int down = this.downInit;
        boolean sizeExceeded = false;
        boolean aBlackPointFoundOnBorder = true;
        boolean atLeastOneBlackPointFoundOnBorder = false;
        boolean atLeastOneBlackPointFoundOnRight = false;
        boolean atLeastOneBlackPointFoundOnBottom = false;
        boolean atLeastOneBlackPointFoundOnLeft = false;
        boolean atLeastOneBlackPointFoundOnTop = false;
        while (aBlackPointFoundOnBorder) {
            aBlackPointFoundOnBorder = false;
            boolean rightBorderNotWhite = true;
            while ((rightBorderNotWhite || !atLeastOneBlackPointFoundOnRight) && right < this.width) {
                rightBorderNotWhite = this.containsBlackPoint(up, down, right, false);
                if (rightBorderNotWhite) {
                    ++right;
                    aBlackPointFoundOnBorder = true;
                    atLeastOneBlackPointFoundOnRight = true;
                    continue;
                }
                if (atLeastOneBlackPointFoundOnRight) continue;
                ++right;
            }
            if (right >= this.width) {
                sizeExceeded = true;
                break;
            }
            boolean bottomBorderNotWhite = true;
            while ((bottomBorderNotWhite || !atLeastOneBlackPointFoundOnBottom) && down < this.height) {
                bottomBorderNotWhite = this.containsBlackPoint(left, right, down, true);
                if (bottomBorderNotWhite) {
                    ++down;
                    aBlackPointFoundOnBorder = true;
                    atLeastOneBlackPointFoundOnBottom = true;
                    continue;
                }
                if (atLeastOneBlackPointFoundOnBottom) continue;
                ++down;
            }
            if (down >= this.height) {
                sizeExceeded = true;
                break;
            }
            boolean leftBorderNotWhite = true;
            while ((leftBorderNotWhite || !atLeastOneBlackPointFoundOnLeft) && left >= 0) {
                leftBorderNotWhite = this.containsBlackPoint(up, down, left, false);
                if (leftBorderNotWhite) {
                    --left;
                    aBlackPointFoundOnBorder = true;
                    atLeastOneBlackPointFoundOnLeft = true;
                    continue;
                }
                if (atLeastOneBlackPointFoundOnLeft) continue;
                --left;
            }
            if (left < 0) {
                sizeExceeded = true;
                break;
            }
            boolean topBorderNotWhite = true;
            while ((topBorderNotWhite || !atLeastOneBlackPointFoundOnTop) && up >= 0) {
                topBorderNotWhite = this.containsBlackPoint(left, right, up, true);
                if (topBorderNotWhite) {
                    --up;
                    aBlackPointFoundOnBorder = true;
                    atLeastOneBlackPointFoundOnTop = true;
                    continue;
                }
                if (atLeastOneBlackPointFoundOnTop) continue;
                --up;
            }
            if (up < 0) {
                sizeExceeded = true;
                break;
            }
            if (!aBlackPointFoundOnBorder) continue;
            atLeastOneBlackPointFoundOnBorder = true;
        }
        if (!sizeExceeded && atLeastOneBlackPointFoundOnBorder) {
            void var1_2;
            int maxSize = right - left;
            ResultPoint z = null;
            for (int i = 1; z == null && i < maxSize; ++i) {
                z = this.getBlackPointOnSegment(left, down - i, left + i, down);
            }
            if (z == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint t = null;
            for (int i = 1; t == null && i < maxSize; ++i) {
                t = this.getBlackPointOnSegment(left, up + i, left + i, up);
            }
            if (t == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint x = null;
            for (int i = 1; x == null && i < maxSize; ++i) {
                x = this.getBlackPointOnSegment(right, up + i, right - i, up);
            }
            if (x == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint y = null;
            for (int i = 1; y == null && i < maxSize; ++i) {
                y = this.getBlackPointOnSegment(right, down - i, right - i, down);
            }
            if (y == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            return this.centerEdges((ResultPoint)var1_2, z, x, t);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint getBlackPointOnSegment(float aX, float aY, float bX, float bY) {
        int dist = MathUtils.round(MathUtils.distance(aX, aY, bX, bY));
        float xStep = (bX - aX) / (float)dist;
        float yStep = (bY - aY) / (float)dist;
        for (int i = 0; i < dist; ++i) {
            int y;
            int x = MathUtils.round(aX + (float)i * xStep);
            if (!this.image.get(x, y = MathUtils.round(aY + (float)i * yStep))) continue;
            return new ResultPoint(x, y);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private ResultPoint[] centerEdges(ResultPoint y, ResultPoint z, ResultPoint x, ResultPoint t) {
        void var1_2;
        void var3_6;
        void var2_4;
        float yi = y.getX();
        float yj = y.getY();
        float zi = z.getX();
        float zj = z.getY();
        float xi = x.getX();
        float xj = x.getY();
        float ti = t.getX();
        float tj = t.getY();
        if (yi < (float)this.width / 2.0f) {
            return new ResultPoint[]{new ResultPoint(ti - 1.0f, tj + 1.0f), new ResultPoint(zi + 1.0f, zj + 1.0f), new ResultPoint(xi - 1.0f, xj - 1.0f), new ResultPoint(yi + 1.0f, yj - 1.0f)};
        }
        return new ResultPoint[]{new ResultPoint(ti + 1.0f, tj + 1.0f), new ResultPoint(zi + 1.0f, (float)(var2_4 - 1.0f)), new ResultPoint(xi - 1.0f, (float)(var3_6 + 1.0f)), new ResultPoint(yi - 1.0f, (float)(var1_2 - 1.0f))};
    }

    /*
     * WARNING - void declaration
     */
    private boolean containsBlackPoint(int a, int b, int fixed, boolean horizontal) {
        if (horizontal) {
            void x;
            while (x <= b) {
                if (this.image.get((int)x, fixed)) {
                    return true;
                }
                ++x;
            }
        } else {
            void y;
            while (y <= b) {
                if (this.image.get(fixed, (int)y)) {
                    return true;
                }
                ++y;
            }
        }
        return false;
    }
}

