/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

public final class BitSource {
    private final byte[] bytes;
    private int byteOffset;
    private int bitOffset;

    /*
     * WARNING - void declaration
     */
    public BitSource(byte[] bytes) {
        void var1_1;
        this.bytes = var1_1;
    }

    public final int getBitOffset() {
        return this.bitOffset;
    }

    public final int getByteOffset() {
        return this.byteOffset;
    }

    /*
     * WARNING - void declaration
     */
    public final int readBits(int numBits) {
        int n;
        if (numBits <= 0 || numBits > 32 || numBits > this.available()) {
            throw new IllegalArgumentException(String.valueOf(numBits));
        }
        boolean result = false;
        if (this.bitOffset > 0) {
            int bitsLeft = 8 - this.bitOffset;
            int toRead = numBits < bitsLeft ? numBits : bitsLeft;
            int bitsToNotRead = bitsLeft - toRead;
            int mask = 255 >> 8 - toRead << bitsToNotRead;
            n = (this.bytes[this.byteOffset] & mask) >> n;
            numBits -= toRead;
            this.bitOffset += toRead;
            if (this.bitOffset == 8) {
                this.bitOffset = 0;
                ++this.byteOffset;
            }
        }
        if (numBits > 0) {
            while (numBits >= 8) {
                n = n << 8 | this.bytes[this.byteOffset] & 0xFF;
                ++this.byteOffset;
                numBits -= 8;
            }
            if (numBits > 0) {
                void var1_1;
                void var3_3;
                int bitsToNotRead = 8 - numBits;
                int mask = 255 >> bitsToNotRead << bitsToNotRead;
                n = n << numBits | (this.bytes[this.byteOffset] & mask) >> var3_3;
                this.bitOffset += var1_1;
            }
        }
        return n;
    }

    public final int available() {
        return 8 * (this.bytes.length - this.byteOffset) - this.bitOffset;
    }
}

