/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import java.util.Arrays;

public final class BitArray
implements Cloneable {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    /*
     * WARNING - void declaration
     */
    public BitArray(int size) {
        void var1_1;
        this.size = size;
        this.bits = BitArray.makeArray((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    BitArray(int[] bits, int size) {
        void var2_2;
        void var1_1;
        this.bits = var1_1;
        this.size = var2_2;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureCapacity(int size) {
        if (size > this.bits.length << 5) {
            void var1_2;
            int[] newBits = BitArray.makeArray(size);
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean get(int i) {
        void var1_1;
        return (this.bits[i / 32] & 1 << (var1_1 & 0x1F)) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int i) {
        void var1_1;
        int n = i / 32;
        this.bits[n] = this.bits[n] | 1 << (var1_1 & 0x1F);
    }

    /*
     * WARNING - void declaration
     */
    public final void flip(int i) {
        void var1_1;
        int n = i / 32;
        this.bits[n] = this.bits[n] ^ 1 << (var1_1 & 0x1F);
    }

    /*
     * WARNING - void declaration
     */
    public final int getNextSet(int from) {
        void var1_1;
        void var2_2;
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from / 32;
        int currentBits = this.bits[bitsOffset] & ~((1 << (from & 0x1F)) - 1);
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = this.bits[bitsOffset];
        }
        void result = (var2_2 << 5) + Integer.numberOfTrailingZeros(currentBits);
        if (result > this.size) {
            return this.size;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getNextUnset(int from) {
        void var1_1;
        void var2_2;
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from / 32;
        int currentBits = ~this.bits[bitsOffset] & ~((1 << (from & 0x1F)) - 1);
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = ~this.bits[bitsOffset];
        }
        void result = (var2_2 << 5) + Integer.numberOfTrailingZeros(currentBits);
        if (result > this.size) {
            return this.size;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBulk(int i, int newBits) {
        void var2_2;
        this.bits[var1_1 / 32] = var2_2;
    }

    public final void setRange(int start, int end) {
        if (end < start || start < 0 || end > this.size) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return;
        }
        int firstInt = start / 32;
        int lastInt = --end / 32;
        int i = firstInt;
        while (i <= lastInt) {
            int firstBit = i > firstInt ? 0 : start & 0x1F;
            int lastBit = i < lastInt ? 31 : end & 0x1F;
            int mask = (2 << lastBit) - (1 << firstBit);
            int n = i++;
            this.bits[n] = this.bits[n] | mask;
        }
    }

    public final void clear() {
        int max = this.bits.length;
        for (int i = 0; i < max; ++i) {
            this.bits[i] = 0;
        }
    }

    public final boolean isRange(int start, int end, boolean value) {
        if (end < start || start < 0 || end > this.size) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return true;
        }
        int firstInt = start / 32;
        int lastInt = --end / 32;
        for (int i = firstInt; i <= lastInt; ++i) {
            int firstBit;
            int lastBit = i < lastInt ? 31 : end & 0x1F;
            int mask = (2 << lastBit) - (1 << (firstBit = i > firstInt ? 0 : start & 0x1F));
            if ((this.bits[i] & mask) == (value ? mask : 0)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void appendBit(boolean bit) {
        void var1_1;
        BitArray bitArray = this;
        bitArray.ensureCapacity(bitArray.size + 1);
        if (var1_1 != false) {
            int n = this.size / 32;
            this.bits[n] = this.bits[n] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void appendBits(int value, int numBits) {
        void numBitsLeft;
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        BitArray bitArray = this;
        bitArray.ensureCapacity(bitArray.size + numBits);
        while (numBitsLeft > 0) {
            this.appendBit((value >> numBitsLeft - true & 1) == 1);
            --numBitsLeft;
        }
    }

    public final void appendBitArray(BitArray other) {
        int otherSize = other.size;
        BitArray bitArray = this;
        bitArray.ensureCapacity(bitArray.size + otherSize);
        for (int i = 0; i < otherSize; ++i) {
            this.appendBit(other.get(i));
        }
    }

    public final void xor(BitArray other) {
        if (this.size != other.size) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ other.bits[i];
        }
    }

    public final void toBytes(int bitOffset, byte[] array, int offset, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            int theByte = 0;
            for (int j = 0; j < 8; ++j) {
                if (this.get(bitOffset)) {
                    theByte |= 1 << 7 - j;
                }
                ++bitOffset;
            }
            array[offset + i] = (byte)theByte;
        }
    }

    public final int[] getBitArray() {
        return this.bits;
    }

    /*
     * WARNING - void declaration
     */
    public final void reverse() {
        void var1_1;
        int[] newBits = new int[this.bits.length];
        int len = (this.size - 1) / 32;
        int oldBitsLen = len + 1;
        for (int i = 0; i < oldBitsLen; ++i) {
            long x = this.bits[i];
            x = x >> 1 & 0x55555555L | (x & 0x55555555L) << 1;
            x = x >> 2 & 0x33333333L | (x & 0x33333333L) << 2;
            x = x >> 4 & 0xF0F0F0FL | (x & 0xF0F0F0FL) << 4;
            x = x >> 8 & 0xFF00FFL | (x & 0xFF00FFL) << 8;
            x = x >> 16 & 0xFFFFL | (x & 0xFFFFL) << 16;
            newBits[len - i] = (int)x;
        }
        if (this.size != oldBitsLen << 5) {
            int leftOffset = (oldBitsLen << 5) - this.size;
            int currentInt = newBits[0] >>> leftOffset;
            for (int i = 1; i < oldBitsLen; ++i) {
                void var2_2;
                int nextInt = newBits[i];
                newBits[i - 1] = currentInt |= nextInt << 32 - leftOffset;
                currentInt = var2_2 >>> leftOffset;
            }
            newBits[var3_3 - true] = currentInt;
        }
        this.bits = var1_1;
    }

    private static int[] makeArray(int size) {
        return new int[(size + 31) / 32];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof BitArray)) {
            return false;
        }
        BitArray other = (BitArray)o;
        return this.size == other.size && Arrays.equals(this.bits, var1_1.bits);
    }

    public final int hashCode() {
        return 31 * this.size + Arrays.hashCode(this.bits);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder result = new StringBuilder(this.size);
        for (int i = 0; i < this.size; ++i) {
            if ((i & 7) == 0) {
                result.append(' ');
            }
            result.append(this.get(i) ? (char)'X' : '.');
        }
        return var1_1.toString();
    }

    public final BitArray clone() {
        return new BitArray((int[])this.bits.clone(), this.size);
    }
}

