/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.VINParsedResult;
import java.util.regex.Pattern;

public final class VINResultParser
extends ResultParser {
    private static final Pattern IOQ = Pattern.compile("[IOQ]");
    private static final Pattern AZ09 = Pattern.compile("[A-Z0-9]{17}");

    /*
     * WARNING - void declaration
     */
    @Override
    public final VINParsedResult parse(Result result) {
        if (result.getBarcodeFormat() != BarcodeFormat.CODE_39) {
            return null;
        }
        String rawText = result.getText();
        if (!AZ09.matcher(rawText = IOQ.matcher(rawText).replaceAll("").trim()).matches()) {
            return null;
        }
        try {
            void var1_1;
            void var2_2;
            if (!VINResultParser.checkChecksum(rawText)) {
                return null;
            }
            String wmi = rawText.substring(0, 3);
            return new VINParsedResult(rawText, wmi, rawText.substring(3, 9), rawText.substring(9, 17), VINResultParser.countryCode((CharSequence)var2_2), rawText.substring(3, 8), VINResultParser.modelYear(rawText.charAt(9)), rawText.charAt(10), var1_1.substring(11));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkChecksum(CharSequence vin) {
        void var0_1;
        void var2_3;
        void var1_2;
        int sum = 0;
        for (int i = 0; i < vin.length(); ++i) {
            sum += VINResultParser.vinPositionWeight(i + 1) * VINResultParser.vinCharValue(vin.charAt(i));
        }
        char checkChar = vin.charAt(8);
        char expectedCheckChar = VINResultParser.checkChar((int)(var1_2 % 11));
        return var2_3 == var0_1;
    }

    private static int vinCharValue(char c) {
        if (c >= 'A' && c <= 'I') {
            return c - 65 + 1;
        }
        if (c >= 'J' && c <= 'R') {
            return c - 74 + 1;
        }
        if (c >= 'S' && c <= 'Z') {
            return c - 83 + 2;
        }
        if (c >= '0' && c <= '9') {
            char c2;
            return c2 - 48;
        }
        throw new IllegalArgumentException();
    }

    private static int vinPositionWeight(int position) {
        if (position > 0 && position <= 7) {
            return 9 - position;
        }
        if (position == 8) {
            return 10;
        }
        if (position == 9) {
            return 0;
        }
        if (position >= 10 && position <= 17) {
            int n;
            return 19 - n;
        }
        throw new IllegalArgumentException();
    }

    private static char checkChar(int remainder) {
        int n;
        if (remainder < 10) {
            return (char)(remainder + 48);
        }
        if (n == 10) {
            return 'X';
        }
        throw new IllegalArgumentException();
    }

    private static int modelYear(char c) {
        if (c >= 'E' && c <= 'H') {
            return c - 69 + 1984;
        }
        if (c >= 'J' && c <= 'N') {
            return c - 74 + 1988;
        }
        if (c == 'P') {
            return 1993;
        }
        if (c >= 'R' && c <= 'T') {
            return c - 82 + 1994;
        }
        if (c >= 'V' && c <= 'Y') {
            return c - 86 + 1997;
        }
        if (c >= '1' && c <= '9') {
            return c - 49 + 2001;
        }
        if (c >= 'A' && c <= 'D') {
            char c2;
            return c2 - 65 + 2010;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    private static String countryCode(CharSequence wmi) {
        void var1_2;
        char c1 = wmi.charAt(0);
        char c2 = wmi.charAt(1);
        switch (var1_2) {
            case 49: 
            case 52: 
            case 53: {
                return "US";
            }
            case 50: {
                return "CA";
            }
            case 51: {
                if (c2 < 'A' || c2 > 'W') break;
                return "MX";
            }
            case 57: {
                if ((c2 < 'A' || c2 > 'E') && (c2 < '3' || c2 > '9')) break;
                return "BR";
            }
            case 74: {
                if (c2 < 'A' || c2 > 'T') break;
                return "JP";
            }
            case 75: {
                if (c2 < 'L' || c2 > 'R') break;
                return "KO";
            }
            case 76: {
                return "CN";
            }
            case 77: {
                if (c2 < 'A' || c2 > 'E') break;
                return "IN";
            }
            case 83: {
                if (c2 >= 'A' && c2 <= 'M') {
                    return "UK";
                }
                if (c2 < 'N' || c2 > 'T') break;
                return "DE";
            }
            case 86: {
                if (c2 >= 'F' && c2 <= 'R') {
                    return "FR";
                }
                if (c2 < 'S' || c2 > 'W') break;
                return "ES";
            }
            case 87: {
                return "DE";
            }
            case 88: {
                if (c2 != '0' && (c2 < '3' || c2 > '9')) break;
                return "RU";
            }
            case 90: {
                void var0_1;
                if (c2 < 'A' || var0_1 > 82) break;
                return "IT";
            }
        }
        return null;
    }
}

