/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.VCardResultParser;
import java.util.List;

public final class VEventResultParser
extends ResultParser {
    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarParsedResult parse(Result result) {
        double longitude;
        double latitude;
        String rawText = VEventResultParser.getMassagedText(result);
        if (rawText.indexOf("BEGIN:VEVENT") < 0) {
            return null;
        }
        String summary = VEventResultParser.matchSingleVCardPrefixedField("SUMMARY", rawText, true);
        String start = VEventResultParser.matchSingleVCardPrefixedField("DTSTART", rawText, true);
        if (start == null) {
            return null;
        }
        String end = VEventResultParser.matchSingleVCardPrefixedField("DTEND", rawText, true);
        String duration = VEventResultParser.matchSingleVCardPrefixedField("DURATION", rawText, true);
        String location = VEventResultParser.matchSingleVCardPrefixedField("LOCATION", rawText, true);
        String organizer = VEventResultParser.stripMailto(VEventResultParser.matchSingleVCardPrefixedField("ORGANIZER", rawText, true));
        String[] attendees = VEventResultParser.matchVCardPrefixedField("ATTENDEE", rawText, true);
        if (attendees != null) {
            for (int i = 0; i < attendees.length; ++i) {
                attendees[i] = VEventResultParser.stripMailto(attendees[i]);
            }
        }
        String description = VEventResultParser.matchSingleVCardPrefixedField("DESCRIPTION", rawText, true);
        String geoString = VEventResultParser.matchSingleVCardPrefixedField("GEO", rawText, true);
        if (geoString == null) {
            latitude = Double.NaN;
            longitude = Double.NaN;
        } else {
            int semicolon = geoString.indexOf(59);
            if (semicolon < 0) {
                return null;
            }
            try {
                void var1_1;
                latitude = Double.parseDouble(geoString.substring(0, semicolon));
                longitude = Double.parseDouble(var1_1.substring(semicolon + 1));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        try {
            void var3_3;
            void var2_2;
            return new CalendarParsedResult((String)var2_2, (String)var3_3, end, duration, location, organizer, attendees, description, latitude, longitude);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String matchSingleVCardPrefixedField(CharSequence prefix, String rawText, boolean trim) {
        List<String> list;
        void var2_2;
        void var1_1;
        List<String> values = VCardResultParser.matchSingleVCardPrefixedField(prefix, (String)var1_1, (boolean)var2_2, false);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)list.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] matchVCardPrefixedField(CharSequence prefix, String rawText, boolean trim) {
        void var2_4;
        List<List<String>> values = VCardResultParser.matchVCardPrefixedField(prefix, rawText, trim, false);
        if (values == null || values.isEmpty()) {
            return null;
        }
        int size = values.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)((List)values.get(i)).get(0);
        }
        return var2_4;
    }

    private static String stripMailto(String s) {
        String string;
        if (s != null && (s.startsWith("mailto:") || s.startsWith("MAILTO:"))) {
            s = s.substring(7);
        }
        return string;
    }
}

