/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookAUResultParser;
import com.google.zxing.client.result.AddressBookDoCoMoResultParser;
import com.google.zxing.client.result.BizcardResultParser;
import com.google.zxing.client.result.BookmarkDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressResultParser;
import com.google.zxing.client.result.EmailDoCoMoResultParser;
import com.google.zxing.client.result.ExpandedProductResultParser;
import com.google.zxing.client.result.GeoResultParser;
import com.google.zxing.client.result.ISBNResultParser;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ProductResultParser;
import com.google.zxing.client.result.SMSMMSResultParser;
import com.google.zxing.client.result.SMSTOMMSTOResultParser;
import com.google.zxing.client.result.SMTPResultParser;
import com.google.zxing.client.result.TelResultParser;
import com.google.zxing.client.result.TextParsedResult;
import com.google.zxing.client.result.URIResultParser;
import com.google.zxing.client.result.URLTOResultParser;
import com.google.zxing.client.result.VCardResultParser;
import com.google.zxing.client.result.VEventResultParser;
import com.google.zxing.client.result.VINResultParser;
import com.google.zxing.client.result.WifiResultParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ResultParser {
    private static final ResultParser[] PARSERS = new ResultParser[]{new BookmarkDoCoMoResultParser(), new AddressBookDoCoMoResultParser(), new EmailDoCoMoResultParser(), new AddressBookAUResultParser(), new VCardResultParser(), new BizcardResultParser(), new VEventResultParser(), new EmailAddressResultParser(), new SMTPResultParser(), new TelResultParser(), new SMSMMSResultParser(), new SMSTOMMSTOResultParser(), new GeoResultParser(), new WifiResultParser(), new URLTOResultParser(), new URIResultParser(), new ISBNResultParser(), new ProductResultParser(), new ExpandedProductResultParser(), new VINResultParser()};
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private static final Pattern AMPERSAND = Pattern.compile("&");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final String BYTE_ORDER_MARK = "\ufeff";

    public abstract ParsedResult parse(Result var1);

    protected static String getMassagedText(Result result) {
        Object object;
        Object text = result.getText();
        if (((String)text).startsWith(BYTE_ORDER_MARK)) {
            text = ((String)text).substring(1);
        }
        return object;
    }

    public static ParsedResult parseResult(Result theResult) {
        Result result;
        ResultParser[] resultParserArray = PARSERS;
        int n = PARSERS.length;
        for (int i = 0; i < n; ++i) {
            ParsedResult result2 = resultParserArray[i].parse(theResult);
            if (result2 == null) continue;
            return result2;
        }
        return new TextParsedResult(result.getText(), null);
    }

    /*
     * WARNING - void declaration
     */
    protected static void maybeAppend(String value, StringBuilder result) {
        if (value != null) {
            String string;
            void var1_1;
            result.append('\n');
            var1_1.append(string);
        }
    }

    protected static void maybeAppend(String[] value, StringBuilder result) {
        if (value != null) {
            String[] stringArray;
            for (String s : stringArray) {
                result.append('\n');
                result.append(s);
            }
        }
    }

    protected static String[] maybeWrap(String value) {
        String string;
        if (value == null) {
            return null;
        }
        return new String[]{string};
    }

    /*
     * WARNING - void declaration
     */
    protected static String unescapeBackslash(String escaped) {
        void var3_3;
        void i;
        int backslash = escaped.indexOf(92);
        if (backslash < 0) {
            return escaped;
        }
        int max = escaped.length();
        StringBuilder unescaped = new StringBuilder(max - 1);
        unescaped.append(escaped.toCharArray(), 0, backslash);
        boolean nextIsEscaped = false;
        while (i < max) {
            char c = escaped.charAt((int)i);
            if (nextIsEscaped || c != '\\') {
                unescaped.append(c);
                nextIsEscaped = false;
            } else {
                nextIsEscaped = true;
            }
            ++i;
        }
        return var3_3.toString();
    }

    protected static int parseHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            char c2;
            return 10 + (c2 - 65);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean isStringOfDigits(CharSequence value, int length) {
        CharSequence charSequence;
        void var1_1;
        return value != null && length > 0 && var1_1 == value.length() && DIGITS.matcher(charSequence).matches();
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean isSubstringOfDigits(CharSequence value, int offset, int length) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (value == null || length <= 0) {
            return false;
        }
        int max = offset + length;
        return value.length() >= max && DIGITS.matcher(charSequence.subSequence((int)var1_1, (int)var2_2)).matches();
    }

    /*
     * WARNING - void declaration
     */
    static Map<String, String> parseNameValuePairs(String uri) {
        void var2_2;
        int n;
        String[] stringArray;
        int paramStart = uri.indexOf(63);
        if (paramStart < 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(3);
        stringArray = AMPERSAND.split(stringArray.substring((int)(n + true)));
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ResultParser.appendKeyValue(stringArray[i], result);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void appendKeyValue(CharSequence keyValue, Map<String, String> result) {
        Object keyValueTokens = EQUALS.split(keyValue, 2);
        if (((String[])keyValueTokens).length == 2) {
            String key = keyValueTokens[0];
            Object value = keyValueTokens[1];
            try {
                Object object;
                void var2_2;
                void var1_1;
                value = ResultParser.urlDecode((String)value);
                var1_1.put(var2_2, object);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    static String urlDecode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    static String[] matchPrefixedField(String prefix, String rawText, char endChar, boolean trim) {
        ArrayList<String> matches = null;
        int i = 0;
        int max = rawText.length();
        while (i < max && (i = rawText.indexOf(prefix, i)) >= 0) {
            int start = i += prefix.length();
            boolean more = true;
            while (more) {
                if ((i = rawText.indexOf(endChar, i)) < 0) {
                    i = rawText.length();
                    more = false;
                    continue;
                }
                if (ResultParser.countPrecedingBackslashes(rawText, i) % 2 != 0) {
                    ++i;
                    continue;
                }
                if (matches == null) {
                    matches = new ArrayList<String>(3);
                }
                String element = ResultParser.unescapeBackslash(rawText.substring(start, i));
                if (trim) {
                    element = element.trim();
                }
                if (!element.isEmpty()) {
                    matches.add(element);
                }
                ++i;
                boolean bl = false;
            }
        }
        if (matches == null || matches.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = matches;
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private static int countPrecedingBackslashes(CharSequence s, int pos) {
        void var2_2;
        int count = 0;
        for (int i = pos - 1; i >= 0 && s.charAt(i) == '\\'; --i) {
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static String matchSinglePrefixedField(String prefix, String rawText, char endChar, boolean trim) {
        String[] stringArray;
        void var3_3;
        void var2_2;
        void var1_1;
        String[] matches = ResultParser.matchPrefixedField(prefix, (String)var1_1, (char)var2_2, (boolean)var3_3);
        if (matches == null) {
            return null;
        }
        return stringArray[0];
    }
}

