/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.EmailAddressParsedResult;
import com.google.zxing.client.result.EmailDoCoMoResultParser;
import com.google.zxing.client.result.ResultParser;
import java.util.Map;
import java.util.regex.Pattern;

public final class EmailAddressResultParser
extends ResultParser {
    private static final Pattern COMMA = Pattern.compile(",");

    /*
     * WARNING - void declaration
     */
    @Override
    public final EmailAddressParsedResult parse(Result result) {
        void var1_1;
        String rawText = EmailAddressResultParser.getMassagedText(result);
        if (rawText.startsWith("mailto:") || rawText.startsWith("MAILTO:")) {
            void var2_2;
            void var3_4;
            String string;
            String hostEmail = rawText.substring(7);
            int queryStart = hostEmail.indexOf(63);
            if (queryStart >= 0) {
                hostEmail = hostEmail.substring(0, queryStart);
            }
            try {
                hostEmail = EmailAddressResultParser.urlDecode(hostEmail);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            String[] tos = null;
            if (!hostEmail.isEmpty()) {
                tos = COMMA.split(hostEmail);
            }
            Map<String, String> nameValues = EmailAddressResultParser.parseNameValuePairs(rawText);
            String[] ccs = null;
            String[] bccs = null;
            Object subject = null;
            String body = null;
            if (nameValues != null) {
                String bccString;
                String ccString;
                String tosString;
                if (tos == null && (tosString = nameValues.get("to")) != null) {
                    tos = COMMA.split(tosString);
                }
                if ((ccString = nameValues.get("cc")) != null) {
                    ccs = COMMA.split(ccString);
                }
                if ((bccString = nameValues.get("bcc")) != null) {
                    bccs = COMMA.split(bccString);
                }
                string = nameValues.get("subject");
                body = (String)var1_1.get("body");
            }
            return new EmailAddressParsedResult((String[])var3_4, (String[])var2_2, bccs, string, body);
        }
        if (!EmailDoCoMoResultParser.isBasicallyValidEmailAddress((String)var1_1)) {
            return null;
        }
        return new EmailAddressParsedResult((String)var1_1);
    }
}

