/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.HighLevelEncoder;
import com.google.zxing.aztec.encoder.Token;
import com.google.zxing.common.BitArray;
import java.util.Iterator;
import java.util.LinkedList;

final class State {
    static final State INITIAL_STATE = new State(Token.EMPTY, 0, 0, 0);
    private final int mode;
    private final Token token;
    private final int binaryShiftByteCount;
    private final int bitCount;

    /*
     * WARNING - void declaration
     */
    private State(Token token, int mode, int binaryBytes, int bitCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.token = var1_1;
        this.mode = var2_2;
        this.binaryShiftByteCount = var3_3;
        this.bitCount = bitCount;
    }

    final int getMode() {
        return this.mode;
    }

    final Token getToken() {
        return this.token;
    }

    final int getBinaryShiftByteCount() {
        return this.binaryShiftByteCount;
    }

    final int getBitCount() {
        return this.bitCount;
    }

    /*
     * WARNING - void declaration
     */
    final State latchAndAppend(int mode, int value) {
        void var3_3;
        void var1_1;
        void var2_2;
        int bitCount = this.bitCount;
        Token token = this.token;
        if (mode != this.mode) {
            int latch = HighLevelEncoder.LATCH_TABLE[this.mode][mode];
            token = token.add(latch & 0xFFFF, latch >> 16);
            bitCount += latch >> 16;
        }
        int latchModeBitCount = mode == 2 ? 4 : 5;
        token = token.add((int)var2_2, latchModeBitCount);
        return new State(token, (int)var1_1, 0, (int)(var3_3 + latchModeBitCount));
    }

    /*
     * WARNING - void declaration
     */
    final State shiftAndAppend(int mode, int value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Token token = this.token;
        int thisModeBitCount = this.mode == 2 ? 4 : 5;
        token = token.add(HighLevelEncoder.SHIFT_TABLE[this.mode][var1_1], thisModeBitCount).add((int)var2_2, 5);
        return new State((Token)var3_3, this.mode, 0, this.bitCount + thisModeBitCount + 5);
    }

    /*
     * WARNING - void declaration
     */
    final State addBinaryShiftChar(int index) {
        void var2_2;
        void var3_3;
        Token token = this.token;
        int mode = this.mode;
        int bitCount = this.bitCount;
        if (this.mode == 4 || this.mode == 2) {
            int latch = HighLevelEncoder.LATCH_TABLE[mode][0];
            token = token.add(latch & 0xFFFF, latch >> 16);
            bitCount += latch >> 16;
            mode = 0;
        }
        int deltaBitCount = this.binaryShiftByteCount == 0 || this.binaryShiftByteCount == 31 ? 18 : (this.binaryShiftByteCount == 62 ? 9 : 8);
        State result = new State(token, (int)var3_3, this.binaryShiftByteCount + 1, bitCount + deltaBitCount);
        if (result.binaryShiftByteCount == 2078) {
            void var1_1;
            result = result.endBinaryShift((int)(var1_1 + true));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final State endBinaryShift(int index) {
        void var1_2;
        if (this.binaryShiftByteCount == 0) {
            return this;
        }
        Token token = this.token.addBinaryShift(index - this.binaryShiftByteCount, this.binaryShiftByteCount);
        return new State((Token)var1_2, this.mode, 0, this.bitCount);
    }

    /*
     * WARNING - void declaration
     */
    final boolean isBetterThanOrEqualTo(State other) {
        void var1_1;
        void var2_2;
        int mySize = this.bitCount + (HighLevelEncoder.LATCH_TABLE[this.mode][other.mode] >> 16);
        if (other.binaryShiftByteCount > 0 && (this.binaryShiftByteCount == 0 || this.binaryShiftByteCount > other.binaryShiftByteCount)) {
            mySize += 10;
        }
        return var2_2 <= var1_1.bitCount;
    }

    /*
     * WARNING - void declaration
     */
    final BitArray toBitArray(byte[] text) {
        void var3_3;
        Iterator iterator;
        LinkedList<Token> symbols = new LinkedList<Token>();
        for (Token token = this.endBinaryShift((int)text.length).token; token != null; token = token.getPrevious()) {
            symbols.addFirst(token);
        }
        BitArray bitArray = new BitArray();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ((Token)iterator.next()).appendTo(bitArray, text);
        }
        return var3_3;
    }

    public final String toString() {
        return String.format("%s bits=%d bytes=%d", HighLevelEncoder.MODE_NAMES[this.mode], this.bitCount, this.binaryShiftByteCount);
    }
}

