/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.State;
import com.google.zxing.common.BitArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public final class HighLevelEncoder {
    static final String[] MODE_NAMES = new String[]{"UPPER", "LOWER", "DIGIT", "MIXED", "PUNCT"};
    static final int MODE_UPPER = 0;
    static final int MODE_LOWER = 1;
    static final int MODE_DIGIT = 2;
    static final int MODE_MIXED = 3;
    static final int MODE_PUNCT = 4;
    static final int[][] LATCH_TABLE = new int[][]{{0, 327708, 327710, 327709, 656318}, {590318, 0, 327710, 327709, 656318}, {262158, 590300, 0, 590301, 932798}, {327709, 327708, 656318, 0, 327710}, {327711, 656380, 656382, 656381, 0}};
    private static final int[][] CHAR_MAP = new int[5][256];
    static final int[][] SHIFT_TABLE;
    private final byte[] text;

    /*
     * WARNING - void declaration
     */
    public HighLevelEncoder(byte[] text) {
        void var1_1;
        this.text = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final BitArray encode() {
        void var1_1;
        Collection<State> states = Collections.singletonList(State.INITIAL_STATE);
        for (int index = 0; index < this.text.length; ++index) {
            int pairCode;
            byte nextChar = index + 1 < this.text.length ? this.text[index + 1] : (byte)0;
            switch (this.text[index]) {
                case 13: {
                    pairCode = nextChar == 10 ? 2 : 0;
                    break;
                }
                case 46: {
                    pairCode = pairCode == 32 ? 3 : 0;
                    break;
                }
                case 44: {
                    pairCode = pairCode == 32 ? 4 : 0;
                    break;
                }
                case 58: {
                    pairCode = pairCode == 32 ? 5 : 0;
                    break;
                }
                default: {
                    pairCode = 0;
                }
            }
            if (pairCode > 0) {
                void var3_3;
                states = HighLevelEncoder.updateStateListForPair(states, index, (int)var3_3);
                ++index;
                continue;
            }
            states = this.updateStateListForChar(states, index);
        }
        return Collections.min(var1_1, new Comparator<State>(this){
            final /* synthetic */ HighLevelEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int compare(State a, State b) {
                void var2_2;
                return a.getBitCount() - var2_2.getBitCount();
            }
        }).toBitArray(this.text);
    }

    /*
     * WARNING - void declaration
     */
    private Collection<State> updateStateListForChar(Iterable<State> states, int index) {
        void var3_3;
        Iterator iterator;
        LinkedList<State> result = new LinkedList<State>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            this.updateStateForChar(state, index, result);
        }
        return HighLevelEncoder.simplifyStates((Iterable<State>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void updateStateForChar(State state, int index, Collection<State> result) {
        char ch = (char)(this.text[index] & 0xFF);
        boolean charInCurrentTable = CHAR_MAP[state.getMode()][ch] > 0;
        State stateNoBinary = null;
        for (int mode = 0; mode <= 4; ++mode) {
            int charInMode = CHAR_MAP[mode][ch];
            if (charInMode <= 0) continue;
            if (stateNoBinary == null) {
                stateNoBinary = state.endBinaryShift(index);
            }
            if (!charInCurrentTable || mode == state.getMode() || mode == 2) {
                State latchState = stateNoBinary.latchAndAppend(mode, charInMode);
                result.add(latchState);
            }
            if (charInCurrentTable || SHIFT_TABLE[state.getMode()][mode] < 0) continue;
            State shiftState = stateNoBinary.shiftAndAppend(mode, charInMode);
            result.add(shiftState);
        }
        if (state.getBinaryShiftByteCount() > 0 || CHAR_MAP[state.getMode()][ch] == 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            State binaryState = var1_1.addBinaryShiftChar((int)var2_2);
            var3_3.add(binaryState);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<State> updateStateListForPair(Iterable<State> states, int index, int pairCode) {
        void var3_3;
        Iterator<State> iterator;
        LinkedList<State> result = new LinkedList<State>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            HighLevelEncoder.updateStateForPair((State)iterator.next(), index, pairCode, result);
        }
        return HighLevelEncoder.simplifyStates((Iterable<State>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void updateStateForPair(State state, int index, int pairCode, Collection<State> result) {
        State stateNoBinary = state.endBinaryShift(index);
        result.add(stateNoBinary.latchAndAppend(4, pairCode));
        if (state.getMode() != 4) {
            result.add(stateNoBinary.shiftAndAppend(4, pairCode));
        }
        if (pairCode == 3 || pairCode == 4) {
            State digitState = stateNoBinary.latchAndAppend(2, 16 - pairCode).latchAndAppend(2, 1);
            result.add(digitState);
        }
        if (state.getBinaryShiftByteCount() > 0) {
            void var2_4;
            void var3_5;
            void var1_1;
            State state2;
            State binaryState = state2.addBinaryShiftChar(index).addBinaryShiftChar((int)(var1_1 + true));
            var3_5.add(var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<State> simplifyStates(Iterable<State> states) {
        void var1_1;
        Iterator<State> iterator;
        LinkedList<void> result = new LinkedList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            void var3_3;
            State newState = (State)iterator.next();
            boolean add = true;
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                State oldState = (State)iterator2.next();
                if (oldState.isBetterThanOrEqualTo(newState)) {
                    add = false;
                    break;
                }
                if (!newState.isBetterThanOrEqualTo(oldState)) continue;
                iterator2.remove();
            }
            if (var3_3 == false) continue;
            result.add(var2_2);
        }
        return var1_1;
    }

    static {
        HighLevelEncoder.CHAR_MAP[0][32] = 1;
        int c = 65;
        while (c <= 90) {
            int n = c++;
            HighLevelEncoder.CHAR_MAP[0][n] = n - 65 + 2;
        }
        HighLevelEncoder.CHAR_MAP[1][32] = 1;
        c = 97;
        while (c <= 122) {
            int n = c++;
            HighLevelEncoder.CHAR_MAP[1][n] = n - 97 + 2;
        }
        HighLevelEncoder.CHAR_MAP[2][32] = 1;
        c = 48;
        while (c <= 57) {
            int n = c++;
            HighLevelEncoder.CHAR_MAP[2][n] = n - 48 + 2;
        }
        HighLevelEncoder.CHAR_MAP[2][44] = 12;
        HighLevelEncoder.CHAR_MAP[2][46] = 13;
        int[] mixedTable = new int[]{0, 32, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 27, 28, 29, 30, 31, 64, 92, 94, 95, 96, 124, 126, 127};
        for (int i = 0; i < 28; ++i) {
            HighLevelEncoder.CHAR_MAP[3][mixedTable[i]] = i;
        }
        int[] punctTable = new int[]{0, 13, 0, 0, 0, 0, 33, 39, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 58, 59, 60, 61, 62, 63, 91, 93, 123, 125};
        for (int i = 0; i < 31; ++i) {
            if (punctTable[i] <= 0) continue;
            HighLevelEncoder.CHAR_MAP[4][punctTable[i]] = i;
        }
        SHIFT_TABLE = new int[6][6];
        int[][] nArray = SHIFT_TABLE;
        int n = SHIFT_TABLE.length;
        for (int i = 0; i < n; ++i) {
            Arrays.fill(nArray[i], -1);
        }
        HighLevelEncoder.SHIFT_TABLE[0][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][0] = 28;
        HighLevelEncoder.SHIFT_TABLE[3][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][0] = 15;
    }
}

