/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.HighLevelEncoder;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    public static AztecCode encode(byte[] data) {
        return Encoder.encode(data, 33, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static AztecCode encode(byte[] data, int minECCPercent, int userSpecifiedLayers) {
        void var3_4;
        BitArray bitArray;
        int i;
        int matrixSize;
        BitArray stuffedBits;
        int wordSize;
        int totalBitsInLayer;
        int layers;
        boolean compact;
        BitArray bitArray2 = new HighLevelEncoder(data).encode();
        BitArray bits = bitArray2;
        int eccBits = bitArray2.getSize() * minECCPercent / 100 + 11;
        int totalSizeBits = bits.getSize() + eccBits;
        if (userSpecifiedLayers != 0) {
            compact = userSpecifiedLayers < 0;
            layers = Math.abs(userSpecifiedLayers);
            if (layers > (compact ? 4 : 32)) {
                throw new IllegalArgumentException(String.format("Illegal value %s for layers", userSpecifiedLayers));
            }
            totalBitsInLayer = Encoder.totalBitsInLayer(layers, compact);
            wordSize = WORD_SIZE[layers];
            int n = totalBitsInLayer;
            int usableBitsInLayers = n - n % wordSize;
            stuffedBits = Encoder.stuffBits(bits, wordSize);
            if (stuffedBits.getSize() + eccBits > usableBitsInLayers) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            if (compact && stuffedBits.getSize() > wordSize << 6) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
        } else {
            wordSize = 0;
            stuffedBits = null;
            int i2 = 0;
            while (true) {
                if (i2 > 32) {
                    throw new IllegalArgumentException("Data too large for an Aztec code");
                }
                compact = i2 <= 3;
                layers = compact ? i2 + 1 : i2;
                totalBitsInLayer = Encoder.totalBitsInLayer(layers, compact);
                if (totalSizeBits <= totalBitsInLayer) {
                    if (wordSize != WORD_SIZE[layers]) {
                        wordSize = WORD_SIZE[layers];
                        stuffedBits = Encoder.stuffBits(bits, wordSize);
                    }
                    int n = totalBitsInLayer;
                    int usableBitsInLayers = n - n % wordSize;
                    if ((!compact || stuffedBits.getSize() <= wordSize << 6) && stuffedBits.getSize() + eccBits <= usableBitsInLayers) break;
                }
                ++i2;
            }
        }
        BitArray messageBits = Encoder.generateCheckWords(stuffedBits, totalBitsInLayer, wordSize);
        int messageSizeInWords = stuffedBits.getSize() / wordSize;
        BitArray modeMessage = Encoder.generateModeMessage(compact, layers, messageSizeInWords);
        int baseMatrixSize = (compact ? 11 : 14) + (layers << 2);
        int[] alignmentMap = new int[baseMatrixSize];
        if (compact) {
            matrixSize = baseMatrixSize;
            int i3 = 0;
            while (i3 < alignmentMap.length) {
                int n = i3++;
                alignmentMap[n] = n;
            }
        } else {
            matrixSize = baseMatrixSize + 1 + 2 * ((baseMatrixSize / 2 - 1) / 15);
            int origCenter = baseMatrixSize / 2;
            int center = matrixSize / 2;
            for (int i4 = 0; i4 < origCenter; ++i4) {
                int n = i4;
                int newOffset = n + n / 15;
                alignmentMap[origCenter - i4 - 1] = center - newOffset - 1;
                alignmentMap[origCenter + i4] = center + newOffset + 1;
            }
        }
        BitMatrix matrix = new BitMatrix(matrixSize);
        int rowOffset = 0;
        for (i = 0; i < layers; ++i) {
            int rowSize = (layers - i << 2) + (compact ? 9 : 12);
            for (int j = 0; j < rowSize; ++j) {
                int columnOffset = j << 1;
                for (int k = 0; k < 2; ++k) {
                    if (messageBits.get(rowOffset + columnOffset + k)) {
                        matrix.set(alignmentMap[(i << 1) + k], alignmentMap[(i << 1) + j]);
                    }
                    if (messageBits.get(rowOffset + (rowSize << 1) + columnOffset + k)) {
                        matrix.set(alignmentMap[(i << 1) + j], alignmentMap[baseMatrixSize - 1 - (i << 1) - k]);
                    }
                    if (messageBits.get(rowOffset + (rowSize << 2) + columnOffset + k)) {
                        matrix.set(alignmentMap[baseMatrixSize - 1 - (i << 1) - k], alignmentMap[baseMatrixSize - 1 - (i << 1) - j]);
                    }
                    if (!messageBits.get(rowOffset + rowSize * 6 + columnOffset + k)) continue;
                    matrix.set(alignmentMap[baseMatrixSize - 1 - (i << 1) - j], alignmentMap[(i << 1) + k]);
                }
            }
            rowOffset += rowSize << 3;
        }
        Encoder.drawModeMessage(matrix, compact, matrixSize, bitArray);
        if (compact) {
            Encoder.drawBullsEye(matrix, matrixSize / 2, 5);
        } else {
            Encoder.drawBullsEye(matrix, matrixSize / 2, 7);
            i = 0;
            int j = 0;
            while (i < baseMatrixSize / 2 - 1) {
                for (int k = matrixSize / 2 & 1; k < matrixSize; k += 2) {
                    matrix.set(matrixSize / 2 - j, k);
                    matrix.set(matrixSize / 2 + j, k);
                    matrix.set(k, matrixSize / 2 - j);
                    matrix.set(k, matrixSize / 2 + j);
                }
                i += 15;
                j += 16;
            }
        }
        AztecCode aztec = new AztecCode();
        aztec.setCompact(compact);
        aztec.setSize((int)var3_4);
        aztec.setLayers(layers);
        aztec.setCodeWords(messageSizeInWords);
        aztec.setMatrix(matrix);
        return aztec;
    }

    /*
     * WARNING - void declaration
     */
    private static void drawBullsEye(BitMatrix matrix, int center, int size) {
        void var2_2;
        void var1_1;
        BitMatrix bitMatrix;
        for (int i = 0; i < size; i += 2) {
            for (int j = center - i; j <= center + i; ++j) {
                matrix.set(j, center - i);
                matrix.set(j, center + i);
                matrix.set(center - i, j);
                matrix.set(center + i, j);
            }
        }
        matrix.set(center - size, center - size);
        matrix.set(center - size + 1, center - size);
        matrix.set(center - size, center - size + 1);
        matrix.set(center + size, center - size);
        matrix.set(center + size, center - size + 1);
        bitMatrix.set(center + size, (int)(var1_1 + var2_2 - true));
    }

    /*
     * WARNING - void declaration
     */
    static BitArray generateModeMessage(boolean compact, int layers, int messageSizeInWords) {
        void var3_3;
        boolean bl;
        BitArray modeMessage = new BitArray();
        if (bl) {
            modeMessage.appendBits(layers - 1, 2);
            modeMessage.appendBits(messageSizeInWords - 1, 6);
            modeMessage = Encoder.generateCheckWords(modeMessage, 28, 4);
        } else {
            void var2_2;
            void var1_1;
            modeMessage.appendBits((int)(var1_1 - true), 5);
            modeMessage.appendBits((int)(var2_2 - true), 11);
            modeMessage = Encoder.generateCheckWords(modeMessage, 40, 4);
        }
        return var3_3;
    }

    private static void drawModeMessage(BitMatrix matrix, boolean compact, int matrixSize, BitArray modeMessage) {
        int i;
        int center = matrixSize / 2;
        if (compact) {
            for (i = 0; i < 7; ++i) {
                int offset = center - 3 + i;
                if (modeMessage.get(i)) {
                    matrix.set(offset, center - 5);
                }
                if (modeMessage.get(i + 7)) {
                    matrix.set(center + 5, offset);
                }
                if (modeMessage.get(20 - i)) {
                    matrix.set(offset, center + 5);
                }
                if (!modeMessage.get(27 - i)) continue;
                matrix.set(center - 5, offset);
            }
            return;
        }
        for (i = 0; i < 10; ++i) {
            int offset = center - 5 + i + i / 5;
            if (modeMessage.get(i)) {
                matrix.set(offset, center - 7);
            }
            if (modeMessage.get(i + 10)) {
                matrix.set(center + 7, offset);
            }
            if (modeMessage.get(29 - i)) {
                matrix.set(offset, center + 7);
            }
            if (!modeMessage.get(39 - i)) continue;
            matrix.set(center - 7, offset);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static BitArray generateCheckWords(BitArray bitArray, int totalBits, int wordSize) {
        void var3_4;
        Object object;
        int n;
        int messageSizeInWords = bitArray.getSize() / wordSize;
        ReedSolomonEncoder rs = new ReedSolomonEncoder(Encoder.getGF(wordSize));
        int totalWords = totalBits / wordSize;
        Object messageWords = Encoder.bitsToWords(bitArray, wordSize, totalWords);
        rs.encode((int[])messageWords, totalWords - messageSizeInWords);
        int startPad = totalBits % wordSize;
        BitArray messageBits = new BitArray();
        messageBits.appendBits(0, n);
        for (Object messageWord : object) {
            messageBits.appendBits((int)messageWord, wordSize);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] bitsToWords(BitArray stuffedBits, int wordSize, int totalWords) {
        void var2_3;
        int[] message = new int[totalWords];
        int n = stuffedBits.getSize() / wordSize;
        for (int i = 0; i < n; ++i) {
            int value = 0;
            for (int j = 0; j < wordSize; ++j) {
                value |= stuffedBits.get(i * wordSize + j) ? 1 << wordSize - j - 1 : 0;
            }
            message[i] = value;
        }
        return var2_3;
    }

    private static GenericGF getGF(int wordSize) {
        int n;
        switch (wordSize) {
            case 4: {
                return GenericGF.AZTEC_PARAM;
            }
            case 6: {
                return GenericGF.AZTEC_DATA_6;
            }
            case 8: {
                return GenericGF.AZTEC_DATA_8;
            }
            case 10: {
                return GenericGF.AZTEC_DATA_10;
            }
            case 12: {
                return GenericGF.AZTEC_DATA_12;
            }
        }
        throw new IllegalArgumentException("Unsupported word size ".concat(String.valueOf(n)));
    }

    /*
     * WARNING - void declaration
     */
    static BitArray stuffBits(BitArray bits, int wordSize) {
        void var2_2;
        BitArray out = new BitArray();
        int n = bits.getSize();
        int mask = (1 << wordSize) - 2;
        for (int i = 0; i < n; i += wordSize) {
            int word = 0;
            for (int j = 0; j < wordSize; ++j) {
                if (i + j < n && !bits.get(i + j)) continue;
                word |= 1 << wordSize - 1 - j;
            }
            if ((word & mask) == mask) {
                out.appendBits(word & mask, wordSize);
                --i;
                continue;
            }
            if ((word & mask) == 0) {
                out.appendBits(word | 1, wordSize);
                --i;
                continue;
            }
            out.appendBits(word, wordSize);
        }
        return var2_2;
    }

    private static int totalBitsInLayer(int layers, boolean compact) {
        int n;
        return ((compact ? 88 : 112) + (layers << 4)) * n;
    }
}

