/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import java.util.Arrays;

public final class Decoder {
    private static final String[] UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
    private static final String[] PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
    private static final String[] DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    private AztecDetectorResult ddata;

    /*
     * WARNING - void declaration
     */
    public final DecoderResult decode(AztecDetectorResult detectorResult) throws FormatException {
        void var2_2;
        void var1_1;
        void var3_3;
        this.ddata = detectorResult;
        BitMatrix matrix = detectorResult.getBits();
        boolean[] rawbits = this.extractBits(matrix);
        boolean[] correctedBits = this.correctBits(rawbits);
        byte[] rawBytes = Decoder.convertBoolArrayToByteArray(correctedBits);
        String result = Decoder.getEncodedData(correctedBits);
        DecoderResult decoderResult = new DecoderResult(rawBytes, (String)var3_3, null, null);
        decoderResult.setNumBits(((void)var1_1).length);
        return var2_2;
    }

    public static String highLevelDecode(boolean[] correctedBits) {
        return Decoder.getEncodedData(correctedBits);
    }

    private static String getEncodedData(boolean[] correctedBits) {
        int endIndex = correctedBits.length;
        Table latchTable = Table.UPPER;
        Table shiftTable = Table.UPPER;
        StringBuilder result = new StringBuilder(20);
        int index = 0;
        while (index < endIndex) {
            int size;
            if (shiftTable == Table.BINARY) {
                if (endIndex - index < 5) break;
                int length = Decoder.readCode(correctedBits, index, 5);
                index += 5;
                if (length == 0) {
                    if (endIndex - index < 11) break;
                    length = Decoder.readCode(correctedBits, index, 11) + 31;
                    index += 11;
                }
                for (int charCount = 0; charCount < length; ++charCount) {
                    if (endIndex - index < 8) {
                        index = endIndex;
                        break;
                    }
                    int code = Decoder.readCode(correctedBits, index, 8);
                    result.append((char)code);
                    index += 8;
                }
                shiftTable = latchTable;
                continue;
            }
            int n = size = shiftTable == Table.DIGIT ? 4 : 5;
            if (endIndex - index < size) break;
            int code = Decoder.readCode(correctedBits, index, size);
            index += size;
            String str = Decoder.getCharacter(shiftTable, code);
            if (str.startsWith("CTRL_")) {
                latchTable = shiftTable;
                shiftTable = Decoder.getTable(str.charAt(5));
                if (str.charAt(6) != 'L') continue;
                latchTable = shiftTable;
                continue;
            }
            result.append(str);
            shiftTable = latchTable;
        }
        return result.toString();
    }

    private static Table getTable(char t) {
        switch (t) {
            case 'L': {
                return Table.LOWER;
            }
            case 'P': {
                return Table.PUNCT;
            }
            case 'M': {
                return Table.MIXED;
            }
            case 'D': {
                return Table.DIGIT;
            }
            case 'B': {
                return Table.BINARY;
            }
        }
        return Table.UPPER;
    }

    /*
     * WARNING - void declaration
     */
    private static String getCharacter(Table table, int code) {
        Table table2;
        switch (table2) {
            case UPPER: {
                return UPPER_TABLE[code];
            }
            case LOWER: {
                return LOWER_TABLE[code];
            }
            case MIXED: {
                return MIXED_TABLE[code];
            }
            case PUNCT: {
                return PUNCT_TABLE[code];
            }
            case DIGIT: {
                void var1_1;
                return DIGIT_TABLE[var1_1];
            }
        }
        throw new IllegalStateException("Bad table");
    }

    /*
     * WARNING - void declaration
     */
    private boolean[] correctBits(boolean[] rawbits) throws FormatException {
        void var2_6;
        GenericGF gf;
        int codewordSize;
        if (this.ddata.getNbLayers() <= 2) {
            codewordSize = 6;
            gf = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            codewordSize = 8;
            gf = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            codewordSize = 10;
            gf = GenericGF.AZTEC_DATA_10;
        } else {
            codewordSize = 12;
            gf = GenericGF.AZTEC_DATA_12;
        }
        int numDataCodewords = this.ddata.getNbDatablocks();
        int numCodewords = rawbits.length / codewordSize;
        if (numCodewords < numDataCodewords) {
            throw FormatException.getFormatInstance();
        }
        int offset = rawbits.length % codewordSize;
        int[] dataWords = new int[numCodewords];
        int i = 0;
        while (i < numCodewords) {
            dataWords[i] = Decoder.readCode(rawbits, offset, codewordSize);
            ++i;
            offset += codewordSize;
        }
        try {
            new ReedSolomonDecoder(gf).decode(dataWords, numCodewords - numDataCodewords);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw FormatException.getFormatInstance(reedSolomonException);
        }
        int mask = (1 << codewordSize) - 1;
        int stuffedBits = 0;
        for (int i2 = 0; i2 < numDataCodewords; ++i2) {
            int dataWord = dataWords[i2];
            if (dataWord == 0 || dataWord == mask) {
                throw FormatException.getFormatInstance();
            }
            if (dataWord != 1 && dataWord != mask - 1) continue;
            ++stuffedBits;
        }
        boolean[] correctedBits = new boolean[numDataCodewords * codewordSize - stuffedBits];
        int index = 0;
        for (int i3 = 0; i3 < numDataCodewords; ++i3) {
            int dataWord = dataWords[i3];
            if (dataWord == 1 || dataWord == mask - 1) {
                int n = index;
                Arrays.fill(correctedBits, n, n + codewordSize - 1, dataWord > 1);
                index += codewordSize - 1;
                continue;
            }
            for (int bit = codewordSize - 1; bit >= 0; --bit) {
                correctedBits[index++] = (dataWord & 1 << bit) != 0;
            }
        }
        return var2_6;
    }

    private boolean[] extractBits(BitMatrix matrix) {
        int i;
        boolean compact = this.ddata.isCompact();
        int layers = this.ddata.getNbLayers();
        int baseMatrixSize = (compact ? 11 : 14) + (layers << 2);
        int[] alignmentMap = new int[baseMatrixSize];
        boolean[] rawbits = new boolean[Decoder.totalBitsInLayer(layers, compact)];
        if (compact) {
            i = 0;
            while (i < alignmentMap.length) {
                int n = i++;
                alignmentMap[n] = n;
            }
        } else {
            int matrixSize = baseMatrixSize + 1 + 2 * ((baseMatrixSize / 2 - 1) / 15);
            int origCenter = baseMatrixSize / 2;
            int center = matrixSize / 2;
            for (int i2 = 0; i2 < origCenter; ++i2) {
                int n = i2;
                int newOffset = n + n / 15;
                alignmentMap[origCenter - i2 - 1] = center - newOffset - 1;
                alignmentMap[origCenter + i2] = center + newOffset + 1;
            }
        }
        int rowOffset = 0;
        for (i = 0; i < layers; ++i) {
            int rowSize = (layers - i << 2) + (compact ? 9 : 12);
            int low = i << 1;
            int high = baseMatrixSize - 1 - low;
            for (int j = 0; j < rowSize; ++j) {
                int columnOffset = j << 1;
                for (int k = 0; k < 2; ++k) {
                    rawbits[rowOffset + columnOffset + k] = matrix.get(alignmentMap[low + k], alignmentMap[low + j]);
                    rawbits[rowOffset + 2 * rowSize + columnOffset + k] = matrix.get(alignmentMap[low + j], alignmentMap[high - k]);
                    rawbits[rowOffset + 4 * rowSize + columnOffset + k] = matrix.get(alignmentMap[high - k], alignmentMap[high - j]);
                    rawbits[rowOffset + rowSize * 6 + columnOffset + k] = matrix.get(alignmentMap[high - j], alignmentMap[low + k]);
                }
            }
            rowOffset += rowSize << 3;
        }
        return rawbits;
    }

    /*
     * WARNING - void declaration
     */
    private static int readCode(boolean[] rawbits, int startIndex, int length) {
        void var3_3;
        int res = 0;
        for (int i = startIndex; i < startIndex + length; ++i) {
            res <<= 1;
            if (!rawbits[i]) continue;
            res |= 1;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static byte readByte(boolean[] rawbits, int startIndex) {
        void var2_2;
        void var1_1;
        boolean[] blArray;
        int n = rawbits.length - startIndex;
        if (n >= 8) {
            return (byte)Decoder.readCode(rawbits, startIndex, 8);
        }
        return (byte)(Decoder.readCode(blArray, (int)var1_1, n) << 8 - var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static byte[] convertBoolArrayToByteArray(boolean[] boolArr) {
        void var1_1;
        byte[] byteArr = new byte[(boolArr.length + 7) / 8];
        for (int i = 0; i < byteArr.length; ++i) {
            byteArr[i] = Decoder.readByte(boolArr, i << 3);
        }
        return var1_1;
    }

    private static int totalBitsInLayer(int layers, boolean compact) {
        int n;
        return ((compact ? 88 : 112) + (layers << 4)) * n;
    }

    private static enum Table {
        UPPER,
        LOWER,
        MIXED,
        DIGIT,
        PUNCT,
        BINARY;

    }
}

