/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.Encoder;
import com.google.zxing.common.BitMatrix;
import java.nio.charset.Charset;
import java.util.Map;

public final class AztecWriter
implements Writer {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.encode((String)var1_1, (BarcodeFormat)var2_2, (int)var3_3, height, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) {
        void var3_3;
        void var2_2;
        void var1_1;
        Charset charset = DEFAULT_CHARSET;
        int eccPercent = 33;
        int layers = 0;
        if (hints != null) {
            if (hints.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                charset = Charset.forName(hints.get((Object)EncodeHintType.CHARACTER_SET).toString());
            }
            if (hints.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                eccPercent = Integer.parseInt(hints.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (hints.containsKey((Object)EncodeHintType.AZTEC_LAYERS)) {
                layers = Integer.parseInt(hints.get((Object)EncodeHintType.AZTEC_LAYERS).toString());
            }
        }
        return AztecWriter.encode((String)var1_1, (BarcodeFormat)var2_2, (int)var3_3, height, charset, eccPercent, layers);
    }

    /*
     * WARNING - void declaration
     */
    private static BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Charset charset, int eccPercent, int layers) {
        void var3_3;
        void var2_2;
        String string;
        if (format != BarcodeFormat.AZTEC) {
            void var1_1;
            throw new IllegalArgumentException("Can only encode AZTEC, but got ".concat(String.valueOf(var1_1)));
        }
        return AztecWriter.renderResult(Encoder.encode(string.getBytes(charset), eccPercent, layers), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static BitMatrix renderResult(AztecCode code, int width, int height) {
        void var1_2;
        BitMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int outputWidth = Math.max(width, inputWidth);
        int outputHeight = Math.max(height, inputHeight);
        int multiple = Math.min(outputWidth / inputWidth, outputHeight / inputHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrix output = new BitMatrix(outputWidth, outputHeight);
        int inputY = 0;
        int outputY = topPadding;
        while (inputY < inputHeight) {
            int inputX = 0;
            int outputX = leftPadding;
            while (inputX < inputWidth) {
                if (input.get(inputX, inputY)) {
                    int n = multiple;
                    output.setRegion(outputX, outputY, n, n);
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        return var1_2;
    }
}

