/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.aztec.decoder.Decoder;
import com.google.zxing.aztec.detector.Detector;
import com.google.zxing.common.DecoderResult;
import java.util.List;
import java.util.Map;

public final class AztecReader
implements Reader {
    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        void var1_1;
        return this.decode((BinaryBitmap)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints2) throws NotFoundException, FormatException {
        String ecLevel;
        ResultPointCallback rpcb;
        AztecDetectorResult detectorResult;
        Object notFoundException22 = null;
        Object formatException22 = null;
        ResultPoint[] detector = new Detector(image.getBlackMatrix());
        ResultPoint[] points = null;
        DecoderResult decoderResult = null;
        try {
            detectorResult = detector.detect(false);
            points = detectorResult.getPoints();
            decoderResult = new Decoder().decode(detectorResult);
        }
        catch (NotFoundException notFoundException22) {
        }
        catch (FormatException formatException22) {
            // empty catch block
        }
        if (decoderResult == null) {
            try {
                detectorResult = detector.detect(true);
                points = detectorResult.getPoints();
                decoderResult = new Decoder().decode(detectorResult);
            }
            catch (FormatException | NotFoundException e) {
                if (notFoundException22 != null) {
                    void var3_5;
                    throw var3_5;
                }
                if (formatException22 != null) {
                    throw formatException22;
                }
                throw e;
            }
        }
        if (hints2 != null && (rpcb = (ResultPointCallback)hints2.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            detector = points;
            int hints2 = points.length;
            for (int i = 0; i < hints2; ++i) {
                ResultPoint point = detector[i];
                rpcb.foundPossibleResultPoint(point);
            }
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), decoderResult.getNumBits(), points, BarcodeFormat.AZTEC, System.currentTimeMillis());
        List<byte[]> byteSegments = decoderResult.getByteSegments();
        if (byteSegments != null) {
            void var1_1;
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, var1_1);
        }
        if ((ecLevel = decoderResult.getECLevel()) != null) {
            void var2_4;
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, var2_4);
        }
        return result;
    }

    @Override
    public final void reset() {
    }
}

