/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import java.util.EnumMap;
import java.util.Map;

public final class Result {
    private final String text;
    private final byte[] rawBytes;
    private final int numBits;
    private ResultPoint[] resultPoints;
    private final BarcodeFormat format;
    private Map<ResultMetadataType, Object> resultMetadata;
    private final long timestamp;

    /*
     * WARNING - void declaration
     */
    public Result(String text, byte[] rawBytes, ResultPoint[] resultPoints, BarcodeFormat format) {
        this((String)var1_1, (byte[])var2_2, (ResultPoint[])var3_3, format, System.currentTimeMillis());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Result(String text, byte[] rawBytes, ResultPoint[] resultPoints, BarcodeFormat format, long timestamp) {
        this((String)var1_1, rawBytes, rawBytes == null ? 0 : 8 * ((void)var2_2).length, (ResultPoint[])var3_3, format, timestamp);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Result(String text, byte[] rawBytes, int numBits, ResultPoint[] resultPoints, BarcodeFormat format, long timestamp) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.text = var1_1;
        this.rawBytes = var2_2;
        this.numBits = var3_3;
        this.resultPoints = resultPoints;
        this.format = format;
        this.resultMetadata = null;
        this.timestamp = timestamp;
    }

    public final String getText() {
        return this.text;
    }

    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    public final int getNumBits() {
        return this.numBits;
    }

    public final ResultPoint[] getResultPoints() {
        return this.resultPoints;
    }

    public final BarcodeFormat getBarcodeFormat() {
        return this.format;
    }

    public final Map<ResultMetadataType, Object> getResultMetadata() {
        return this.resultMetadata;
    }

    /*
     * WARNING - void declaration
     */
    public final void putMetadata(ResultMetadataType type, Object value) {
        void var2_2;
        void var1_1;
        if (this.resultMetadata == null) {
            this.resultMetadata = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        }
        this.resultMetadata.put((ResultMetadataType)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void putAllMetadata(Map<ResultMetadataType, Object> metadata) {
        if (metadata != null) {
            void var1_1;
            if (this.resultMetadata == null) {
                this.resultMetadata = metadata;
                return;
            }
            this.resultMetadata.putAll((Map<ResultMetadataType, Object>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addResultPoints(ResultPoint[] newPoints) {
        ResultPoint[] oldPoints = this.resultPoints;
        if (this.resultPoints == null) {
            this.resultPoints = newPoints;
            return;
        }
        if (newPoints != null && newPoints.length > 0) {
            void var3_3;
            void var1_1;
            void var2_2;
            ResultPoint[] allPoints = new ResultPoint[oldPoints.length + newPoints.length];
            System.arraycopy(oldPoints, 0, allPoints, 0, oldPoints.length);
            System.arraycopy(newPoints, 0, allPoints, ((void)var2_2).length, ((void)var1_1).length);
            this.resultPoints = var3_3;
        }
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String toString() {
        return this.text;
    }
}

