/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private static final int THUMBNAIL_SCALE_FACTOR = 2;
    private final byte[] yuvData;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    /*
     * WARNING - void declaration
     */
    public PlanarYUVLuminanceSource(byte[] yuvData, int dataWidth, int dataHeight, int left, int top, int width, int height, boolean reverseHorizontal) {
        super(width, height);
        void var3_3;
        void var2_2;
        void var1_1;
        if (left + width > dataWidth || top + height > dataHeight) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.yuvData = var1_1;
        this.dataWidth = var2_2;
        this.dataHeight = var3_3;
        this.left = left;
        this.top = top;
        if (reverseHorizontal) {
            this.reverseHorizontal(width, height);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] getRow(int y, byte[] row) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: ".concat(String.valueOf(y)));
        }
        int width = this.getWidth();
        if (row == null || row.length < width) {
            row = new byte[width];
        }
        int offset = (y + this.top) * this.dataWidth + this.left;
        System.arraycopy(this.yuvData, (int)var1_1, row, 0, (int)var3_3);
        return var2_2;
    }

    @Override
    public final byte[] getMatrix() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == this.dataWidth && height == this.dataHeight) {
            return this.yuvData;
        }
        int area = width * height;
        byte[] matrix = new byte[area];
        int inputOffset = this.top * this.dataWidth + this.left;
        if (width == this.dataWidth) {
            System.arraycopy(this.yuvData, inputOffset, matrix, 0, area);
            return matrix;
        }
        for (int y = 0; y < height; ++y) {
            int outputOffset = y * width;
            System.arraycopy(this.yuvData, inputOffset, matrix, outputOffset, width);
            inputOffset += this.dataWidth;
        }
        return matrix;
    }

    @Override
    public final boolean isCropSupported() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LuminanceSource crop(int left, int top, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new PlanarYUVLuminanceSource(this.yuvData, this.dataWidth, this.dataHeight, this.left + var1_1, this.top + var2_2, (int)var3_3, height, false);
    }

    /*
     * WARNING - void declaration
     */
    public final int[] renderThumbnail() {
        void var3_3;
        int width = this.getWidth() / 2;
        int height = this.getHeight() / 2;
        int[] pixels = new int[width * height];
        byte[] yuv = this.yuvData;
        int inputOffset = this.top * this.dataWidth + this.left;
        for (int y = 0; y < height; ++y) {
            int outputOffset = y * width;
            for (int x = 0; x < width; ++x) {
                int grey = yuv[inputOffset + (x << 1)] & 0xFF;
                pixels[outputOffset + x] = 0xFF000000 | grey * 65793;
            }
            inputOffset += this.dataWidth << 1;
        }
        return var3_3;
    }

    public final int getThumbnailWidth() {
        return this.getWidth() / 2;
    }

    public final int getThumbnailHeight() {
        return this.getHeight() / 2;
    }

    private void reverseHorizontal(int width, int height) {
        byte[] yuvData = this.yuvData;
        int y = 0;
        int rowStart = this.top * this.dataWidth + this.left;
        while (y < height) {
            int middle = rowStart + width / 2;
            int x1 = rowStart;
            int x2 = rowStart + width - 1;
            while (x1 < middle) {
                byte temp = yuvData[x1];
                yuvData[x1] = yuvData[x2];
                yuvData[x2] = temp;
                ++x1;
                --x2;
            }
            ++y;
            rowStart += this.dataWidth;
        }
    }
}

