/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.maxicode.MaxiCodeReader;
import com.google.zxing.oned.MultiFormatOneDReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatReader
implements Reader {
    private Map<DecodeHintType, ?> hints;
    private Reader[] readers;

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decode(BinaryBitmap image) throws NotFoundException {
        void var1_1;
        this.setHints(null);
        return this.decodeInternal((BinaryBitmap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        void var1_1;
        void var2_2;
        this.setHints((Map<DecodeHintType, ?>)var2_2);
        return this.decodeInternal((BinaryBitmap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Result decodeWithState(BinaryBitmap image) throws NotFoundException {
        void var1_1;
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal((BinaryBitmap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setHints(Map<DecodeHintType, ?> hints) {
        this.hints = hints;
        boolean tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER);
        Collection formats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<Reader> readers = new ArrayList<Reader>();
        if (formats != null) {
            void var3_3;
            boolean addOneDReader = formats.contains((Object)BarcodeFormat.UPC_A) || formats.contains((Object)BarcodeFormat.UPC_E) || formats.contains((Object)BarcodeFormat.EAN_13) || formats.contains((Object)BarcodeFormat.EAN_8) || formats.contains((Object)BarcodeFormat.CODABAR) || formats.contains((Object)BarcodeFormat.CODE_39) || formats.contains((Object)BarcodeFormat.CODE_93) || formats.contains((Object)BarcodeFormat.CODE_128) || formats.contains((Object)BarcodeFormat.ITF) || formats.contains((Object)BarcodeFormat.RSS_14) || formats.contains((Object)BarcodeFormat.RSS_EXPANDED);
            if (addOneDReader && !tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
            if (formats.contains((Object)BarcodeFormat.QR_CODE)) {
                readers.add(new QRCodeReader());
            }
            if (formats.contains((Object)BarcodeFormat.DATA_MATRIX)) {
                readers.add(new DataMatrixReader());
            }
            if (formats.contains((Object)BarcodeFormat.AZTEC)) {
                readers.add(new AztecReader());
            }
            if (formats.contains((Object)BarcodeFormat.PDF_417)) {
                readers.add(new PDF417Reader());
            }
            if (var3_3.contains((Object)BarcodeFormat.MAXICODE)) {
                readers.add(new MaxiCodeReader());
            }
            if (addOneDReader && tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
        }
        if (readers.isEmpty()) {
            void var2_2;
            if (!tryHarder) {
                readers.add(new MultiFormatOneDReader(hints));
            }
            readers.add(new QRCodeReader());
            readers.add(new DataMatrixReader());
            readers.add(new AztecReader());
            readers.add(new PDF417Reader());
            readers.add(new MaxiCodeReader());
            if (var2_2 != false) {
                void var1_1;
                readers.add(new MultiFormatOneDReader((Map<DecodeHintType, ?>)var1_1));
            }
        }
        ArrayList<Reader> arrayList = readers;
        this.readers = arrayList.toArray(new Reader[arrayList.size()]);
    }

    @Override
    public final void reset() {
        if (this.readers != null) {
            Reader[] readerArray = this.readers;
            int n = this.readers.length;
            for (int i = 0; i < n; ++i) {
                readerArray[i].reset();
            }
        }
    }

    private Result decodeInternal(BinaryBitmap image) throws NotFoundException {
        if (this.readers != null) {
            Reader[] readerArray = this.readers;
            int n = this.readers.length;
            for (int i = 0; i < n; ++i) {
                Reader reader = readerArray[i];
                try {
                    return reader.decode(image, this.hints);
                }
                catch (ReaderException readerException) {
                    continue;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

