/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.InvertedLuminanceSource;

public abstract class LuminanceSource {
    private final int width;
    private final int height;

    /*
     * WARNING - void declaration
     */
    protected LuminanceSource(int width, int height) {
        void var2_2;
        void var1_1;
        this.width = var1_1;
        this.height = var2_2;
    }

    public abstract byte[] getRow(int var1, byte[] var2);

    public abstract byte[] getMatrix();

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public boolean isCropSupported() {
        return false;
    }

    public LuminanceSource crop(int left, int top, int width, int height) {
        throw new UnsupportedOperationException("This luminance source does not support cropping.");
    }

    public boolean isRotateSupported() {
        return false;
    }

    public LuminanceSource invert() {
        return new InvertedLuminanceSource(this);
    }

    public LuminanceSource rotateCounterClockwise() {
        throw new UnsupportedOperationException("This luminance source does not support rotation by 90 degrees.");
    }

    public LuminanceSource rotateCounterClockwise45() {
        throw new UnsupportedOperationException("This luminance source does not support rotation by 45 degrees.");
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        byte[] row = new byte[this.width];
        StringBuilder result = new StringBuilder(this.height * (this.width + 1));
        for (int y = 0; y < this.height; ++y) {
            row = this.getRow(y, row);
            for (int x = 0; x < this.width; ++x) {
                int c;
                int luminance = row[x] & 0xFF;
                c = luminance < 64 ? 35 : (c < 128 ? 43 : (c < 192 ? 46 : 32));
                result.append((char)c);
            }
            result.append('\n');
        }
        return var2_2.toString();
    }
}

