/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByReference;
import java.awt.Rectangle;

public interface WinDef {
    public static final int MAX_PATH = 260;

    public static class HGLRCByReference
    extends WinNT.HANDLEByReference {
        public HGLRCByReference() {
        }

        /*
         * WARNING - void declaration
         */
        public HGLRCByReference(HGLRC h) {
            super((WinNT.HANDLE)var1_1);
            void var1_1;
        }
    }

    public static class HGLRC
    extends WinNT.HANDLE {
        public HGLRC() {
        }

        /*
         * WARNING - void declaration
         */
        public HGLRC(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class CHARByReference
    extends ByReference {
        public CHARByReference() {
            this(new CHAR(0L));
        }

        /*
         * WARNING - void declaration
         */
        public CHARByReference(CHAR value) {
            super(1);
            void var1_1;
            this.setValue((CHAR)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(CHAR value) {
            void var1_1;
            this.getPointer().setByte(0L, var1_1.byteValue());
        }

        public CHAR getValue() {
            return new CHAR(this.getPointer().getByte(0L));
        }
    }

    public static class CHAR
    extends IntegerType
    implements Comparable<CHAR> {
        public static final int SIZE = 1;

        public CHAR() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public CHAR(byte ch) {
            this((long)(var1_1 & 0xFF));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public CHAR(long value) {
            super(1, (long)var1_1, false);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(CHAR other) {
            void var1_1;
            return CHAR.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class BYTE
    extends UCHAR {
        public BYTE() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public BYTE(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class UCHAR
    extends IntegerType
    implements Comparable<UCHAR> {
        public static final int SIZE = 1;

        public UCHAR() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public UCHAR(char ch) {
            this((long)(var1_1 & 0xFF));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public UCHAR(long value) {
            super(1, (long)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(UCHAR other) {
            void var1_1;
            return UCHAR.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class BOOLByReference
    extends ByReference {
        public BOOLByReference() {
            this(new BOOL(0L));
        }

        /*
         * WARNING - void declaration
         */
        public BOOLByReference(BOOL value) {
            super(4);
            void var1_1;
            this.setValue((BOOL)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(BOOL value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        public BOOL getValue() {
            return new BOOL(this.getPointer().getInt(0L));
        }
    }

    public static class BOOL
    extends IntegerType
    implements Comparable<BOOL> {
        public static final int SIZE = 4;

        public BOOL() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public BOOL(boolean value) {
            this(var1_1 != false ? 1L : 0L);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public BOOL(long value) {
            super(4, value, false);
            void var1_1;
            assert (value == 0L || var1_1 == 1L);
        }

        public boolean booleanValue() {
            return this.intValue() > 0;
        }

        public String toString() {
            return Boolean.toString(this.booleanValue());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(BOOL other) {
            void var1_1;
            return BOOL.compare(this, (BOOL)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static int compare(BOOL v1, BOOL v2) {
            void var1_1;
            BOOL bOOL;
            if (v1 == v2) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return BOOL.compare(bOOL.booleanValue(), var1_1.booleanValue());
        }

        /*
         * WARNING - void declaration
         */
        public static int compare(BOOL v1, boolean v2) {
            void var1_1;
            BOOL bOOL;
            if (v1 == null) {
                return 1;
            }
            return BOOL.compare(bOOL.booleanValue(), (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static int compare(boolean v1, boolean v2) {
            boolean bl;
            void var1_1;
            if (v1 == var1_1) {
                return 0;
            }
            if (bl) {
                return 1;
            }
            return -1;
        }
    }

    public static class LCID
    extends DWORD {
        public LCID() {
            super(0L);
        }

        /*
         * WARNING - void declaration
         */
        public LCID(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class SCODEByReference
    extends ByReference {
        public SCODEByReference() {
            this(new SCODE(0L));
        }

        /*
         * WARNING - void declaration
         */
        public SCODEByReference(SCODE value) {
            super(SCODE.SIZE);
            void var1_1;
            this.setValue((SCODE)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(SCODE value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        public SCODE getValue() {
            return new SCODE(this.getPointer().getInt(0L));
        }
    }

    public static class SCODE
    extends ULONG {
        public SCODE() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public SCODE(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class UINTByReference
    extends ByReference {
        public UINTByReference() {
            this(new UINT(0L));
        }

        /*
         * WARNING - void declaration
         */
        public UINTByReference(UINT value) {
            super(4);
            void var1_1;
            this.setValue((UINT)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(UINT value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        public UINT getValue() {
            return new UINT(this.getPointer().getInt(0L));
        }
    }

    public static class UINT
    extends IntegerType
    implements Comparable<UINT> {
        public static final int SIZE = 4;

        public UINT() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public UINT(long value) {
            super(4, (long)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(UINT other) {
            void var1_1;
            return UINT.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class SHORT
    extends IntegerType
    implements Comparable<SHORT> {
        public static final int SIZE = 2;

        public SHORT() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public SHORT(long value) {
            super(2, (long)var1_1, false);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(SHORT other) {
            void var1_1;
            return SHORT.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class USHORTByReference
    extends ByReference {
        public USHORTByReference() {
            this(new USHORT(0L));
        }

        /*
         * WARNING - void declaration
         */
        public USHORTByReference(USHORT value) {
            super(2);
            void var1_1;
            this.setValue((USHORT)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public USHORTByReference(short value) {
            super(2);
            void var1_1;
            this.setValue(new USHORT((long)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(USHORT value) {
            void var1_1;
            this.getPointer().setShort(0L, var1_1.shortValue());
        }

        public USHORT getValue() {
            return new USHORT(this.getPointer().getShort(0L));
        }
    }

    public static class USHORT
    extends IntegerType
    implements Comparable<USHORT> {
        public static final int SIZE = 2;

        public USHORT() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public USHORT(long value) {
            super(2, (long)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(USHORT other) {
            void var1_1;
            return USHORT.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    @Structure.FieldOrder(value={"x", "y"})
    public static class POINT
    extends Structure {
        public int x;
        public int y;

        public POINT() {
        }

        /*
         * WARNING - void declaration
         */
        public POINT(Pointer memory) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public POINT(int x, int y) {
            void var2_2;
            void var1_1;
            this.x = var1_1;
            this.y = var2_2;
        }

        public static class ByValue
        extends POINT
        implements Structure.ByValue {
            public ByValue() {
            }

            /*
             * WARNING - void declaration
             */
            public ByValue(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ByValue(int x, int y) {
                super((int)var1_1, (int)var2_2);
                void var2_2;
                void var1_1;
            }
        }

        public static class ByReference
        extends POINT
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(int x, int y) {
                super((int)var1_1, (int)var2_2);
                void var2_2;
                void var1_1;
            }
        }
    }

    public static class LPVOID
    extends PointerType {
        public LPVOID() {
        }

        /*
         * WARNING - void declaration
         */
        public LPVOID(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class PVOID
    extends PointerType {
        public PVOID() {
        }

        /*
         * WARNING - void declaration
         */
        public PVOID(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class ATOM
    extends WORD {
        public ATOM() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public ATOM(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class HBRUSH
    extends WinNT.HANDLE {
        public HBRUSH() {
        }

        /*
         * WARNING - void declaration
         */
        public HBRUSH(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class DWORDLONG
    extends IntegerType
    implements Comparable<DWORDLONG> {
        public static final int SIZE = 8;

        public DWORDLONG() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public DWORDLONG(long value) {
            super(8, (long)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(DWORDLONG other) {
            void var1_1;
            return DWORDLONG.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class ULONGLONGByReference
    extends ByReference {
        public ULONGLONGByReference() {
            this(new ULONGLONG(0L));
        }

        /*
         * WARNING - void declaration
         */
        public ULONGLONGByReference(ULONGLONG value) {
            super(8);
            void var1_1;
            this.setValue((ULONGLONG)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(ULONGLONG value) {
            void var1_1;
            this.getPointer().setLong(0L, var1_1.longValue());
        }

        public ULONGLONG getValue() {
            return new ULONGLONG(this.getPointer().getLong(0L));
        }
    }

    public static class ULONGLONG
    extends IntegerType
    implements Comparable<ULONGLONG> {
        public static final int SIZE = 8;

        public ULONGLONG() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public ULONGLONG(long value) {
            super(8, (long)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(ULONGLONG other) {
            void var1_1;
            return ULONGLONG.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class ULONGByReference
    extends ByReference {
        public ULONGByReference() {
            this(new ULONG(0L));
        }

        /*
         * WARNING - void declaration
         */
        public ULONGByReference(ULONG value) {
            super(ULONG.SIZE);
            void var1_1;
            this.setValue((ULONG)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(ULONG value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        public ULONG getValue() {
            return new ULONG(this.getPointer().getInt(0L));
        }
    }

    public static class ULONG
    extends IntegerType
    implements Comparable<ULONG> {
        public static final int SIZE = Native.LONG_SIZE;

        public ULONG() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public ULONG(long value) {
            super(SIZE, (long)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(ULONG other) {
            void var1_1;
            return ULONG.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    @Structure.FieldOrder(value={"left", "top", "right", "bottom"})
    public static class RECT
    extends Structure {
        public int left;
        public int top;
        public int right;
        public int bottom;

        public Rectangle toRectangle() {
            return new Rectangle(this.left, this.top, this.right - this.left, this.bottom - this.top);
        }

        public String toString() {
            return "[(" + this.left + "," + this.top + ")(" + this.right + "," + this.bottom + ")]";
        }
    }

    public static class WPARAM
    extends UINT_PTR {
        public WPARAM() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public WPARAM(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class UINT_PTR
    extends IntegerType {
        public UINT_PTR() {
            super(Native.POINTER_SIZE);
        }

        /*
         * WARNING - void declaration
         */
        public UINT_PTR(long value) {
            super(Native.POINTER_SIZE, (long)var1_1, true);
            void var1_1;
        }

        public Pointer toPointer() {
            return Pointer.createConstant((long)this.longValue());
        }
    }

    public static class INT_PTR
    extends IntegerType {
        public INT_PTR() {
            super(Native.POINTER_SIZE);
        }

        /*
         * WARNING - void declaration
         */
        public INT_PTR(long value) {
            super(Native.POINTER_SIZE, (long)var1_1);
            void var1_1;
        }

        public Pointer toPointer() {
            return Pointer.createConstant((long)this.longValue());
        }
    }

    public static class LRESULT
    extends BaseTSD.LONG_PTR {
        public LRESULT() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public LRESULT(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class LPARAM
    extends BaseTSD.LONG_PTR {
        public LPARAM() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public LPARAM(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class HKL
    extends WinNT.HANDLE {
        public HKL() {
        }

        /*
         * WARNING - void declaration
         */
        public HKL(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public HKL(int i) {
            super(Pointer.createConstant((int)var1_1));
            void var1_1;
        }

        public int getLanguageIdentifier() {
            return (int)(Pointer.nativeValue((Pointer)this.getPointer()) & 0xFFFFL);
        }

        public int getDeviceHandle() {
            return (int)(Pointer.nativeValue((Pointer)this.getPointer()) >> 16 & 0xFFFFL);
        }

        @Override
        public String toString() {
            return String.format("%08x", Pointer.nativeValue((Pointer)this.getPointer()));
        }
    }

    public static class HFONT
    extends WinNT.HANDLE {
        public HFONT() {
        }

        /*
         * WARNING - void declaration
         */
        public HFONT(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HMODULE
    extends HINSTANCE {
    }

    public static class HINSTANCE
    extends WinNT.HANDLE {
    }

    public static class HWND
    extends WinNT.HANDLE {
        public HWND() {
        }

        /*
         * WARNING - void declaration
         */
        public HWND(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HRGN
    extends WinNT.HANDLE {
        public HRGN() {
        }

        /*
         * WARNING - void declaration
         */
        public HRGN(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HBITMAP
    extends WinNT.HANDLE {
        public HBITMAP() {
        }

        /*
         * WARNING - void declaration
         */
        public HBITMAP(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HPALETTE
    extends WinNT.HANDLE {
        public HPALETTE() {
        }

        /*
         * WARNING - void declaration
         */
        public HPALETTE(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HRSRC
    extends WinNT.HANDLE {
        public HRSRC() {
        }

        /*
         * WARNING - void declaration
         */
        public HRSRC(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HPEN
    extends WinNT.HANDLE {
        public HPEN() {
        }

        /*
         * WARNING - void declaration
         */
        public HPEN(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HMENU
    extends WinNT.HANDLE {
        public HMENU() {
        }

        /*
         * WARNING - void declaration
         */
        public HMENU(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HCURSOR
    extends HICON {
        public HCURSOR() {
        }

        /*
         * WARNING - void declaration
         */
        public HCURSOR(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HICON
    extends WinNT.HANDLE {
        public HICON() {
        }

        /*
         * WARNING - void declaration
         */
        public HICON(WinNT.HANDLE handle) {
            this(var1_1.getPointer());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public HICON(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class HDC
    extends WinNT.HANDLE {
        public HDC() {
        }

        /*
         * WARNING - void declaration
         */
        public HDC(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class LONGLONGByReference
    extends ByReference {
        public LONGLONGByReference() {
            this(new LONGLONG(0L));
        }

        /*
         * WARNING - void declaration
         */
        public LONGLONGByReference(LONGLONG value) {
            super(LONGLONG.SIZE);
            void var1_1;
            this.setValue((LONGLONG)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(LONGLONG value) {
            void var1_1;
            this.getPointer().setLong(0L, var1_1.longValue());
        }

        public LONGLONG getValue() {
            return new LONGLONG(this.getPointer().getLong(0L));
        }
    }

    public static class LONGLONG
    extends IntegerType
    implements Comparable<LONGLONG> {
        public static final int SIZE = Native.LONG_SIZE << 1;

        public LONGLONG() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public LONGLONG(long value) {
            super(8, (long)var1_1, false);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(LONGLONG other) {
            void var1_1;
            return LONGLONG.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class LONGByReference
    extends ByReference {
        public LONGByReference() {
            this(new LONG(0L));
        }

        /*
         * WARNING - void declaration
         */
        public LONGByReference(LONG value) {
            super(LONG.SIZE);
            void var1_1;
            this.setValue((LONG)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(LONG value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        public LONG getValue() {
            return new LONG(this.getPointer().getInt(0L));
        }
    }

    public static class LONG
    extends IntegerType
    implements Comparable<LONG> {
        public static final int SIZE = Native.LONG_SIZE;

        public LONG() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public LONG(long value) {
            super(SIZE, (long)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(LONG other) {
            void var1_1;
            return LONG.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class DWORDByReference
    extends ByReference {
        public DWORDByReference() {
            this(new DWORD(0L));
        }

        /*
         * WARNING - void declaration
         */
        public DWORDByReference(DWORD value) {
            super(4);
            void var1_1;
            this.setValue((DWORD)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(DWORD value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        public DWORD getValue() {
            return new DWORD(this.getPointer().getInt(0L));
        }
    }

    public static class DWORD
    extends IntegerType
    implements Comparable<DWORD> {
        public static final int SIZE = 4;

        public DWORD() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public DWORD(long value) {
            super(4, (long)var1_1, true);
            void var1_1;
        }

        public WORD getLow() {
            return new WORD(this.longValue() & 0xFFFFL);
        }

        public WORD getHigh() {
            return new WORD(this.longValue() >> 16 & 0xFFFFL);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(DWORD other) {
            void var1_1;
            return DWORD.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }

    public static class WORDByReference
    extends ByReference {
        public WORDByReference() {
            this(new WORD(0L));
        }

        /*
         * WARNING - void declaration
         */
        public WORDByReference(WORD value) {
            super(2);
            void var1_1;
            this.setValue((WORD)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(WORD value) {
            void var1_1;
            this.getPointer().setShort(0L, var1_1.shortValue());
        }

        public WORD getValue() {
            return new WORD(this.getPointer().getShort(0L));
        }
    }

    public static class WORD
    extends IntegerType
    implements Comparable<WORD> {
        public static final int SIZE = 2;

        public WORD() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public WORD(long value) {
            super(2, (long)var1_1, true);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(WORD other) {
            void var1_1;
            return WORD.compare((IntegerType)this, (IntegerType)var1_1);
        }
    }
}

