/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.W32Service;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;

public class W32ServiceManager
implements Closeable {
    Winsvc.SC_HANDLE _handle = null;
    String _machineName = null;
    String _databaseName = null;

    public W32ServiceManager() {
    }

    /*
     * WARNING - void declaration
     */
    public W32ServiceManager(int permissions) {
        void var1_1;
        this.open((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public W32ServiceManager(String machineName, String databaseName) {
        void var2_2;
        void var1_1;
        this._machineName = var1_1;
        this._databaseName = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public W32ServiceManager(String machineName, String databaseName, int permissions) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._machineName = var1_1;
        this._databaseName = var2_2;
        this.open((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void open(int permissions) {
        void var1_1;
        this.close();
        this._handle = Advapi32.INSTANCE.OpenSCManager(this._machineName, this._databaseName, (int)var1_1);
        if (this._handle == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    @Override
    public void close() {
        if (this._handle != null) {
            if (!Advapi32.INSTANCE.CloseServiceHandle(this._handle)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            this._handle = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public W32Service openService(String serviceName, int permissions) {
        void var1_1;
        void var2_2;
        Winsvc.SC_HANDLE serviceHandle = Advapi32.INSTANCE.OpenService(this._handle, serviceName, (int)var2_2);
        if (serviceHandle == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new W32Service((Winsvc.SC_HANDLE)var1_1);
    }

    public Winsvc.SC_HANDLE getHandle() {
        return this._handle;
    }

    /*
     * WARNING - void declaration
     */
    public Winsvc.ENUM_SERVICE_STATUS_PROCESS[] enumServicesStatusExProcess(int dwServiceType, int dwServiceState, String groupName) {
        void var1_2;
        void var3_4;
        void var2_3;
        Memory buffer;
        IntByReference pcbBytesNeeded = new IntByReference(0);
        IntByReference lpServicesReturned = new IntByReference(0);
        IntByReference lpResumeHandle = new IntByReference(0);
        Advapi32.INSTANCE.EnumServicesStatusEx(this._handle, 0, dwServiceType, dwServiceState, Pointer.NULL, 0, pcbBytesNeeded, lpServicesReturned, lpResumeHandle, groupName);
        int lastError = Kernel32.INSTANCE.GetLastError();
        if (lastError != 234) {
            throw new Win32Exception(lastError);
        }
        Memory memory = buffer = new Memory((long)pcbBytesNeeded.getValue());
        boolean bl = Advapi32.INSTANCE.EnumServicesStatusEx(this._handle, 0, dwServiceType, (int)var2_3, (Pointer)memory, (int)memory.size(), pcbBytesNeeded, lpServicesReturned, lpResumeHandle, (String)var3_4);
        dwServiceType = bl ? 1 : 0;
        if (!bl) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        if (lpServicesReturned.getValue() == 0) {
            return new Winsvc.ENUM_SERVICE_STATUS_PROCESS[0];
        }
        Winsvc.ENUM_SERVICE_STATUS_PROCESS status = (Winsvc.ENUM_SERVICE_STATUS_PROCESS)Structure.newInstance(Winsvc.ENUM_SERVICE_STATUS_PROCESS.class, (Pointer)buffer);
        status.read();
        return (Winsvc.ENUM_SERVICE_STATUS_PROCESS[])var1_2.toArray(lpServicesReturned.getValue());
    }
}

