/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.FileMonitor;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class W32FileMonitor
extends FileMonitor {
    private static final Logger LOG = Logger.getLogger(W32FileMonitor.class.getName());
    private static final int BUFFER_SIZE = 4096;
    private Thread watcher;
    private WinNT.HANDLE port;
    private final Map<File, FileInfo> fileMap = new HashMap<File, FileInfo>();
    private final Map<WinNT.HANDLE, FileInfo> handleMap = new HashMap<WinNT.HANDLE, FileInfo>();
    private boolean disposing = false;
    private static int watcherThreadID;

    /*
     * WARNING - void declaration
     */
    private void handleChanges(FileInfo finfo) throws IOException {
        Kernel32 klib = Kernel32.INSTANCE;
        WinNT.FILE_NOTIFY_INFORMATION fni = finfo.info;
        fni.read();
        do {
            FileMonitor.FileEvent event = null;
            File file = new File(finfo.file, fni.getFilename());
            switch (fni.Action) {
                case 0: {
                    break;
                }
                case 3: {
                    event = new FileMonitor.FileEvent(file, 4);
                    break;
                }
                case 1: {
                    event = new FileMonitor.FileEvent(file, 1);
                    break;
                }
                case 2: {
                    event = new FileMonitor.FileEvent(file, 2);
                    break;
                }
                case 4: {
                    event = new FileMonitor.FileEvent(file, 16);
                    break;
                }
                case 5: {
                    event = new FileMonitor.FileEvent(file, 32);
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Unrecognized file action ''{0}''", fni.Action);
                }
            }
            if (event == null) continue;
            this.notify(event);
        } while ((fni = fni.next()) != null);
        if (!finfo.file.exists()) {
            this.unwatch(finfo.file);
            return;
        }
        if (!klib.ReadDirectoryChangesW(finfo.handle, finfo.info, finfo.info.size(), finfo.recursive, finfo.notifyMask, finfo.infoLength, finfo.overlapped, null) && !this.disposing) {
            void var1_1;
            void var2_2;
            int err = var2_2.GetLastError();
            throw new IOException("ReadDirectoryChangesW failed on " + var1_1.file + ": '" + Kernel32Util.formatMessageFromLastErrorCode(err) + "' (" + err + ")");
        }
    }

    /*
     * WARNING - void declaration
     */
    private FileInfo waitForChange() {
        void var3_4;
        W32FileMonitor w32FileMonitor;
        IntByReference rcount = new IntByReference();
        BaseTSD.ULONG_PTRByReference rkey = new BaseTSD.ULONG_PTRByReference();
        PointerByReference roverlap = new PointerByReference();
        if (!Kernel32.INSTANCE.GetQueuedCompletionStatus(this.port, (IntByReference)w32FileMonitor, rkey, (PointerByReference)var3_4, -1)) {
            return null;
        }
        w32FileMonitor = this;
        synchronized (w32FileMonitor) {
            void var2_2;
            return this.handleMap.get((Object)new WinNT.HANDLE(var2_2.getValue().toPointer()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private int convertMask(int mask) {
        void var2_2;
        void var1_1;
        int result = 0;
        if ((mask & 1) != 0) {
            result = 64;
        }
        if ((mask & 2) != 0) {
            result |= 3;
        }
        if ((mask & 4) != 0) {
            result |= 0x10;
        }
        if ((mask & 0x30) != 0) {
            result |= 3;
        }
        if ((mask & 0x40) != 0) {
            result |= 8;
        }
        if ((mask & 8) != 0) {
            result |= 0x20;
        }
        if ((mask & 0x80) != 0) {
            result |= 4;
        }
        if ((var1_1 & 0x100) != 0) {
            result |= 0x100;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void watch(File file, int eventMask, boolean recursive) throws IOException {
        void var2_3;
        void var3_4;
        File dir = file;
        if (!dir.isDirectory()) {
            recursive = false;
            dir = file.getParentFile();
        }
        while (dir != null && !dir.exists()) {
            recursive = true;
            dir = dir.getParentFile();
        }
        if (dir == null) {
            throw new FileNotFoundException("No ancestor found for " + file);
        }
        Kernel32 klib = Kernel32.INSTANCE;
        WinNT.HANDLE handle = klib.CreateFile(file.getAbsolutePath(), 1, 7, null, 3, 0x42000000, null);
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)handle)) {
            throw new IOException("Unable to open " + file + " (" + klib.GetLastError() + ")");
        }
        int notifyMask = this.convertMask(eventMask);
        FileInfo finfo = new FileInfo(file, handle, notifyMask, recursive);
        this.fileMap.put(file, finfo);
        this.handleMap.put(handle, finfo);
        this.port = klib.CreateIoCompletionPort(handle, this.port, handle.getPointer(), 0);
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)this.port)) {
            throw new IOException("Unable to create/use I/O Completion port for " + file + " (" + klib.GetLastError() + ")");
        }
        if (!klib.ReadDirectoryChangesW(handle, finfo.info, finfo.info.size(), (boolean)var3_4, (int)var2_3, finfo.infoLength, finfo.overlapped, null)) {
            void var1_2;
            int err = klib.GetLastError();
            throw new IOException("ReadDirectoryChangesW failed on " + finfo.file + ", handle " + (Object)((Object)handle) + ": '" + Kernel32Util.formatMessageFromLastErrorCode(err) + "' (" + (int)var1_2 + ")");
        }
        if (this.watcher == null) {
            this.watcher = new Thread(this, "W32 File Monitor-" + watcherThreadID++){
                final /* synthetic */ W32FileMonitor this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((String)var2_2);
                }

                @Override
                public void run() {
                    while (true) {
                        IOException iOException;
                        Object finfo;
                        if ((finfo = this.this$0.waitForChange()) == null) {
                            finfo = this.this$0;
                            synchronized (finfo) {
                                if (this.this$0.fileMap.isEmpty()) {
                                    W32FileMonitor.access$202(this.this$0, null);
                                    return;
                                }
                            }
                        }
                        try {
                            W32FileMonitor.access$300(this.this$0, (FileInfo)((Object)iOException));
                            continue;
                        }
                        catch (IOException iOException2) {
                            iOException = iOException2;
                            iOException2.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            this.watcher.setDaemon(true);
            this.watcher.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void unwatch(File file) {
        FileInfo finfo = this.fileMap.remove(file);
        if (finfo != null) {
            void var1_1;
            this.handleMap.remove((Object)finfo.handle);
            Kernel32 kernel32 = Kernel32.INSTANCE;
            kernel32.CloseHandle(var1_1.handle);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void dispose() {
        void var2_2;
        this.disposing = true;
        int i = 0;
        Object[] keys = this.fileMap.keySet().toArray();
        while (!this.fileMap.isEmpty()) {
            this.unwatch((File)keys[i++]);
        }
        Kernel32 klib = Kernel32.INSTANCE;
        klib.PostQueuedCompletionStatus(this.port, 0, null, null);
        var2_2.CloseHandle(this.port);
        this.port = null;
        this.watcher = null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Thread access$202(W32FileMonitor x0, Thread x1) {
        void var1_1;
        x0.watcher = var1_1;
        return x0.watcher;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(W32FileMonitor x0, FileInfo x1) throws IOException {
        void var1_1;
        x0.handleChanges((FileInfo)var1_1);
    }

    private class FileInfo {
        public final File file;
        public final WinNT.HANDLE handle;
        public final int notifyMask;
        public final boolean recursive;
        public final WinNT.FILE_NOTIFY_INFORMATION info = new WinNT.FILE_NOTIFY_INFORMATION(4096);
        public final IntByReference infoLength = new IntByReference();
        public final WinBase.OVERLAPPED overlapped = new WinBase.OVERLAPPED();

        /*
         * WARNING - void declaration
         */
        public FileInfo(File f, WinNT.HANDLE h, int mask, boolean recurse) {
            void var3_3;
            void var2_2;
            this.file = var2_2;
            this.handle = var3_3;
            this.notifyMask = mask;
            this.recursive = recurse;
        }
    }
}

