/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.IntegerType;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.TypeComp;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.Closeable;
import java.util.Calendar;
import java.util.Date;

public interface OaIdl {
    public static final long DATE_OFFSET = new Date(-1, 11, 30, 0, 0, 0).getTime();
    public static final DISPID DISPID_COLLECT = new DISPID(-8);
    public static final DISPID DISPID_CONSTRUCTOR = new DISPID(-6);
    public static final DISPID DISPID_DESTRUCTOR = new DISPID(-7);
    public static final DISPID DISPID_EVALUATE = new DISPID(-5);
    public static final DISPID DISPID_NEWENUM = new DISPID(-4);
    public static final DISPID DISPID_PROPERTYPUT = new DISPID(-3);
    public static final DISPID DISPID_UNKNOWN = new DISPID(-1);
    public static final DISPID DISPID_VALUE = new DISPID(0);
    public static final MEMBERID MEMBERID_NIL = new MEMBERID(DISPID_UNKNOWN.intValue());
    public static final int FADF_AUTO = 1;
    public static final int FADF_STATIC = 2;
    public static final int FADF_EMBEDDED = 4;
    public static final int FADF_FIXEDSIZE = 16;
    public static final int FADF_RECORD = 32;
    public static final int FADF_HAVEIID = 64;
    public static final int FADF_HAVEVARTYPE = 128;
    public static final int FADF_BSTR = 256;
    public static final int FADF_UNKNOWN = 512;
    public static final int FADF_DISPATCH = 1024;
    public static final int FADF_VARIANT = 2048;
    public static final int FADF_RESERVED = 61448;

    @Structure.FieldOrder(value={"guid", "lcid", "dwReserved", "memidConstructor", "memidDestructor", "lpstrSchema", "cbSizeInstance", "typekind", "cFuncs", "cVars", "cImplTypes", "cbSizeVft", "cbAlignment", "wTypeFlags", "wMajorVerNum", "wMinorVerNum", "tdescAlias", "idldescType"})
    public static class TYPEATTR
    extends Structure {
        public Guid.GUID guid;
        public WinDef.LCID lcid;
        public WinDef.DWORD dwReserved;
        public MEMBERID memidConstructor;
        public MEMBERID memidDestructor;
        public WTypes.LPOLESTR lpstrSchema;
        public WinDef.ULONG cbSizeInstance;
        public TYPEKIND typekind;
        public WinDef.WORD cFuncs;
        public WinDef.WORD cVars;
        public WinDef.WORD cImplTypes;
        public WinDef.WORD cbSizeVft;
        public WinDef.WORD cbAlignment;
        public WinDef.WORD wTypeFlags;
        public WinDef.WORD wMajorVerNum;
        public WinDef.WORD wMinorVerNum;
        public TYPEDESC tdescAlias;
        public IDLDESC idldescType;
        public static final int TYPEFLAGS_FAPPOBJECT = 1;
        public static final int TYPEFLAGS_FCANCREATE = 2;
        public static final int TYPEFLAGS_FLICENSED = 4;
        public static final int TYPEFLAGS_FPREDECLID = 8;
        public static final int TYPEFLAGS_FHIDDEN = 16;
        public static final int TYPEFLAGS_FCONTROL = 32;
        public static final int TYPEFLAGS_FDUAL = 64;
        public static final int TYPEFLAGS_FNONEXTENSIBLE = 128;
        public static final int TYPEFLAGS_FOLEAUTOMATION = 256;
        public static final int TYPEFLAGS_FRESTRICTED = 512;
        public static final int TYPEFLAGS_FAGGREGATABLE = 1024;
        public static final int TYPEFLAGS_FREPLACEABLE = 2048;
        public static final int TYPEFLAGS_FDISPATCHABLE = 4096;
        public static final int TYPEFLAGS_FREVERSEBIND = 8192;
        public static final int TYPEFLAGS_FPROXY = 16384;

        public TYPEATTR() {
        }

        /*
         * WARNING - void declaration
         */
        public TYPEATTR(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends TYPEATTR
        implements Structure.ByReference {
        }
    }

    public static class HREFTYPEByReference
    extends WinDef.DWORDByReference {
        public HREFTYPEByReference() {
            this(new HREFTYPE(0L));
        }

        /*
         * WARNING - void declaration
         */
        public HREFTYPEByReference(WinDef.DWORD value) {
            super((WinDef.DWORD)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(HREFTYPE value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        @Override
        public HREFTYPE getValue() {
            return new HREFTYPE(this.getPointer().getInt(0L));
        }
    }

    public static class HREFTYPE
    extends WinDef.DWORD {
        private static final long serialVersionUID = 1L;

        public HREFTYPE() {
        }

        /*
         * WARNING - void declaration
         */
        public HREFTYPE(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    @Structure.FieldOrder(value={"cBytes", "varDefaultValue"})
    public static class PARAMDESCEX
    extends Structure {
        public WinDef.ULONG cBytes;
        public Variant.VariantArg varDefaultValue;

        public PARAMDESCEX() {
        }

        /*
         * WARNING - void declaration
         */
        public PARAMDESCEX(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends PARAMDESCEX
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"pparamdescex", "wParamFlags"})
    public static class PARAMDESC
    extends Structure {
        public Pointer pparamdescex;
        public WinDef.USHORT wParamFlags;

        public PARAMDESC() {
        }

        /*
         * WARNING - void declaration
         */
        public PARAMDESC(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends PARAMDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"tdescElem", "cDims", "rgbounds"})
    public static class ARRAYDESC
    extends Structure {
        public TYPEDESC tdescElem;
        public short cDims;
        public SAFEARRAYBOUND[] rgbounds = new SAFEARRAYBOUND[]{new SAFEARRAYBOUND()};

        public ARRAYDESC() {
        }

        /*
         * WARNING - void declaration
         */
        public ARRAYDESC(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public ARRAYDESC(TYPEDESC tdescElem, short cDims, SAFEARRAYBOUND[] rgbounds) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.tdescElem = var1_1;
            this.cDims = var2_2;
            if (rgbounds.length != this.rgbounds.length) {
                throw new IllegalArgumentException("Wrong array size !");
            }
            this.rgbounds = var3_3;
        }

        public static class ByReference
        extends ARRAYDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"dwReserved", "wIDLFlags"})
    public static class IDLDESC
    extends Structure {
        public BaseTSD.ULONG_PTR dwReserved;
        public WinDef.USHORT wIDLFlags;

        public IDLDESC() {
        }

        /*
         * WARNING - void declaration
         */
        public IDLDESC(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public IDLDESC(BaseTSD.ULONG_PTR dwReserved, WinDef.USHORT wIDLFlags) {
            void var2_2;
            void var1_1;
            this.dwReserved = var1_1;
            this.wIDLFlags = var2_2;
        }

        public static class ByReference
        extends IDLDESC
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(IDLDESC idldesc) {
                super(idldesc.dwReserved, var1_1.wIDLFlags);
                void var1_1;
            }
        }
    }

    @Structure.FieldOrder(value={"_typedesc", "vt"})
    public static class TYPEDESC
    extends Structure {
        public _TYPEDESC _typedesc;
        public WTypes.VARTYPE vt;

        public TYPEDESC() {
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public TYPEDESC(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public TYPEDESC(_TYPEDESC _typedesc, WTypes.VARTYPE vt) {
            void var2_2;
            void var1_1;
            this._typedesc = var1_1;
            this.vt = var2_2;
        }

        public static class _TYPEDESC
        extends Union {
            public ByReference lptdesc;
            public ARRAYDESC.ByReference lpadesc;
            public HREFTYPE hreftype;

            public _TYPEDESC() {
                this.setType("hreftype");
                this.read();
            }

            /*
             * WARNING - void declaration
             */
            public _TYPEDESC(Pointer pointer) {
                super((Pointer)var1_1);
                void var1_1;
                this.setType("hreftype");
                this.read();
            }

            public ByReference getLptdesc() {
                this.setType("lptdesc");
                this.read();
                return this.lptdesc;
            }

            public ARRAYDESC.ByReference getLpadesc() {
                this.setType("lpadesc");
                this.read();
                return this.lpadesc;
            }

            public HREFTYPE getHreftype() {
                this.setType("hreftype");
                this.read();
                return this.hreftype;
            }
        }

        public static class ByReference
        extends TYPEDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class VARKIND
    extends Structure {
        public static final int VAR_PERINSTANCE = 0;
        public static final int VAR_STATIC = 1;
        public static final int VAR_CONST = 2;
        public static final int VAR_DISPATCH = 3;
        public int value;

        public VARKIND() {
        }

        /*
         * WARNING - void declaration
         */
        public VARKIND(int value) {
            void var1_1;
            this.value = var1_1;
        }

        public static class ByReference
        extends VARKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class CALLCONV
    extends Structure {
        public static final int CC_FASTCALL = 0;
        public static final int CC_CDECL = 1;
        public static final int CC_MSCPASCAL = 2;
        public static final int CC_PASCAL = 2;
        public static final int CC_MACPASCAL = 3;
        public static final int CC_STDCALL = 4;
        public static final int CC_FPFASTCALL = 5;
        public static final int CC_SYSCALL = 6;
        public static final int CC_MPWCDECL = 7;
        public static final int CC_MPWPASCAL = 8;
        public static final int CC_MAX = 9;
        public int value;

        public CALLCONV() {
        }

        /*
         * WARNING - void declaration
         */
        public CALLCONV(int value) {
            void var1_1;
            this.value = var1_1;
        }

        public static class ByReference
        extends CALLCONV
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class INVOKEKIND
    extends Structure {
        public static final INVOKEKIND INVOKE_FUNC = new INVOKEKIND(1);
        public static final INVOKEKIND INVOKE_PROPERTYGET = new INVOKEKIND(2);
        public static final INVOKEKIND INVOKE_PROPERTYPUT = new INVOKEKIND(4);
        public static final INVOKEKIND INVOKE_PROPERTYPUTREF = new INVOKEKIND(8);
        public int value;

        public INVOKEKIND() {
        }

        /*
         * WARNING - void declaration
         */
        public INVOKEKIND(int value) {
            void var1_1;
            this.value = var1_1;
        }

        public static class ByReference
        extends INVOKEKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class FUNCKIND
    extends Structure {
        public static final int FUNC_VIRTUAL = 0;
        public static final int FUNC_PUREVIRTUAL = 1;
        public static final int FUNC_NONVIRTUAL = 2;
        public static final int FUNC_STATIC = 3;
        public static final int FUNC_DISPATCH = 4;
        public int value;

        public FUNCKIND() {
        }

        /*
         * WARNING - void declaration
         */
        public FUNCKIND(int value) {
            void var1_1;
            this.value = var1_1;
        }

        public static class ByReference
        extends FUNCKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"tdesc", "_elemdesc"})
    public static class ELEMDESC
    extends Structure {
        public TYPEDESC tdesc;
        public _ELEMDESC _elemdesc;

        public ELEMDESC() {
        }

        /*
         * WARNING - void declaration
         */
        public ELEMDESC(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class _ELEMDESC
        extends Union {
            public IDLDESC idldesc;
            public PARAMDESC paramdesc;

            public _ELEMDESC() {
            }

            /*
             * WARNING - void declaration
             */
            public _ELEMDESC(Pointer pointer) {
                super((Pointer)var1_1);
                void var1_1;
                this.setType("paramdesc");
                this.read();
            }

            /*
             * WARNING - void declaration
             */
            public _ELEMDESC(PARAMDESC paramdesc) {
                void var1_1;
                this.paramdesc = var1_1;
                this.setType("paramdesc");
            }

            /*
             * WARNING - void declaration
             */
            public _ELEMDESC(IDLDESC idldesc) {
                void var1_1;
                this.idldesc = var1_1;
                this.setType("idldesc");
            }

            public static class ByReference
            extends _ELEMDESC
            implements Structure.ByReference {
            }
        }

        public static class ByReference
        extends ELEMDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"memid", "lpstrSchema", "_vardesc", "elemdescVar", "wVarFlags", "varkind"})
    public static class VARDESC
    extends Structure {
        public MEMBERID memid;
        public WTypes.LPOLESTR lpstrSchema;
        public _VARDESC _vardesc;
        public ELEMDESC elemdescVar;
        public WinDef.WORD wVarFlags;
        public VARKIND varkind;

        public VARDESC() {
        }

        /*
         * WARNING - void declaration
         */
        public VARDESC(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this._vardesc.setType("lpvarValue");
            this.read();
        }

        public static class _VARDESC
        extends Union {
            public NativeLong oInst;
            public Variant.VARIANT.ByReference lpvarValue;

            public _VARDESC() {
                this.setType("lpvarValue");
                this.read();
            }

            /*
             * WARNING - void declaration
             */
            public _VARDESC(Pointer pointer) {
                super((Pointer)var1_1);
                void var1_1;
                this.setType("lpvarValue");
                this.read();
            }

            /*
             * WARNING - void declaration
             */
            public _VARDESC(Variant.VARIANT.ByReference lpvarValue) {
                void var1_1;
                this.lpvarValue = var1_1;
                this.setType("lpvarValue");
            }

            /*
             * WARNING - void declaration
             */
            public _VARDESC(NativeLong oInst) {
                void var1_1;
                this.oInst = var1_1;
                this.setType("oInst");
            }

            public static class ByReference
            extends _VARDESC
            implements Structure.ByReference {
            }
        }

        public static class ByReference
        extends VARDESC
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"scodeArg"})
    public static class ScodeArg
    extends Structure {
        public WinDef.SCODE[] scodeArg = new WinDef.SCODE[]{new WinDef.SCODE()};

        public ScodeArg() {
        }

        /*
         * WARNING - void declaration
         */
        public ScodeArg(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends ScodeArg
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"elemDescArg"})
    public static class ElemDescArg
    extends Structure {
        public ELEMDESC[] elemDescArg = new ELEMDESC[]{new ELEMDESC()};

        public ElemDescArg() {
        }

        /*
         * WARNING - void declaration
         */
        public ElemDescArg(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends ElemDescArg
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"memid", "lprgscode", "lprgelemdescParam", "funckind", "invkind", "callconv", "cParams", "cParamsOpt", "oVft", "cScodes", "elemdescFunc", "wFuncFlags"})
    public static class FUNCDESC
    extends Structure {
        public MEMBERID memid;
        public ScodeArg.ByReference lprgscode;
        public ElemDescArg.ByReference lprgelemdescParam;
        public FUNCKIND funckind;
        public INVOKEKIND invkind;
        public CALLCONV callconv;
        public WinDef.SHORT cParams;
        public WinDef.SHORT cParamsOpt;
        public WinDef.SHORT oVft;
        public WinDef.SHORT cScodes;
        public ELEMDESC elemdescFunc;
        public WinDef.WORD wFuncFlags;

        public FUNCDESC() {
        }

        /*
         * WARNING - void declaration
         */
        public FUNCDESC(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
            if (this.cParams.shortValue() > 1) {
                this.lprgelemdescParam.elemDescArg = new ELEMDESC[this.cParams.shortValue()];
                this.lprgelemdescParam.read();
            }
        }

        public static class ByReference
        extends FUNCDESC
        implements Structure.ByReference {
        }
    }

    public static class BINDPTR
    extends Union {
        public FUNCDESC lpfuncdesc;
        public VARDESC lpvardesc;
        public TypeComp lptcomp;

        public BINDPTR() {
        }

        /*
         * WARNING - void declaration
         */
        public BINDPTR(VARDESC lpvardesc) {
            void var1_1;
            this.lpvardesc = var1_1;
            this.setType(VARDESC.class);
        }

        /*
         * WARNING - void declaration
         */
        public BINDPTR(TypeComp lptcomp) {
            void var1_1;
            this.lptcomp = var1_1;
            this.setType(TypeComp.class);
        }

        /*
         * WARNING - void declaration
         */
        public BINDPTR(FUNCDESC lpfuncdesc) {
            void var1_1;
            this.lpfuncdesc = var1_1;
            this.setType(FUNCDESC.class);
        }

        public static class ByReference
        extends BINDPTR
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"guid", "lcid", "syskind", "wMajorVerNum", "wMinorVerNum", "wLibFlags"})
    public static class TLIBATTR
    extends Structure {
        public Guid.GUID guid;
        public WinDef.LCID lcid;
        public SYSKIND syskind;
        public WinDef.WORD wMajorVerNum;
        public WinDef.WORD wMinorVerNum;
        public WinDef.WORD wLibFlags;

        public TLIBATTR() {
        }

        /*
         * WARNING - void declaration
         */
        public TLIBATTR(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends TLIBATTR
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(Pointer pointer) {
                super((Pointer)var1_1);
                void var1_1;
                this.read();
            }
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class LIBFLAGS
    extends Structure {
        public int value;
        public static final int LIBFLAG_FRESTRICTED = 1;
        public static final int LIBFLAG_FCONTROL = 2;
        public static final int LIBFLAG_FHIDDEN = 4;
        public static final int LIBFLAG_FHASDISKIMAGE = 8;

        public LIBFLAGS() {
        }

        /*
         * WARNING - void declaration
         */
        public LIBFLAGS(int value) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public LIBFLAGS(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends LIBFLAGS
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class SYSKIND
    extends Structure {
        public int value;
        public static final int SYS_WIN16 = 0;
        public static final int SYS_WIN32 = 1;
        public static final int SYS_MAC = 2;
        public static final int SYS_WIN64 = 3;

        public SYSKIND() {
        }

        /*
         * WARNING - void declaration
         */
        public SYSKIND(int value) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public SYSKIND(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends SYSKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"wReserved", "decimal1", "Hi32", "decimal2"})
    public static class DECIMAL
    extends Structure {
        public short wReserved;
        public _DECIMAL1 decimal1;
        public NativeLong Hi32;
        public _DECIMAL2 decimal2;

        public DECIMAL() {
        }

        /*
         * WARNING - void declaration
         */
        public DECIMAL(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
        }

        public static class _DECIMAL2
        extends Union {
            public WinDef.ULONGLONG Lo64;
            public _DECIMAL2_DECIMAL decimal2_DECIMAL;

            public _DECIMAL2() {
                this.setType("Lo64");
            }

            /*
             * WARNING - void declaration
             */
            public _DECIMAL2(Pointer pointer) {
                super((Pointer)var1_1);
                void var1_1;
                this.setType("Lo64");
                this.read();
            }

            @Structure.FieldOrder(value={"Lo32", "Mid32"})
            public static class _DECIMAL2_DECIMAL
            extends Structure {
                public WinDef.BYTE Lo32;
                public WinDef.BYTE Mid32;

                public _DECIMAL2_DECIMAL() {
                }

                /*
                 * WARNING - void declaration
                 */
                public _DECIMAL2_DECIMAL(Pointer pointer) {
                    super((Pointer)var1_1);
                    void var1_1;
                }
            }
        }

        public static class _DECIMAL1
        extends Union {
            public WinDef.USHORT signscale;
            public _DECIMAL1_DECIMAL decimal1_DECIMAL;

            public _DECIMAL1() {
                this.setType("signscale");
            }

            /*
             * WARNING - void declaration
             */
            public _DECIMAL1(Pointer pointer) {
                super((Pointer)var1_1);
                void var1_1;
                this.setType("signscale");
                this.read();
            }

            @Structure.FieldOrder(value={"scale", "sign"})
            public static class _DECIMAL1_DECIMAL
            extends Structure {
                public WinDef.BYTE scale;
                public WinDef.BYTE sign;

                public _DECIMAL1_DECIMAL() {
                }

                /*
                 * WARNING - void declaration
                 */
                public _DECIMAL1_DECIMAL(Pointer pointer) {
                    super((Pointer)var1_1);
                    void var1_1;
                }
            }
        }

        public static class ByReference
        extends DECIMAL
        implements Structure.ByReference {
        }
    }

    public static class CURRENCY
    extends Union {
        public _CURRENCY currency;
        public WinDef.LONGLONG int64;

        public CURRENCY() {
        }

        /*
         * WARNING - void declaration
         */
        public CURRENCY(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        @Structure.FieldOrder(value={"Lo", "Hi"})
        public static class _CURRENCY
        extends Structure {
            public WinDef.ULONG Lo;
            public WinDef.LONG Hi;

            public _CURRENCY() {
            }

            /*
             * WARNING - void declaration
             */
            public _CURRENCY(Pointer pointer) {
                super((Pointer)var1_1);
                void var1_1;
                this.read();
            }
        }

        public static class ByReference
        extends CURRENCY
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"cElements", "lLbound"})
    public static class SAFEARRAYBOUND
    extends Structure {
        public WinDef.ULONG cElements;
        public WinDef.LONG lLbound;

        public SAFEARRAYBOUND() {
        }

        /*
         * WARNING - void declaration
         */
        public SAFEARRAYBOUND(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public SAFEARRAYBOUND(int cElements, int lLbound) {
            void var2_2;
            void var1_1;
            this.cElements = new WinDef.ULONG((long)var1_1);
            this.lLbound = new WinDef.LONG((long)var2_2);
            this.write();
        }

        public static class ByReference
        extends SAFEARRAYBOUND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"pSAFEARRAY"})
    public static class SAFEARRAYByReference
    extends Structure
    implements Structure.ByReference {
        public SAFEARRAY.ByReference pSAFEARRAY;

        public SAFEARRAYByReference() {
        }

        /*
         * WARNING - void declaration
         */
        public SAFEARRAYByReference(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public SAFEARRAYByReference(SAFEARRAY.ByReference safeArray) {
            void var1_1;
            this.pSAFEARRAY = var1_1;
        }
    }

    @Structure.FieldOrder(value={"cDims", "fFeatures", "cbElements", "cLocks", "pvData", "rgsabound"})
    public static class SAFEARRAY
    extends Structure
    implements Closeable {
        public WinDef.USHORT cDims;
        public WinDef.USHORT fFeatures;
        public WinDef.ULONG cbElements;
        public WinDef.ULONG cLocks;
        public WinDef.PVOID pvData;
        public SAFEARRAYBOUND[] rgsabound = new SAFEARRAYBOUND[]{new SAFEARRAYBOUND()};

        public SAFEARRAY() {
        }

        /*
         * WARNING - void declaration
         */
        public SAFEARRAY(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public void read() {
            super.read();
            if (this.cDims.intValue() > 0) {
                this.rgsabound = (SAFEARRAYBOUND[])this.rgsabound[0].toArray(this.cDims.intValue());
                return;
            }
            this.rgsabound = new SAFEARRAYBOUND[]{new SAFEARRAYBOUND()};
        }

        public static ByReference createSafeArray(int ... size) {
            int[] nArray;
            return SAFEARRAY.createSafeArray(new WTypes.VARTYPE(12), nArray);
        }

        /*
         * WARNING - void declaration
         */
        public static ByReference createSafeArray(WTypes.VARTYPE vartype, int ... size) {
            void var2_2;
            void var1_1;
            WTypes.VARTYPE vARTYPE;
            SAFEARRAYBOUND[] rgsabound = (SAFEARRAYBOUND[])new SAFEARRAYBOUND().toArray(size.length);
            for (int i = 0; i < size.length; ++i) {
                rgsabound[i].lLbound = new WinDef.LONG(0L);
                rgsabound[i].cElements = new WinDef.ULONG(size[size.length - i - 1]);
            }
            ByReference byReference = OleAuto.INSTANCE.SafeArrayCreate(vARTYPE, new WinDef.UINT(((void)var1_1).length), (SAFEARRAYBOUND[])var2_2);
            return byReference;
        }

        /*
         * WARNING - void declaration
         */
        public void putElement(Object arg, int ... indices) {
            WinDef.LONG[] paramIndices = new WinDef.LONG[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                paramIndices[i] = new WinDef.LONG(indices[indices.length - i - 1]);
            }
            switch (this.getVarType().intValue()) {
                case 11: {
                    Memory mem = new Memory(2L);
                    if (arg instanceof Boolean) {
                        mem.setShort(0L, (short)((Boolean)arg != false ? 65535 : 0));
                    } else {
                        mem.setShort(0L, (short)(((Number)arg).intValue() > 0 ? 65535 : 0));
                    }
                    WinNT.HRESULT i = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, (Pointer)mem);
                    COMUtils.checkRC(i);
                    return;
                }
                case 16: 
                case 17: {
                    Memory mem = new Memory(1L);
                    mem.setByte(0L, ((Number)arg).byteValue());
                    WinNT.HRESULT i = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, (Pointer)mem);
                    COMUtils.checkRC(i);
                    return;
                }
                case 2: 
                case 18: {
                    Memory mem = new Memory(2L);
                    mem.setShort(0L, ((Number)arg).shortValue());
                    WinNT.HRESULT i = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, (Pointer)mem);
                    COMUtils.checkRC(i);
                    return;
                }
                case 3: 
                case 19: 
                case 22: 
                case 23: {
                    Memory mem = new Memory(4L);
                    mem.setInt(0L, ((Number)arg).intValue());
                    WinNT.HRESULT i = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, (Pointer)mem);
                    COMUtils.checkRC(i);
                    return;
                }
                case 10: {
                    Memory mem = new Memory(4L);
                    mem.setInt(0L, ((Number)arg).intValue());
                    WinNT.HRESULT i = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, (Pointer)mem);
                    COMUtils.checkRC(i);
                    return;
                }
                case 4: {
                    Memory mem = new Memory(4L);
                    mem.setFloat(0L, ((Number)arg).floatValue());
                    WinNT.HRESULT i = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, (Pointer)mem);
                    COMUtils.checkRC(i);
                    return;
                }
                case 5: {
                    Memory mem = new Memory(8L);
                    mem.setDouble(0L, ((Number)arg).doubleValue());
                    WinNT.HRESULT i = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, (Pointer)mem);
                    COMUtils.checkRC(i);
                    return;
                }
                case 7: {
                    void var2_2;
                    Memory mem = new Memory(8L);
                    mem.setDouble(0L, ((DATE)((Object)arg)).date);
                    WinNT.HRESULT i = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, (Pointer)var2_2);
                    COMUtils.checkRC(i);
                    return;
                }
                case 8: {
                    void var1_1;
                    if (arg instanceof String) {
                        WTypes.BSTR bstr = OleAuto.INSTANCE.SysAllocString((String)arg);
                        WinNT.HRESULT hr = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, bstr.getPointer());
                        OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var1_1);
                        COMUtils.checkRC(hr);
                        return;
                    }
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, ((WTypes.BSTR)var1_1).getPointer());
                    COMUtils.checkRC(hRESULT);
                    return;
                }
                case 12: {
                    void var1_1;
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, ((Variant.VARIANT)var1_1).getPointer());
                    COMUtils.checkRC(hRESULT);
                    return;
                }
                case 13: {
                    void var1_1;
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, ((Unknown)var1_1).getPointer());
                    COMUtils.checkRC(hRESULT);
                    return;
                }
                case 9: {
                    void var1_1;
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, ((Dispatch)var1_1).getPointer());
                    COMUtils.checkRC(hRESULT);
                    return;
                }
                case 6: {
                    void var1_1;
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, paramIndices, ((CURRENCY)var1_1).getPointer());
                    COMUtils.checkRC(hRESULT);
                    return;
                }
                case 14: {
                    void var3_3;
                    void var1_1;
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, (WinDef.LONG[])var3_3, ((DECIMAL)var1_1).getPointer());
                    COMUtils.checkRC(hRESULT);
                    return;
                }
            }
            throw new IllegalStateException("Can't parse array content - type not supported: " + this.getVarType().intValue());
        }

        /*
         * WARNING - void declaration
         */
        public Object getElement(int ... indices) {
            void var3_4;
            WinDef.LONG[] paramIndices = new WinDef.LONG[((int[])indices).length];
            for (int i = 0; i < ((int[])indices).length; ++i) {
                paramIndices[i] = new WinDef.LONG(indices[((int[])indices).length - i - 1]);
            }
            switch (this.getVarType().intValue()) {
                case 11: {
                    Memory mem = new Memory(2L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, (Pointer)mem);
                    indices = (Object)hRESULT;
                    COMUtils.checkRC(hRESULT);
                    Object result = mem.getShort(0L) != 0;
                    break;
                }
                case 16: 
                case 17: {
                    Memory mem = new Memory(1L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, (Pointer)mem);
                    indices = (Object)hRESULT;
                    COMUtils.checkRC(hRESULT);
                    Object result = mem.getByte(0L);
                    break;
                }
                case 2: 
                case 18: {
                    Memory mem = new Memory(2L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, (Pointer)mem);
                    indices = (Object)hRESULT;
                    COMUtils.checkRC(hRESULT);
                    Object result = mem.getShort(0L);
                    break;
                }
                case 3: 
                case 19: 
                case 22: 
                case 23: {
                    Memory mem = new Memory(4L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, (Pointer)mem);
                    indices = (Object)hRESULT;
                    COMUtils.checkRC(hRESULT);
                    Object result = mem.getInt(0L);
                    break;
                }
                case 10: {
                    Memory mem = new Memory(4L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, (Pointer)mem);
                    indices = (Object)hRESULT;
                    COMUtils.checkRC(hRESULT);
                    Object result = new WinDef.SCODE(mem.getInt(0L));
                    break;
                }
                case 4: {
                    Memory mem = new Memory(4L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, (Pointer)mem);
                    indices = (Object)hRESULT;
                    COMUtils.checkRC(hRESULT);
                    Object result = Float.valueOf(mem.getFloat(0L));
                    break;
                }
                case 5: {
                    Memory mem = new Memory(8L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, (Pointer)mem);
                    indices = (Object)hRESULT;
                    COMUtils.checkRC(hRESULT);
                    Object result = mem.getDouble(0L);
                    break;
                }
                case 7: {
                    Memory mem = new Memory(8L);
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, (Pointer)mem);
                    indices = (Object)hRESULT;
                    COMUtils.checkRC(hRESULT);
                    Object result = new DATE(mem.getDouble(0L));
                    break;
                }
                case 8: {
                    WinNT.HRESULT hRESULT;
                    PointerByReference pbr = new PointerByReference();
                    WinNT.HRESULT hRESULT2 = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, pbr.getPointer());
                    indices = (Object)hRESULT2;
                    COMUtils.checkRC(hRESULT2);
                    WTypes.BSTR bstr = new WTypes.BSTR(pbr.getValue());
                    Object result = bstr.getValue();
                    OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)((Object)hRESULT));
                    break;
                }
                case 12: {
                    Variant.VARIANT holder = new Variant.VARIANT();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, holder.getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 13: {
                    PointerByReference pbr = new PointerByReference();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, pbr.getPointer());
                    COMUtils.checkRC(hRESULT);
                    Object result = new Unknown(pbr.getValue());
                    break;
                }
                case 9: {
                    PointerByReference pbr = new PointerByReference();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, pbr.getPointer());
                    COMUtils.checkRC(hRESULT);
                    Object result = new Dispatch(pbr.getValue());
                    break;
                }
                case 6: {
                    CURRENCY currency = new CURRENCY();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, paramIndices, currency.getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                case 14: {
                    void var2_2;
                    DECIMAL decimal = new DECIMAL();
                    WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, (WinDef.LONG[])var2_2, decimal.getPointer());
                    COMUtils.checkRC(hRESULT);
                    break;
                }
                default: {
                    throw new IllegalStateException("Can't parse array content - type not supported: " + this.getVarType().intValue());
                }
            }
            return var3_4;
        }

        /*
         * WARNING - void declaration
         */
        public Pointer ptrOfIndex(int ... indices) {
            void var3_4;
            void var2_2;
            WinDef.LONG[] paramIndices = new WinDef.LONG[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                paramIndices[i] = new WinDef.LONG(indices[indices.length - i - 1]);
            }
            PointerByReference pbr = new PointerByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayPtrOfIndex(this, (WinDef.LONG[])var2_2, pbr);
            COMUtils.checkRC(hRESULT);
            return var3_4.getValue();
        }

        public void destroy() {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayDestroy(this);
            COMUtils.checkRC(hRESULT);
        }

        @Override
        public void close() {
            this.destroy();
        }

        /*
         * WARNING - void declaration
         */
        public int getLBound(int dimension) {
            void var2_3;
            void var1_1;
            int targetDimension = this.getDimensionCount() - dimension;
            WinDef.LONGByReference bound = new WinDef.LONGByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetLBound(this, new WinDef.UINT((long)var1_1), bound);
            COMUtils.checkRC(hRESULT);
            return var2_3.getValue().intValue();
        }

        /*
         * WARNING - void declaration
         */
        public int getUBound(int dimension) {
            void var2_3;
            void var1_1;
            int targetDimension = this.getDimensionCount() - dimension;
            WinDef.LONGByReference bound = new WinDef.LONGByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetUBound(this, new WinDef.UINT((long)var1_1), bound);
            COMUtils.checkRC(hRESULT);
            return var2_3.getValue().intValue();
        }

        public int getDimensionCount() {
            return OleAuto.INSTANCE.SafeArrayGetDim(this).intValue();
        }

        /*
         * WARNING - void declaration
         */
        public Pointer accessData() {
            void var1_1;
            PointerByReference pbr = new PointerByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayAccessData(this, pbr);
            COMUtils.checkRC(hRESULT);
            return var1_1.getValue();
        }

        public void unaccessData() {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayUnaccessData(this);
            COMUtils.checkRC(hRESULT);
        }

        public void lock() {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayLock(this);
            COMUtils.checkRC(hRESULT);
        }

        public void unlock() {
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayUnlock(this);
            COMUtils.checkRC(hRESULT);
        }

        /*
         * WARNING - void declaration
         */
        public void redim(int cElements, int lLbound) {
            void var2_3;
            void var1_1;
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayRedim(this, new SAFEARRAYBOUND((int)var1_1, (int)var2_3));
            COMUtils.checkRC(hRESULT);
        }

        /*
         * WARNING - void declaration
         */
        public WTypes.VARTYPE getVarType() {
            void var1_1;
            WTypes.VARTYPEByReference resultHolder = new WTypes.VARTYPEByReference();
            WinNT.HRESULT hRESULT = OleAuto.INSTANCE.SafeArrayGetVartype(this, resultHolder);
            COMUtils.checkRC(hRESULT);
            return var1_1.getValue();
        }

        public long getElemsize() {
            return OleAuto.INSTANCE.SafeArrayGetElemsize(this).longValue();
        }

        public static class ByReference
        extends SAFEARRAY
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class DESCKIND
    extends Structure {
        public int value;
        public static final int DESCKIND_NONE = 0;
        public static final int DESCKIND_FUNCDESC = 1;
        public static final int DESCKIND_VARDESC = 2;
        public static final int DESCKIND_TYPECOMP = 3;
        public static final int DESCKIND_IMPLICITAPPOBJ = 4;
        public static final int DESCKIND_MAX = 5;

        public DESCKIND() {
        }

        /*
         * WARNING - void declaration
         */
        public DESCKIND(int value) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DESCKIND(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends DESCKIND
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"value"})
    public static class TYPEKIND
    extends Structure {
        public int value;
        public static final int TKIND_ENUM = 0;
        public static final int TKIND_RECORD = 1;
        public static final int TKIND_MODULE = 2;
        public static final int TKIND_INTERFACE = 3;
        public static final int TKIND_DISPATCH = 4;
        public static final int TKIND_COCLASS = 5;
        public static final int TKIND_ALIAS = 6;
        public static final int TKIND_UNION = 7;
        public static final int TKIND_MAX = 8;

        public TYPEKIND() {
        }

        /*
         * WARNING - void declaration
         */
        public TYPEKIND(int value) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public TYPEKIND(Pointer pointer) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public static class ByReference
        extends TYPEKIND
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(int value) {
                super((int)var1_1);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(TYPEKIND typekind) {
                super(typekind.getPointer());
                void var1_1;
                this.value = var1_1.value;
            }
        }
    }

    public static class MEMBERIDByReference
    extends ByReference {
        public MEMBERIDByReference() {
            this(new MEMBERID(0));
        }

        /*
         * WARNING - void declaration
         */
        public MEMBERIDByReference(MEMBERID value) {
            super(MEMBERID.SIZE);
            void var1_1;
            this.setValue((MEMBERID)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(MEMBERID value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        public MEMBERID getValue() {
            return new MEMBERID(this.getPointer().getInt(0L));
        }
    }

    public static class MEMBERID
    extends DISPID {
        private static final long serialVersionUID = 1L;

        public MEMBERID() {
            this(0);
        }

        /*
         * WARNING - void declaration
         */
        public MEMBERID(int value) {
            super((int)var1_1);
            void var1_1;
        }
    }

    public static class DISPIDByReference
    extends ByReference {
        public DISPIDByReference() {
            this(new DISPID(0));
        }

        /*
         * WARNING - void declaration
         */
        public DISPIDByReference(DISPID value) {
            super(DISPID.SIZE);
            void var1_1;
            this.setValue((DISPID)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(DISPID value) {
            void var1_1;
            this.getPointer().setInt(0L, var1_1.intValue());
        }

        public DISPID getValue() {
            return new DISPID(this.getPointer().getInt(0L));
        }
    }

    public static class DISPID
    extends WinDef.LONG {
        private static final long serialVersionUID = 1L;

        public DISPID() {
            this(0);
        }

        /*
         * WARNING - void declaration
         */
        public DISPID(int value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    @Structure.FieldOrder(value={"date"})
    public static class DATE
    extends Structure {
        private static final double MILLISECONDS_PER_DAY = 8.64E7;
        public double date;

        public DATE() {
        }

        /*
         * WARNING - void declaration
         */
        public DATE(double date) {
            void var1_1;
            this.date = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DATE(Date javaDate) {
            void var1_1;
            this.setFromJavaDate((Date)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Date getAsJavaDate() {
            void var1_1;
            void var2_2;
            WinBase.SYSTEMTIME systemtime = new WinBase.SYSTEMTIME();
            OleAuto.INSTANCE.VariantTimeToSystemTime(this.date, systemtime);
            Calendar calendar = systemtime.toCalendar();
            int millis = (int)((long)(Math.abs(this.date) * 8.64E7 + 0.5) % 1000L);
            if (this.date > 0.0 && millis > 500 || this.date < 0.0 && millis > 499) {
                millis -= 1000;
            }
            calendar.set(14, (int)var2_2);
            return var1_1.getTime();
        }

        /*
         * WARNING - void declaration
         */
        public void setFromJavaDate(Date javaDate) {
            void var2_2;
            void var1_1;
            double value;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(javaDate);
            DoubleByReference pvtime = new DoubleByReference();
            OleAuto.INSTANCE.SystemTimeToVariantTime(new WinBase.SYSTEMTIME(calendar), pvtime);
            double d = value = var1_1.getValue();
            this.date = d + Math.signum(d) * (double)var2_2.get(14) / 8.64E7;
        }

        public static class ByReference
        extends DATE
        implements Structure.ByReference {
        }
    }

    public static class _VARIANT_BOOLByReference
    extends ByReference {
        public _VARIANT_BOOLByReference() {
            this(new VARIANT_BOOL(0L));
        }

        /*
         * WARNING - void declaration
         */
        public _VARIANT_BOOLByReference(VARIANT_BOOL value) {
            super(2);
            void var1_1;
            this.setValue((VARIANT_BOOL)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(VARIANT_BOOL value) {
            void var1_1;
            this.getPointer().setShort(0L, var1_1.shortValue());
        }

        public VARIANT_BOOL getValue() {
            return new VARIANT_BOOL(this.getPointer().getShort(0L));
        }
    }

    public static class VARIANT_BOOLByReference
    extends ByReference {
        public VARIANT_BOOLByReference() {
            this(new VARIANT_BOOL(0L));
        }

        /*
         * WARNING - void declaration
         */
        public VARIANT_BOOLByReference(VARIANT_BOOL value) {
            super(2);
            void var1_1;
            this.setValue((VARIANT_BOOL)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(VARIANT_BOOL value) {
            void var1_1;
            this.getPointer().setShort(0L, var1_1.shortValue());
        }

        public VARIANT_BOOL getValue() {
            return new VARIANT_BOOL(this.getPointer().getShort(0L));
        }
    }

    public static class _VARIANT_BOOL
    extends VARIANT_BOOL {
        private static final long serialVersionUID = 1L;

        public _VARIANT_BOOL() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public _VARIANT_BOOL(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class VARIANT_BOOL
    extends IntegerType {
        private static final long serialVersionUID = 1L;
        public static final int SIZE = 2;

        public VARIANT_BOOL() {
            this(0L);
        }

        /*
         * WARNING - void declaration
         */
        public VARIANT_BOOL(long value) {
            super(2, (long)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public VARIANT_BOOL(boolean value) {
            this(var1_1 != false ? 65535L : 0L);
            void var1_1;
        }

        public boolean booleanValue() {
            return this.shortValue() != 0;
        }
    }

    @Structure.FieldOrder(value={"wCode", "wReserved", "bstrSource", "bstrDescription", "bstrHelpFile", "dwHelpContext", "pvReserved", "pfnDeferredFillIn", "scode"})
    public static class EXCEPINFO
    extends Structure {
        public WinDef.WORD wCode;
        public WinDef.WORD wReserved;
        public WTypes.BSTR bstrSource;
        public WTypes.BSTR bstrDescription;
        public WTypes.BSTR bstrHelpFile;
        public WinDef.DWORD dwHelpContext;
        public WinDef.PVOID pvReserved;
        public ByReference pfnDeferredFillIn;
        public WinDef.SCODE scode;

        public EXCEPINFO() {
        }

        /*
         * WARNING - void declaration
         */
        public EXCEPINFO(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }

        public static class ByReference
        extends EXCEPINFO
        implements Structure.ByReference {
        }
    }
}

