/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class Kernel32Util
implements WinDef {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String VOLUME_GUID_PATH_PREFIX = "\\\\?\\Volume{";
    public static final String VOLUME_GUID_PATH_SUFFIX = "}\\";

    /*
     * WARNING - void declaration
     */
    public static String getComputerName() {
        void var0;
        void var1_1;
        char[] buffer = new char[WinBase.MAX_COMPUTERNAME_LENGTH + 1];
        IntByReference lpnSize = new IntByReference(buffer.length);
        if (!Kernel32.INSTANCE.GetComputerName(buffer, (IntByReference)var1_1)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])var0);
    }

    public static void freeLocalMemory(Pointer ptr) {
        Pointer pointer;
        if ((pointer = Kernel32.INSTANCE.LocalFree(pointer)) != null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void freeGlobalMemory(Pointer ptr) {
        Pointer pointer;
        if ((pointer = Kernel32.INSTANCE.GlobalFree(pointer)) != null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void closeHandleRefs(WinNT.HANDLEByReference ... refs) {
        WinNT.HANDLEByReference[] hANDLEByReferenceArray;
        Win32Exception err = null;
        for (WinNT.HANDLEByReference r : hANDLEByReferenceArray) {
            try {
                Kernel32Util.closeHandleRef(r);
            }
            catch (Win32Exception e) {
                if (err == null) {
                    err = e;
                    continue;
                }
                err.addSuppressedReflected((Throwable)((Object)e));
            }
        }
        if (err != null) {
            void var1_1;
            throw var1_1;
        }
    }

    public static void closeHandleRef(WinNT.HANDLEByReference ref) {
        WinNT.HANDLEByReference hANDLEByReference;
        Kernel32Util.closeHandle(ref == null ? null : hANDLEByReference.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public static void closeHandles(WinNT.HANDLE ... handles) {
        WinNT.HANDLE[] hANDLEArray;
        Win32Exception err = null;
        for (WinNT.HANDLE h : hANDLEArray) {
            try {
                Kernel32Util.closeHandle(h);
            }
            catch (Win32Exception e) {
                if (err == null) {
                    err = e;
                    continue;
                }
                err.addSuppressedReflected((Throwable)((Object)e));
            }
        }
        if (err != null) {
            void var1_1;
            throw var1_1;
        }
    }

    public static void closeHandle(WinNT.HANDLE h) {
        WinNT.HANDLE hANDLE;
        if (h == null) {
            return;
        }
        if (!Kernel32.INSTANCE.CloseHandle(hANDLE)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static String formatMessage(int code) {
        return Kernel32Util.formatMessage(code, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatMessage(int code, int primaryLangId, int sublangId) {
        String string;
        void var3_6;
        void var2_5;
        void var1_2;
        PointerByReference buffer = new PointerByReference();
        if ((code = Kernel32.INSTANCE.FormatMessage(4864, null, code, WinNT.LocaleMacros.MAKELANGID((int)var1_2, (int)var2_5), buffer, 0, null)) == 0) {
            throw new LastErrorException(Native.getLastError());
        }
        Pointer ptr = var3_6.getValue();
        try {
            string = ptr.getWideString(0L);
            string = string.trim();
        }
        catch (Throwable throwable) {
            void var0_1;
            Kernel32Util.freeLocalMemory((Pointer)var0_1);
            throw throwable;
        }
        Kernel32Util.freeLocalMemory(ptr);
        return string;
    }

    public static String formatMessage(WinNT.HRESULT code) {
        return Kernel32Util.formatMessage(code.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public static String formatMessage(WinNT.HRESULT code, int primaryLangId, int sublangId) {
        void var2_2;
        void var1_1;
        return Kernel32Util.formatMessage(code.intValue(), (int)var1_1, (int)var2_2);
    }

    public static String formatMessageFromLastErrorCode(int code) {
        return Kernel32Util.formatMessage(W32Errors.HRESULT_FROM_WIN32(code));
    }

    /*
     * WARNING - void declaration
     */
    public static String formatMessageFromLastErrorCode(int code, int primaryLangId, int sublangId) {
        void var2_2;
        void var1_1;
        return Kernel32Util.formatMessage(W32Errors.HRESULT_FROM_WIN32(code), (int)var1_1, (int)var2_2);
    }

    public static String getLastErrorMessage() {
        return Kernel32Util.formatMessageFromLastErrorCode(Kernel32.INSTANCE.GetLastError());
    }

    /*
     * WARNING - void declaration
     */
    public static String getLastErrorMessage(int primaryLangId, int sublangId) {
        void var1_1;
        int n;
        return Kernel32Util.formatMessageFromLastErrorCode(Kernel32.INSTANCE.GetLastError(), n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getTempPath() {
        void var1_1;
        void var0;
        WinDef.DWORD nBufferLength = new WinDef.DWORD(260L);
        char[] buffer = new char[nBufferLength.intValue()];
        if (Kernel32.INSTANCE.GetTempPath((WinDef.DWORD)var0, buffer).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])var1_1);
    }

    public static void deleteFile(String filename) {
        String string;
        if (!Kernel32.INSTANCE.DeleteFile(string)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getLogicalDriveStrings() {
        void var0_1;
        void var1_2;
        WinDef.DWORD dwSize = Kernel32.INSTANCE.GetLogicalDriveStrings(new WinDef.DWORD(0L), null);
        if (dwSize.intValue() <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] buf = new char[dwSize.intValue()];
        int bufSize = (dwSize = Kernel32.INSTANCE.GetLogicalDriveStrings(dwSize, buf)).intValue();
        if (bufSize <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toStringList((char[])var1_2, (int)0, (int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int getFileAttributes(String fileName) {
        void var0_1;
        int fileAttributes = Kernel32.INSTANCE.GetFileAttributes(fileName);
        if (fileAttributes == -1) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int getFileType(String fileName) throws FileNotFoundException {
        void var0_1;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new FileNotFoundException(fileName);
        }
        WinNT.HANDLE hFile = null;
        Win32Exception err = null;
        try {
            hFile = Kernel32.INSTANCE.CreateFile(fileName, Integer.MIN_VALUE, 1, new WinBase.SECURITY_ATTRIBUTES(), 3, 128, new WinNT.HANDLEByReference().getValue());
            if (WinBase.INVALID_HANDLE_VALUE.equals((Object)hFile)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            int type = Kernel32.INSTANCE.GetFileType(hFile);
            block2 : switch (type) {
                case 0: {
                    void var3_5;
                    int rc = Kernel32.INSTANCE.GetLastError();
                    switch (rc) {
                        case 0: {
                            break block2;
                        }
                    }
                    throw new Win32Exception((int)var3_5);
                }
            }
        }
        catch (Win32Exception win32Exception) {
            try {
                Object object = win32Exception;
                err = win32Exception;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                void var2_4;
                Kernel32Util.cleanUp((WinNT.HANDLE)((Object)file), (Win32Exception)var2_4);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hFile, null);
        return (int)var0_1;
    }

    public static int getDriveType(String rootName) {
        String string;
        return Kernel32.INSTANCE.GetDriveType(string);
    }

    /*
     * WARNING - void declaration
     */
    public static String getEnvironmentVariable(String name) {
        void var2_2;
        String string;
        int n;
        int size = Kernel32.INSTANCE.GetEnvironmentVariable(name, null, 0);
        if (size == 0) {
            return null;
        }
        if (size < 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] buffer = new char[n];
        if ((n = Kernel32.INSTANCE.GetEnvironmentVariable(string, buffer, buffer.length)) <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])var2_2);
    }

    public static Map<String, String> getEnvironmentVariables() {
        Pointer lpszEnvironmentBlock = Kernel32.INSTANCE.GetEnvironmentStrings();
        if (lpszEnvironmentBlock == null) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        try {
            Map<String, String> map = Kernel32Util.getEnvironmentVariables(lpszEnvironmentBlock, 0L);
            return map;
        }
        finally {
            if (!Kernel32.INSTANCE.FreeEnvironmentStrings(lpszEnvironmentBlock)) {
                throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> getEnvironmentVariables(Pointer lpszEnvironmentBlock, long offset) {
        void var3_3;
        String nvp;
        int len;
        if (lpszEnvironmentBlock == null) {
            return null;
        }
        TreeMap<String, void> vars = new TreeMap<String, void>();
        boolean asWideChars = Kernel32Util.isWideCharEnvironmentStringBlock(lpszEnvironmentBlock, offset);
        long stepFactor = asWideChars ? 2L : 1L;
        long curOffset = offset;
        while ((len = (nvp = Kernel32Util.readEnvironmentStringBlockEntry(lpszEnvironmentBlock, curOffset, asWideChars)).length()) != 0) {
            void var2_7;
            void var1_2;
            int pos = nvp.indexOf(61);
            if (pos < 0) {
                throw new IllegalArgumentException("Missing variable value separator in " + nvp);
            }
            String name = nvp.substring(0, pos);
            String value = nvp.substring(pos + 1);
            vars.put(name, var1_2);
            curOffset += (long)(var2_7 + true) * stepFactor;
        }
        return var3_3;
    }

    public static String readEnvironmentStringBlockEntry(Pointer lpszEnvironmentBlock, long offset, boolean asWideChars) {
        long l = Kernel32Util.findEnvironmentStringBlockEntryEnd(lpszEnvironmentBlock, offset, asWideChars);
        int dataLen = (int)(l - offset);
        if (dataLen == 0) {
            return "";
        }
        dataLen = asWideChars ? dataLen / 2 : dataLen;
        char[] chars = new char[dataLen];
        long curOffset = offset;
        long stepSize = asWideChars ? 2L : 1L;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        int index = 0;
        while (index < chars.length) {
            byte b = lpszEnvironmentBlock.getByte(curOffset);
            if (asWideChars) {
                byte x = lpszEnvironmentBlock.getByte(curOffset + 1L);
                chars[index] = ByteOrder.LITTLE_ENDIAN.equals(byteOrder) ? (char)(x << 8 & 0xFF00 | b & 0xFF) : (char)(b << 8 & 0xFF00 | x & 0xFF);
            } else {
                chars[index] = (char)(b & 0xFF);
            }
            ++index;
            curOffset += stepSize;
        }
        return new String(chars);
    }

    /*
     * WARNING - void declaration
     */
    public static long findEnvironmentStringBlockEntryEnd(Pointer lpszEnvironmentBlock, long offset, boolean asWideChars) {
        void var3_3;
        long stepSize;
        long curOffset = offset;
        long l = stepSize = var3_3 != false ? 2L : 1L;
        byte by;
        while ((by = lpszEnvironmentBlock.getByte(curOffset)) != 0) {
            curOffset += stepSize;
        }
        return curOffset;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWideCharEnvironmentStringBlock(Pointer lpszEnvironmentBlock, long offset) {
        void var3_4;
        void var1_3;
        byte b0 = lpszEnvironmentBlock.getByte(offset);
        byte b1 = lpszEnvironmentBlock.getByte(offset + 1L);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        if (ByteOrder.LITTLE_ENDIAN.equals(var1_3)) {
            void var0_1;
            return Kernel32Util.isWideCharEnvironmentStringBlock((byte)var0_1);
        }
        return Kernel32Util.isWideCharEnvironmentStringBlock((byte)var3_4);
    }

    private static boolean isWideCharEnvironmentStringBlock(byte charsetIndicator) {
        return charsetIndicator == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getPrivateProfileInt(String appName, String keyName, int defaultValue, String fileName) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return Kernel32.INSTANCE.GetPrivateProfileInt(string, (String)var1_1, (int)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final String getPrivateProfileString(String lpAppName, String lpKeyName, String lpDefault, String lpFileName) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        char[] buffer = new char[1024];
        int cfr_ignored_0 = buffer.length;
        Kernel32.INSTANCE.GetPrivateProfileString(string, (String)var1_1, (String)var2_2, buffer, new WinDef.DWORD(1024L), (String)var3_3);
        return Native.toString((char[])buffer);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writePrivateProfileString(String appName, String keyName, String string, String fileName) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string2;
        if (!Kernel32.INSTANCE.WritePrivateProfileString(string2, (String)var1_1, (String)var2_2, (String)var3_3)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] getLogicalProcessorInformation() {
        void var0;
        void var2_3;
        void var1_1;
        void err2;
        Memory memory;
        int sizePerStruct = new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION().size();
        WinDef.DWORDByReference bufferSize = new WinDef.DWORDByReference(new WinDef.DWORD(sizePerStruct));
        while (!Kernel32.INSTANCE.GetLogicalProcessorInformation((Pointer)(memory = new Memory((long)bufferSize.getValue().intValue())), bufferSize)) {
            int err2 = Kernel32.INSTANCE.GetLastError();
            if (err2 == 122) continue;
            throw new Win32Exception(err2);
        }
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION firstInformation = new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION((Pointer)err2);
        int returnedStructCount = var1_1.getValue().intValue() / sizePerStruct;
        return (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[])var2_3.toArray((Structure[])new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[var0]);
    }

    /*
     * WARNING - void declaration
     */
    public static final WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] getLogicalProcessorInformationEx(int relationshipType) {
        void var3_4;
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX information;
        Memory memory;
        WinDef.DWORDByReference bufferSize = new WinDef.DWORDByReference(new WinDef.DWORD(1L));
        while (!Kernel32.INSTANCE.GetLogicalProcessorInformationEx(relationshipType, (Pointer)(memory = new Memory((long)bufferSize.getValue().intValue())), bufferSize)) {
            int err = Kernel32.INSTANCE.GetLastError();
            if (err == 122) continue;
            throw new Win32Exception(err);
        }
        ArrayList<WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX> procInfoList = new ArrayList<WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX>();
        for (int offset = 0; offset < bufferSize.getValue().intValue(); offset += information.size) {
            information = WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX.fromPointer(memory.share((long)offset));
            procInfoList.add(information);
        }
        return var3_4.toArray(new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static final String[] getPrivateProfileSection(String appName, String fileName) {
        void var2_3;
        void var1_2;
        char[] buffer = new char[32768];
        int cfr_ignored_0 = buffer.length;
        if (Kernel32.INSTANCE.GetPrivateProfileSection(appName, buffer, new WinDef.DWORD(32768L), (String)var1_2).intValue() == 0) {
            void var0_1;
            int lastError = Kernel32.INSTANCE.GetLastError();
            if (lastError == 0) {
                return EMPTY_STRING_ARRAY;
            }
            throw new Win32Exception((int)var0_1);
        }
        return new String((char[])var2_3).split("\u0000");
    }

    /*
     * WARNING - void declaration
     */
    public static final String[] getPrivateProfileSectionNames(String fileName) {
        void var1_1;
        String string;
        char[] buffer = new char[65536];
        int cfr_ignored_0 = buffer.length;
        if (Kernel32.INSTANCE.GetPrivateProfileSectionNames(buffer, new WinDef.DWORD(65536L), string).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new String((char[])var1_1).split("\u0000");
    }

    /*
     * WARNING - void declaration
     */
    public static final void writePrivateProfileSection(String appName, String[] strings, String fileName) {
        void var2_2;
        void var3_3;
        String string;
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        for (void string2 : var1_1) {
            buffer.append((String)string2).append('\u0000');
        }
        buffer.append('\u0000');
        if (!Kernel32.INSTANCE.WritePrivateProfileSection(string, var3_3.toString(), (String)var2_2)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final List<String> queryDosDevice(String lpszDeviceName, int maxTargetSize) {
        void var0_1;
        void var1_3;
        char[] lpTargetPath = new char[maxTargetSize];
        int dwSize = Kernel32.INSTANCE.QueryDosDevice(lpszDeviceName, lpTargetPath, lpTargetPath.length);
        if (dwSize == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toStringList((char[])var1_3, (int)0, (int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<String> getVolumePathNamesForVolumeName(String lpszVolumeName) {
        void var3_4;
        void var1_1;
        void var2_3;
        char[] lpszVolumePathNames22 = new char[261];
        IntByReference lpcchReturnLength = new IntByReference();
        if (!Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(lpszVolumeName, lpszVolumePathNames22, lpszVolumePathNames22.length, lpcchReturnLength)) {
            String string;
            int hr = Kernel32.INSTANCE.GetLastError();
            if (hr != 234) {
                throw new Win32Exception(hr);
            }
            int lpszVolumePathNames22 = lpcchReturnLength.getValue();
            lpszVolumePathNames22 = new char[lpszVolumePathNames22];
            if (!Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(string, lpszVolumePathNames22, lpszVolumePathNames22.length, lpcchReturnLength)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }
        int bufSize = var2_3.getValue();
        return Native.toStringList((char[])var1_1, (int)0, (int)var3_4);
    }

    public static final String extractVolumeGUID(String volumeGUIDPath) {
        String string;
        if (volumeGUIDPath == null || volumeGUIDPath.length() <= 11 + 2 || !volumeGUIDPath.startsWith(VOLUME_GUID_PATH_PREFIX) || !volumeGUIDPath.endsWith(VOLUME_GUID_PATH_SUFFIX)) {
            throw new IllegalArgumentException("Bad volume GUID path format: " + volumeGUIDPath);
        }
        return volumeGUIDPath.substring(11, string.length() - 2);
    }

    /*
     * WARNING - void declaration
     */
    public static final String QueryFullProcessImageName(int pid, int dwFlags) {
        String string;
        WinNT.HANDLE hProcess = null;
        Win32Exception we = null;
        try {
            void var1_4;
            int n;
            hProcess = Kernel32.INSTANCE.OpenProcess(1040, false, n);
            if (hProcess == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            string = Kernel32Util.QueryFullProcessImageName(hProcess, (int)var1_4);
        }
        catch (Win32Exception win32Exception) {
            try {
                Win32Exception win32Exception2 = win32Exception;
                we = win32Exception;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                void var3_6;
                void var2_5;
                Kernel32Util.cleanUp((WinNT.HANDLE)var2_5, (Win32Exception)var3_6);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hProcess, null);
        return string;
    }

    public static final String QueryFullProcessImageName(WinNT.HANDLE hProcess, int dwFlags) {
        int size = 260;
        IntByReference lpdwSize = new IntByReference();
        do {
            char[] lpExeName = new char[size];
            lpdwSize.setValue(size);
            if (Kernel32.INSTANCE.QueryFullProcessImageName(hProcess, dwFlags, lpExeName, lpdwSize)) {
                return new String(lpExeName, 0, lpdwSize.getValue());
            }
            size += 1024;
        } while (Kernel32.INSTANCE.GetLastError() == 122);
        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getResource(String path, String type, String name) {
        byte[] results;
        Win32Exception err;
        block15: {
            Object loaded2;
            Object target = Kernel32.INSTANCE.LoadLibraryEx(path, null, 2);
            if (target == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            err = null;
            results = null;
            try {
                void var2_4;
                void var1_1;
                Pointer n;
                Pointer t;
                try {
                    t = new Pointer(Long.parseLong(type));
                }
                catch (NumberFormatException numberFormatException) {
                    t = new Memory((long)(Native.WCHAR_SIZE * (type.length() + 1)));
                    t.setWideString(0L, type);
                }
                try {
                    n = new Pointer(Long.parseLong(name));
                }
                catch (NumberFormatException numberFormatException) {
                    n = new Memory((long)(Native.WCHAR_SIZE * (name.length() + 1)));
                    n.setWideString(0L, name);
                }
                WinDef.HRSRC hrsrc = Kernel32.INSTANCE.FindResource((WinDef.HMODULE)((Object)target), n, t);
                if (hrsrc == null) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                loaded2 = Kernel32.INSTANCE.LoadResource((WinDef.HMODULE)((Object)target), hrsrc);
                if (loaded2 == null) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                int length = Kernel32.INSTANCE.SizeofResource((WinDef.HMODULE)((Object)target), hrsrc);
                if (length == 0) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                Pointer start = Kernel32.INSTANCE.LockResource((WinNT.HANDLE)((Object)loaded2));
                if (start == null) {
                    throw new IllegalStateException("LockResource returned null.");
                }
                results = var1_1.getByteArray(0L, (int)var2_4);
                if (target == null || Kernel32.INSTANCE.FreeLibrary((WinDef.HMODULE)((Object)target))) break block15;
                loaded2 = new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            catch (Win32Exception win32Exception) {
                Win32Exception loaded2 = win32Exception;
                err = win32Exception;
                if (target != null && !Kernel32.INSTANCE.FreeLibrary((WinDef.HMODULE)((Object)target))) {
                    Win32Exception we = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    we.addSuppressedReflected((Throwable)((Object)err));
                    throw we;
                }
            }
            catch (Throwable throwable) {
                Object object;
                if (target != null && !Kernel32.INSTANCE.FreeLibrary((WinDef.HMODULE)((Object)object))) {
                    object = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    throw object;
                }
                throw throwable;
            }
            throw loaded2;
        }
        if (err != null) {
            void var3_5;
            throw var3_5;
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<String>> getResourceNames(String path) {
        void var2_3;
        Win32Exception err;
        block11: {
            Object target = Kernel32.INSTANCE.LoadLibraryEx(path, null, 2);
            if (target == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            Object types = new ArrayList();
            final LinkedHashMap result = new LinkedHashMap();
            WinBase.EnumResTypeProc ertp = new WinBase.EnumResTypeProc((List)types){
                final /* synthetic */ List val$types;
                {
                    this.val$types = list;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean invoke(WinDef.HMODULE module, Pointer type, Pointer lParam) {
                    if (Pointer.nativeValue((Pointer)type) <= 65535L) {
                        this.val$types.add("" + Pointer.nativeValue((Pointer)type));
                    } else {
                        void var2_2;
                        this.val$types.add(var2_2.getWideString(0L));
                    }
                    return true;
                }
            };
            WinBase.EnumResNameProc ernp = new WinBase.EnumResNameProc(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean invoke(WinDef.HMODULE module, Pointer type, Pointer name, Pointer lParam) {
                    void var2_2;
                    String typeName = Pointer.nativeValue((Pointer)type) <= 65535L ? "" + Pointer.nativeValue((Pointer)type) : var2_2.getWideString(0L);
                    if (Pointer.nativeValue((Pointer)name) < 65535L) {
                        ((List)result.get(typeName)).add("" + Pointer.nativeValue((Pointer)name));
                    } else {
                        void var3_3;
                        void var1_1;
                        ((List)result.get(var1_1)).add(var3_3.getWideString(0L));
                    }
                    return true;
                }
            };
            err = null;
            try {
                if (!Kernel32.INSTANCE.EnumResourceTypes((WinDef.HMODULE)((Object)target), ertp, null)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                for (String typeName : types) {
                    boolean bl;
                    Pointer pointer;
                    result.put(typeName, new ArrayList());
                    try {
                        pointer = new Pointer(Long.parseLong(typeName));
                    }
                    catch (NumberFormatException numberFormatException) {
                        void var3_5;
                        pointer = new Memory((long)(Native.WCHAR_SIZE * (typeName.length() + 1)));
                        pointer.setWideString(0L, (String)var3_5);
                    }
                    if (bl = Kernel32.INSTANCE.EnumResourceNames((WinDef.HMODULE)((Object)target), pointer, ernp, null)) continue;
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                if (target == null || Kernel32.INSTANCE.FreeLibrary((WinDef.HMODULE)((Object)target))) break block11;
                types = new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            catch (Win32Exception win32Exception) {
                types = win32Exception;
                err = win32Exception;
                if (target != null && !Kernel32.INSTANCE.FreeLibrary((WinDef.HMODULE)((Object)target))) {
                    void var1_1;
                    Win32Exception we = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    we.addSuppressedReflected((Throwable)((Object)err));
                    throw var1_1;
                }
            }
            catch (Throwable throwable) {
                Object object;
                if (target != null && !Kernel32.INSTANCE.FreeLibrary((WinDef.HMODULE)((Object)object))) {
                    object = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    throw object;
                }
                throw throwable;
            }
            throw types;
        }
        if (err != null) {
            throw err;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Tlhelp32.MODULEENTRY32W> getModules(int processID) {
        void var2_5;
        WinNT.HANDLE snapshot = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPMODULE, new WinDef.DWORD(processID));
        if (snapshot == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Win32Exception we = null;
        try {
            void var3_8;
            Tlhelp32.MODULEENTRY32W first = new Tlhelp32.MODULEENTRY32W();
            if (!Kernel32.INSTANCE.Module32FirstW(snapshot, first)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            ArrayList<Tlhelp32.MODULEENTRY32W> modules = new ArrayList<Tlhelp32.MODULEENTRY32W>();
            modules.add(first);
            Tlhelp32.MODULEENTRY32W next = new Tlhelp32.MODULEENTRY32W();
            while (Kernel32.INSTANCE.Module32NextW(snapshot, next)) {
                modules.add(next);
                next = new Tlhelp32.MODULEENTRY32W();
            }
            int lastError = Kernel32.INSTANCE.GetLastError();
            if (lastError != 0 && lastError != 18) {
                void var2_4;
                throw new Win32Exception((int)var2_4);
            }
            var2_5 = var3_8;
        }
        catch (Win32Exception win32Exception) {
            try {
                Win32Exception win32Exception2 = win32Exception;
                we = win32Exception;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                void var1_2;
                void var0_1;
                Kernel32Util.cleanUp((WinNT.HANDLE)var0_1, (Win32Exception)var1_2);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(snapshot, null);
        return var2_5;
    }

    /*
     * WARNING - void declaration
     */
    public static String expandEnvironmentStrings(String input) {
        void var2_2;
        int n;
        String string;
        if (input == null) {
            return "";
        }
        int resultChars = Kernel32.INSTANCE.ExpandEnvironmentStrings(input, null, 0);
        if (resultChars == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Memory resultMemory = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? new Memory((long)(resultChars * Native.WCHAR_SIZE)) : new Memory((long)(resultChars + 1));
        n = Kernel32.INSTANCE.ExpandEnvironmentStrings(string, (Pointer)resultMemory, n);
        if (n == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return resultMemory.getWideString(0L);
        }
        return var2_2.getString(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static WinDef.DWORD getCurrentProcessPriority() {
        void var0;
        Kernel32 kernel32 = Kernel32.INSTANCE;
        WinDef.DWORD dwPriorityClass = kernel32.GetPriorityClass(kernel32.GetCurrentProcess());
        if (!Kernel32Util.isValidPriorityClass(dwPriorityClass)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return var0;
    }

    public static void setCurrentProcessPriority(WinDef.DWORD dwPriorityClass) {
        WinDef.DWORD dWORD;
        if (!Kernel32Util.isValidPriorityClass(dwPriorityClass)) {
            throw new IllegalArgumentException("The given priority value is invalid!");
        }
        Kernel32 kernel32 = Kernel32.INSTANCE;
        if (!kernel32.SetPriorityClass(kernel32.GetCurrentProcess(), dWORD)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setCurrentProcessBackgroundMode(boolean enable) {
        void var0_1;
        WinDef.DWORD dwPriorityClass = enable ? Kernel32.PROCESS_MODE_BACKGROUND_BEGIN : Kernel32.PROCESS_MODE_BACKGROUND_END;
        Kernel32 kernel32 = Kernel32.INSTANCE;
        if (!kernel32.SetPriorityClass(kernel32.GetCurrentProcess(), (WinDef.DWORD)var0_1)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int getCurrentThreadPriority() {
        void var0;
        Kernel32 kernel32 = Kernel32.INSTANCE;
        int nPriority = kernel32.GetThreadPriority(kernel32.GetCurrentThread());
        if (!Kernel32Util.isValidThreadPriority(nPriority)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return (int)var0;
    }

    public static void setCurrentThreadPriority(int nPriority) {
        int n;
        if (!Kernel32Util.isValidThreadPriority(nPriority)) {
            throw new IllegalArgumentException("The given priority value is invalid!");
        }
        Kernel32 kernel32 = Kernel32.INSTANCE;
        if (!kernel32.SetThreadPriority(kernel32.GetCurrentThread(), n)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setCurrentThreadBackgroundMode(boolean enable) {
        void var0_1;
        int nPriority = enable ? 65536 : 131072;
        Kernel32 kernel32 = Kernel32.INSTANCE;
        if (!kernel32.SetThreadPriority(kernel32.GetCurrentThread(), (int)var0_1)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static WinDef.DWORD getProcessPriority(int pid) {
        void var2_3;
        WinNT.HANDLE hProcess;
        block5: {
            hProcess = Kernel32.INSTANCE.OpenProcess(1024, false, pid);
            if (hProcess == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            Win32Exception we = null;
            try {
                WinDef.DWORD dwPriorityClass = Kernel32.INSTANCE.GetPriorityClass(hProcess);
                if (Kernel32Util.isValidPriorityClass(dwPriorityClass)) break block5;
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            catch (Win32Exception win32Exception) {
                try {
                    Win32Exception win32Exception2 = win32Exception;
                    we = win32Exception;
                    throw win32Exception;
                }
                catch (Throwable throwable) {
                    void var1_2;
                    void var0_1;
                    Kernel32Util.cleanUp((WinNT.HANDLE)var0_1, (Win32Exception)var1_2);
                    throw throwable;
                }
            }
        }
        Kernel32Util.cleanUp(hProcess, null);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static void setProcessPriority(int pid, WinDef.DWORD dwPriorityClass) {
        WinNT.HANDLE hProcess;
        block5: {
            if (!Kernel32Util.isValidPriorityClass(dwPriorityClass)) {
                throw new IllegalArgumentException("The given priority value is invalid!");
            }
            hProcess = Kernel32.INSTANCE.OpenProcess(512, false, pid);
            if (hProcess == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            try {
                if (Kernel32.INSTANCE.SetPriorityClass(hProcess, dwPriorityClass)) break block5;
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            catch (Win32Exception win32Exception) {
                void var1_2;
                Win32Exception we = win32Exception;
                we = win32Exception;
                Kernel32Util.cleanUp(hProcess, (Win32Exception)var1_2);
                return;
            }
            catch (Throwable throwable) {
                void var0_1;
                Kernel32Util.cleanUp((WinNT.HANDLE)var0_1, null);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hProcess, null);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static int getThreadPriority(int tid) {
        void var2_3;
        WinNT.HANDLE hThread;
        block5: {
            hThread = Kernel32.INSTANCE.OpenThread(64, false, tid);
            if (hThread == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            Win32Exception we = null;
            try {
                int nPriority = Kernel32.INSTANCE.GetThreadPriority(hThread);
                if (Kernel32Util.isValidThreadPriority(nPriority)) break block5;
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            catch (Win32Exception win32Exception) {
                try {
                    Win32Exception win32Exception2 = win32Exception;
                    we = win32Exception;
                    throw win32Exception;
                }
                catch (Throwable throwable) {
                    void var1_2;
                    void var0_1;
                    Kernel32Util.cleanUp((WinNT.HANDLE)var0_1, (Win32Exception)var1_2);
                    throw throwable;
                }
            }
        }
        Kernel32Util.cleanUp(hThread, null);
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static void setThreadPriority(int tid, int nPriority) {
        WinNT.HANDLE hThread;
        block5: {
            if (!Kernel32Util.isValidThreadPriority(nPriority)) {
                throw new IllegalArgumentException("The given priority value is invalid!");
            }
            hThread = Kernel32.INSTANCE.OpenThread(32, false, tid);
            if (hThread == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            try {
                if (Kernel32.INSTANCE.SetThreadPriority(hThread, nPriority)) break block5;
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            catch (Win32Exception win32Exception) {
                void var1_3;
                Win32Exception we = win32Exception;
                we = win32Exception;
                Kernel32Util.cleanUp(hThread, (Win32Exception)var1_3);
                return;
            }
            catch (Throwable throwable) {
                void var0_1;
                Kernel32Util.cleanUp((WinNT.HANDLE)var0_1, null);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hThread, null);
        return;
    }

    public static boolean isValidPriorityClass(WinDef.DWORD dwPriorityClass) {
        WinDef.DWORD dWORD;
        return Kernel32.NORMAL_PRIORITY_CLASS.equals(dwPriorityClass) || Kernel32.IDLE_PRIORITY_CLASS.equals(dwPriorityClass) || Kernel32.HIGH_PRIORITY_CLASS.equals(dwPriorityClass) || Kernel32.REALTIME_PRIORITY_CLASS.equals(dwPriorityClass) || Kernel32.BELOW_NORMAL_PRIORITY_CLASS.equals(dwPriorityClass) || Kernel32.ABOVE_NORMAL_PRIORITY_CLASS.equals(dWORD);
    }

    public static boolean isValidThreadPriority(int nPriority) {
        switch (nPriority) {
            case -15: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void cleanUp(WinNT.HANDLE h, Win32Exception we) {
        try {
            Kernel32Util.closeHandle(h);
        }
        catch (Win32Exception e) {
            void var0_1;
            if (we == null) {
                we = e;
            }
            we.addSuppressedReflected((Throwable)var0_1);
        }
        if (we != null) {
            void var1_2;
            throw var1_2;
        }
    }
}

