/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.tlb.imp;

import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLibUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TlbBase {
    public static final String CR = "\n";
    public static final String CRCR = "\n\n";
    public static final String TAB = "\t";
    public static final String TABTAB = "\t\t";
    protected TypeLibUtil typeLibUtil;
    protected TypeInfoUtil typeInfoUtil;
    protected int index;
    protected StringBuffer templateBuffer;
    protected StringBuffer classBuffer;
    protected String content = "";
    protected String filename = "DefaultFilename";
    protected String name = "DefaultName";
    public static String[] IUNKNOWN_METHODS = new String[]{"QueryInterface", "AddRef", "Release"};
    public static String[] IDISPATCH_METHODS = new String[]{"GetTypeInfoCount", "GetTypeInfo", "GetIDsOfNames", "Invoke"};
    protected String bindingMode = "dispid";

    /*
     * WARNING - void declaration
     */
    public TlbBase(int index, TypeLibUtil typeLibUtil, TypeInfoUtil typeInfoUtil) {
        this((int)var1_1, (TypeLibUtil)var2_2, (TypeInfoUtil)var3_3, "dispid");
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TlbBase(int index, TypeLibUtil typeLibUtil, TypeInfoUtil typeInfoUtil, String bindingMode) {
        IOException iOException;
        void var3_4;
        void var2_3;
        this.index = index;
        this.typeLibUtil = var2_3;
        this.typeInfoUtil = var3_4;
        this.bindingMode = bindingMode;
        String filename = this.getClassTemplate();
        try {
            this.readTemplateFile((String)((Object)iOException));
            this.classBuffer = this.templateBuffer;
            return;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logError(String msg) {
        void var1_1;
        this.log("ERROR", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void logInfo(String msg) {
        void var1_1;
        this.log("INFO", (String)var1_1);
    }

    public StringBuffer getClassBuffer() {
        return this.classBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public void createContent(String content) {
        void var1_1;
        this.replaceVariable("content", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setFilename(String filename) {
        void var1_1;
        if (!filename.endsWith("java")) {
            filename = filename + ".java";
        }
        this.filename = var1_1;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void log(String level, String msg) {
        void var1_1;
        void var2_2;
        String _msg = level + " " + this.getTime() + " : " + (String)var2_2;
        System.out.println((String)var1_1);
    }

    private String getTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return simpleDateFormat.format(new Date());
    }

    protected abstract String getClassTemplate();

    /*
     * WARNING - void declaration
     */
    protected void readTemplateFile(String filename) throws IOException {
        this.templateBuffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                void var1_1;
                this.templateBuffer.append((String)var1_1 + CR);
            }
        }
        catch (Throwable throwable) {
            if (reader != null) {
                void var2_3;
                var2_3.close();
            }
            throw throwable;
        }
        reader.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void replaceVariable(String name, String value) {
        if (value == null) {
            value = "";
        }
        name = Pattern.compile("\\$\\{" + (String)name + "\\}");
        Matcher matcher = ((Pattern)name).matcher(this.classBuffer);
        String result = "";
        while (matcher.find()) {
            void replacement;
            result = matcher.replaceAll((String)replacement);
        }
        if (result.length() > 0) {
            void var3_3;
            this.classBuffer = new StringBuffer((String)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createPackageName(String packagename) {
        void var1_1;
        this.replaceVariable("packagename", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void createClassName(String name) {
        void var1_1;
        this.replaceVariable("classname", (String)var1_1);
    }

    protected boolean isReservedMethod(String method) {
        int i;
        for (i = 0; i < IUNKNOWN_METHODS.length; ++i) {
            if (!IUNKNOWN_METHODS[i].equalsIgnoreCase(method)) continue;
            return true;
        }
        for (i = 0; i < IDISPATCH_METHODS.length; ++i) {
            if (!IDISPATCH_METHODS[i].equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    protected boolean isVTableMode() {
        return this.bindingMode.equalsIgnoreCase("vtable");
    }

    protected boolean isDispIdMode() {
        return this.bindingMode.equalsIgnoreCase("dispid");
    }
}

