/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.tlb;

import com.sun.jna.platform.win32.COM.TypeLibUtil;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbBase;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbCmdlineArgs;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbCoClass;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbConst;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbDispInterface;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbEnum;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbInterface;
import com.sun.jna.platform.win32.OaIdl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TlbImp
implements TlbConst {
    private TypeLibUtil typeLibUtil;
    private File comRootDir;
    private File outputDir;
    private TlbCmdlineArgs cmdlineArgs;

    public static void main(String[] args) {
        String[] stringArray;
        new TlbImp(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public TlbImp(String[] args) {
        this.cmdlineArgs = new TlbCmdlineArgs(args);
        if (this.cmdlineArgs.isTlbId()) {
            void var3_3;
            void var2_2;
            String clsid = this.cmdlineArgs.getRequiredParam("tlb.id");
            int majorVersion = this.cmdlineArgs.getIntParam("tlb.major.version");
            int minorVersion = this.cmdlineArgs.getIntParam("tlb.minor.version");
            this.typeLibUtil = new TypeLibUtil(clsid, (int)var2_2, (int)var3_3);
            this.startCOM2Java();
            return;
        }
        if (this.cmdlineArgs.isTlbFile()) {
            void var1_1;
            String file = this.cmdlineArgs.getRequiredParam("tlb.file");
            this.typeLibUtil = new TypeLibUtil((String)var1_1);
            this.startCOM2Java();
            return;
        }
        this.cmdlineArgs.showCmdHelp();
    }

    /*
     * WARNING - void declaration
     */
    public void startCOM2Java() {
        try {
            void var2_3;
            this.createDir();
            String bindingMode = this.cmdlineArgs.getBindingMode();
            int typeInfoCount = this.typeLibUtil.getTypeInfoCount();
            for (int i = 0; i < typeInfoCount; ++i) {
                OaIdl.TYPEKIND typekind = this.typeLibUtil.getTypeInfoType(i);
                if (typekind.value == 0) {
                    this.createCOMEnum(i, this.getPackageName(), this.typeLibUtil);
                    continue;
                }
                if (typekind.value == 1) {
                    TlbImp.logInfo("'TKIND_RECORD' objects are currently not supported!");
                    continue;
                }
                if (typekind.value == 2) {
                    TlbImp.logInfo("'TKIND_MODULE' objects are currently not supported!");
                    continue;
                }
                if (typekind.value == 3) {
                    this.createCOMInterface(i, this.getPackageName(), this.typeLibUtil);
                    continue;
                }
                if (typekind.value == 4) {
                    this.createCOMDispInterface(i, this.getPackageName(), this.typeLibUtil);
                    continue;
                }
                if (typekind.value == 5) {
                    this.createCOMCoClass(i, this.getPackageName(), this.typeLibUtil, bindingMode);
                    continue;
                }
                if (typekind.value == 6) {
                    TlbImp.logInfo("'TKIND_ALIAS' objects are currently not supported!");
                    continue;
                }
                if (typekind.value != 7) continue;
                TlbImp.logInfo("'TKIND_UNION' objects are currently not supported!");
            }
            TlbImp.logInfo((int)var2_3 + " files sucessfully written to: " + this.comRootDir.toString());
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createDir() throws FileNotFoundException {
        String _outputDir = this.cmdlineArgs.getParam("output.dir");
        String path = "_jnaCOM_" + System.currentTimeMillis() + "\\myPackage\\" + this.typeLibUtil.getName().toLowerCase() + "\\";
        if (_outputDir != null) {
            this.comRootDir = new File(_outputDir + "\\" + path);
        } else {
            void var2_2;
            void var1_1;
            String tmp = System.getProperty("java.io.tmpdir");
            this.comRootDir = new File((String)var1_1 + "\\" + (String)var2_2);
        }
        if (this.comRootDir.exists()) {
            this.comRootDir.delete();
        }
        if (this.comRootDir.mkdirs()) {
            TlbImp.logInfo("Output directory sucessfully created.");
            return;
        }
        throw new FileNotFoundException("Output directory NOT sucessfully created to: " + this.comRootDir.toString());
    }

    private String getPackageName() {
        return "myPackage." + this.typeLibUtil.getName().toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    private void writeTextFile(String filename, String str) throws IOException {
        void var1_1;
        void var2_2;
        String file = this.comRootDir + File.separator + filename;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bos.write(var2_2.getBytes());
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    private void writeTlbClass(TlbBase tlbBase) throws IOException {
        void var2_2;
        void var1_1;
        StringBuffer classBuffer = tlbBase.getClassBuffer();
        this.writeTextFile(var1_1.getFilename(), var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void createCOMEnum(int index, String packagename, TypeLibUtil typeLibUtil) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        TlbEnum tlbEnum = new TlbEnum(index, (String)var2_3, (TypeLibUtil)var3_4);
        this.writeTlbClass((TlbBase)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void createCOMInterface(int index, String packagename, TypeLibUtil typeLibUtil) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        TlbInterface tlbInterface = new TlbInterface(index, (String)var2_3, (TypeLibUtil)var3_4);
        this.writeTlbClass((TlbBase)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void createCOMDispInterface(int index, String packagename, TypeLibUtil typeLibUtil) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        TlbDispInterface tlbDispatch = new TlbDispInterface(index, (String)var2_3, (TypeLibUtil)var3_4);
        this.writeTlbClass((TlbBase)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void createCOMCoClass(int index, String packagename, TypeLibUtil typeLibUtil, String bindingMode) throws IOException {
        void var1_2;
        void var3_4;
        TlbCoClass tlbCoClass = new TlbCoClass(index, this.getPackageName(), (TypeLibUtil)var3_4, bindingMode);
        this.writeTlbClass((TlbBase)var1_2);
    }

    public static void logInfo(String msg) {
        String string;
        System.out.println(string);
    }
}

