/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Wbemcli;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class WbemcliUtil {
    public static final WbemcliUtil INSTANCE = new WbemcliUtil();
    public static final String DEFAULT_NAMESPACE = "ROOT\\CIMV2";

    public static boolean hasNamespace(String namespace) {
        String ns = namespace;
        if (((String)namespace).toUpperCase().startsWith("ROOT\\")) {
            ns = ((String)namespace).substring(5);
        }
        namespace = new WmiQuery<NamespaceProperty>("ROOT", "__NAMESPACE", NamespaceProperty.class);
        WmiResult<NamespaceProperty> namespaces = ((WmiQuery)namespace).execute();
        for (int i = 0; i < namespaces.getResultCount(); ++i) {
            if (!ns.equalsIgnoreCase((String)namespaces.getValue(NamespaceProperty.NAME, i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static Wbemcli.IWbemServices connectServer(String namespace) {
        Wbemcli.IWbemServices iWbemServices;
        Wbemcli.IWbemLocator loc = Wbemcli.IWbemLocator.create();
        if (loc == null) {
            throw new COMException("Failed to create WbemLocator object.");
        }
        Wbemcli.IWbemServices services = loc.ConnectServer(namespace, null, null, null, 0, null, null);
        loc.Release();
        WinNT.HRESULT hres = Ole32.INSTANCE.CoSetProxyBlanket(services, 10, 0, null, 3, 3, null, 0);
        if (COMUtils.FAILED(hres)) {
            void var1_1;
            services.Release();
            throw new COMException("Could not set proxy blanket.", (WinNT.HRESULT)var1_1);
        }
        return iWbemServices;
    }

    public class WmiResult<T extends Enum<T>> {
        private Map<T, List<Object>> propertyMap;
        private Map<T, Integer> vtTypeMap;
        private Map<T, Integer> cimTypeMap;
        private int resultCount = 0;
        final /* synthetic */ WbemcliUtil this$0;

        /*
         * WARNING - void declaration
         */
        public WmiResult(WbemcliUtil this$0, Class<T> propertyEnum) {
            void var2_2;
            Enum[] enumArray;
            this.this$0 = enumArray;
            this.propertyMap = new EnumMap<T, List<Object>>(propertyEnum);
            this.vtTypeMap = new EnumMap<T, Integer>(propertyEnum);
            this.cimTypeMap = new EnumMap<T, Integer>(propertyEnum);
            for (Enum prop : (Enum[])var2_2.getEnumConstants()) {
                this.propertyMap.put(prop, new ArrayList());
                this.vtTypeMap.put(prop, 1);
                this.cimTypeMap.put(prop, 0);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Object getValue(T property, int index) {
            void var2_2;
            void var1_1;
            return this.propertyMap.get(var1_1).get((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public int getVtType(T property) {
            void var1_1;
            return this.vtTypeMap.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public int getCIMType(T property) {
            void var1_1;
            return this.cimTypeMap.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void add(int vtType, int cimType, T property, Object o) {
            this.propertyMap.get(property).add(o);
            if (vtType != 1 && this.vtTypeMap.get(property).equals(1)) {
                void var1_1;
                this.vtTypeMap.put(property, (int)var1_1);
            }
            if (this.cimTypeMap.get(property).equals(0)) {
                void var2_2;
                void var3_3;
                this.cimTypeMap.put(var3_3, (int)var2_2);
            }
        }

        public int getResultCount() {
            return this.resultCount;
        }

        private void incrementResultCount() {
            ++this.resultCount;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$000(WmiResult x0, int x1, int x2, Enum x3, Object x4) {
            void var3_3;
            void var2_2;
            void var1_1;
            x0.add((int)var1_1, (int)var2_2, var3_3, x4);
        }
    }

    public static class WmiQuery<T extends Enum<T>> {
        private String nameSpace;
        private String wmiClassName;
        private Class<T> propertyEnum;

        /*
         * WARNING - void declaration
         */
        public WmiQuery(String nameSpace, String wmiClassName, Class<T> propertyEnum) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.nameSpace = var1_1;
            this.wmiClassName = var2_2;
            this.propertyEnum = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public WmiQuery(String wmiClassName, Class<T> propertyEnum) {
            this(WbemcliUtil.DEFAULT_NAMESPACE, (String)var1_1, (Class<T>)var2_2);
            void var2_2;
            void var1_1;
        }

        public Class<T> getPropertyEnum() {
            return this.propertyEnum;
        }

        public String getNameSpace() {
            return this.nameSpace;
        }

        /*
         * WARNING - void declaration
         */
        public void setNameSpace(String nameSpace) {
            void var1_1;
            this.nameSpace = var1_1;
        }

        public String getWmiClassName() {
            return this.wmiClassName;
        }

        /*
         * WARNING - void declaration
         */
        public void setWmiClassName(String wmiClassName) {
            void var1_1;
            this.wmiClassName = var1_1;
        }

        public WmiResult<T> execute() {
            try {
                return this.execute(-1);
            }
            catch (TimeoutException timeoutException) {
                throw new COMException("Got a WMI timeout when infinite wait was specified. This should never happen.");
            }
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        public WmiResult<T> execute(int timeout) throws TimeoutException {
            void var1_1;
            if (((Enum[])this.getPropertyEnum().getEnumConstants()).length <= 0) {
                throw new IllegalArgumentException("The query's property enum has no values.");
            }
            Wbemcli.IWbemServices svc = WbemcliUtil.connectServer(this.getNameSpace());
            Wbemcli.IEnumWbemClassObject enumerator = WmiQuery.selectProperties(svc, this);
            WmiResult<T> wmiResult = WmiQuery.enumerateProperties(enumerator, this.getPropertyEnum(), (int)var1_1);
            enumerator.Release();
            svc.Release();
            return wmiResult;
            {
                catch (Throwable throwable) {
                    try {
                        void var3_6;
                        var3_6.Release();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        void var2_5;
                        var2_5.Release();
                        throw throwable2;
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private static <T extends Enum<T>> Wbemcli.IEnumWbemClassObject selectProperties(Wbemcli.IWbemServices svc, WmiQuery<T> query) {
            void var3_3;
            Wbemcli.IWbemServices iWbemServices;
            void var1_1;
            Enum[] props = (Enum[])query.getPropertyEnum().getEnumConstants();
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(props[0].name());
            for (int i = 1; i < props.length; ++i) {
                sb.append(',').append(props[i].name());
            }
            sb.append(" FROM ").append(var1_1.getWmiClassName());
            return iWbemServices.ExecQuery("WQL", var3_3.toString().replaceAll("\\\\", "\\\\\\\\"), 48, null);
        }

        /*
         * WARNING - void declaration
         */
        private static <T extends Enum<T>> WmiResult<T> enumerateProperties(Wbemcli.IEnumWbemClassObject enumerator, Class<T> propertyEnum, int timeout) throws TimeoutException {
            void var3_3;
            WinNT.HRESULT hres;
            WbemcliUtil wbemcliUtil = INSTANCE;
            wbemcliUtil.getClass();
            WmiResult<T> values = new WmiResult<T>(wbemcliUtil, propertyEnum);
            Pointer[] pclsObj = new Pointer[1];
            IntByReference uReturn = new IntByReference(0);
            HashMap<Enum, WString> wstrMap = new HashMap<Enum, WString>();
            for (Enum property : (Enum[])propertyEnum.getEnumConstants()) {
                wstrMap.put(property, new WString(property.name()));
            }
            while (enumerator.getPointer() != Pointer.NULL && (hres = enumerator.Next(timeout, pclsObj.length, pclsObj, uReturn)).intValue() != 1 && hres.intValue() != 262149) {
                if (hres.intValue() == 262148) {
                    throw new TimeoutException("No results after " + timeout + " ms.");
                }
                if (COMUtils.FAILED(hres)) {
                    throw new COMException("Failed to enumerate results.", hres);
                }
                Variant.VARIANT.ByReference pVal = new Variant.VARIANT.ByReference();
                IntByReference pType = new IntByReference();
                Wbemcli.IWbemClassObject clsObj = new Wbemcli.IWbemClassObject(pclsObj[0]);
                for (Enum property : (Enum[])propertyEnum.getEnumConstants()) {
                    clsObj.Get((WString)wstrMap.get(property), 0, pVal, pType, null);
                    int vtType = ((Number)((Object)(pVal.getValue() == null ? Integer.valueOf(1) : pVal.getVarType()))).intValue();
                    int cimType = pType.getValue();
                    switch (vtType) {
                        case 8: {
                            WmiResult.access$000(values, vtType, cimType, property, pVal.stringValue());
                            break;
                        }
                        case 3: {
                            WmiResult.access$000(values, vtType, cimType, property, pVal.intValue());
                            break;
                        }
                        case 17: {
                            WmiResult.access$000(values, vtType, cimType, property, pVal.byteValue());
                            break;
                        }
                        case 2: {
                            WmiResult.access$000(values, vtType, cimType, property, pVal.shortValue());
                            break;
                        }
                        case 11: {
                            WmiResult.access$000(values, vtType, cimType, property, pVal.booleanValue());
                            break;
                        }
                        case 4: {
                            WmiResult.access$000(values, vtType, cimType, property, Float.valueOf(pVal.floatValue()));
                            break;
                        }
                        case 5: {
                            WmiResult.access$000(values, vtType, cimType, property, pVal.doubleValue());
                            break;
                        }
                        case 0: 
                        case 1: {
                            WmiResult.access$000(values, vtType, cimType, property, null);
                            break;
                        }
                        default: {
                            if ((vtType & 0x2000) == 8192 || (vtType & 0xD) == 13 || (vtType & 9) == 9 || (vtType & 0x1000) == 4096) {
                                WmiResult.access$000(values, vtType, cimType, property, null);
                                break;
                            }
                            WmiResult.access$000(values, vtType, cimType, property, pVal.getValue());
                        }
                    }
                    OleAuto.INSTANCE.VariantClear(pVal);
                }
                clsObj.Release();
                ((WmiResult)values).incrementResultCount();
            }
            return var3_3;
        }
    }

    private static enum NamespaceProperty {
        NAME;

    }
}

