/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.ITypeInfo;
import com.sun.jna.platform.win32.COM.ITypeLib;
import com.sun.jna.platform.win32.COM.TypeComp;
import com.sun.jna.platform.win32.COM.TypeInfo;
import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLib;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class TypeLibUtil {
    public static final OleAuto OLEAUTO = OleAuto.INSTANCE;
    private ITypeLib typelib;
    private WinDef.LCID lcid = Kernel32.INSTANCE.GetUserDefaultLCID();
    private String name;
    private String docString;
    private int helpContext;
    private String helpFile;

    /*
     * WARNING - void declaration
     */
    public TypeLibUtil(String clsidStr, int wVerMajor, int wVerMinor) {
        void var3_3;
        void var2_2;
        WinNT.HRESULT hRESULT;
        Guid.CLSID.ByReference clsid = new Guid.CLSID.ByReference();
        hRESULT = Ole32.INSTANCE.CLSIDFromString((String)((Object)hRESULT), clsid);
        COMUtils.checkRC(hRESULT);
        PointerByReference pTypeLib = new PointerByReference();
        hRESULT = OleAuto.INSTANCE.LoadRegTypeLib(clsid, (int)var2_2, (int)var3_3, this.lcid, pTypeLib);
        COMUtils.checkRC(hRESULT);
        this.typelib = new TypeLib(pTypeLib.getValue());
        this.initTypeLibInfo();
    }

    /*
     * WARNING - void declaration
     */
    public TypeLibUtil(String file) {
        void var2_2;
        WinNT.HRESULT hRESULT;
        PointerByReference pTypeLib = new PointerByReference();
        hRESULT = OleAuto.INSTANCE.LoadTypeLib((String)((Object)hRESULT), pTypeLib);
        COMUtils.checkRC(hRESULT);
        this.typelib = new TypeLib(var2_2.getValue());
        this.initTypeLibInfo();
    }

    /*
     * WARNING - void declaration
     */
    private void initTypeLibInfo() {
        void var1_1;
        TypeLibDoc documentation = this.getDocumentation(-1);
        this.name = documentation.getName();
        this.docString = documentation.getDocString();
        this.helpContext = documentation.getHelpContext();
        this.helpFile = var1_1.getHelpFile();
    }

    public int getTypeInfoCount() {
        return this.typelib.GetTypeInfoCount().intValue();
    }

    /*
     * WARNING - void declaration
     */
    public OaIdl.TYPEKIND getTypeInfoType(int index) {
        void var2_3;
        void var1_1;
        OaIdl.TYPEKIND.ByReference typekind = new OaIdl.TYPEKIND.ByReference();
        WinNT.HRESULT hRESULT = this.typelib.GetTypeInfoType(new WinDef.UINT((long)var1_1), typekind);
        COMUtils.checkRC(hRESULT);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public ITypeInfo getTypeInfo(int index) {
        void var2_3;
        void var1_1;
        PointerByReference ppTInfo = new PointerByReference();
        WinNT.HRESULT hRESULT = this.typelib.GetTypeInfo(new WinDef.UINT((long)var1_1), ppTInfo);
        COMUtils.checkRC(hRESULT);
        return new TypeInfo(var2_3.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public TypeInfoUtil getTypeInfoUtil(int index) {
        void var1_1;
        return new TypeInfoUtil(this.getTypeInfo((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public OaIdl.TLIBATTR getLibAttr() {
        void var1_1;
        PointerByReference ppTLibAttr = new PointerByReference();
        WinNT.HRESULT hRESULT = this.typelib.GetLibAttr(ppTLibAttr);
        COMUtils.checkRC(hRESULT);
        return new OaIdl.TLIBATTR(var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public TypeComp GetTypeComp() {
        void var1_1;
        PointerByReference ppTComp = new PointerByReference();
        WinNT.HRESULT hRESULT = this.typelib.GetTypeComp(ppTComp);
        COMUtils.checkRC(hRESULT);
        return new TypeComp(var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public TypeLibDoc getDocumentation(int index2) {
        void var1_2;
        void var3_4;
        void var2_3;
        WTypes.BSTRByReference pBstrName = new WTypes.BSTRByReference();
        WTypes.BSTRByReference pBstrDocString = new WTypes.BSTRByReference();
        WinDef.DWORDByReference pdwHelpContext = new WinDef.DWORDByReference();
        WTypes.BSTRByReference pBstrHelpFile = new WTypes.BSTRByReference();
        WinNT.HRESULT index2 = this.typelib.GetDocumentation(index2, pBstrName, pBstrDocString, pdwHelpContext, pBstrHelpFile);
        COMUtils.checkRC(index2);
        TypeLibDoc typeLibDoc = new TypeLibDoc(pBstrName.getString(), pBstrDocString.getString(), pdwHelpContext.getValue().intValue(), pBstrHelpFile.getString());
        OLEAUTO.SysFreeString(var2_3.getValue());
        OLEAUTO.SysFreeString(var3_4.getValue());
        OLEAUTO.SysFreeString(pBstrHelpFile.getValue());
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public IsName IsName(String nameBuf, int hashVal) {
        void var3_4;
        void var1_1;
        WinNT.HRESULT hRESULT;
        WTypes.LPOLESTR szNameBuf = new WTypes.LPOLESTR(nameBuf);
        WinDef.ULONG lHashVal = new WinDef.ULONG(hashVal);
        WinDef.BOOLByReference pfName = new WinDef.BOOLByReference();
        hRESULT = this.typelib.IsName(szNameBuf, (WinDef.ULONG)((Object)hRESULT), pfName);
        COMUtils.checkRC(hRESULT);
        return new IsName(var1_1.getValue(), var3_4.getValue().booleanValue());
    }

    /*
     * WARNING - void declaration
     */
    public FindName FindName(String name, int hashVal, short maxResult) {
        void var1_1;
        void var2_3;
        void var3_5;
        Pointer p = Ole32.INSTANCE.CoTaskMemAlloc(((long)name.length() + 1L) * (long)Native.WCHAR_SIZE);
        WTypes.LPOLESTR olestr = new WTypes.LPOLESTR(p);
        olestr.setValue(name);
        Object lHashVal = new WinDef.ULONG(hashVal);
        WinDef.USHORTByReference pcFound = new WinDef.USHORTByReference(maxResult);
        Pointer[] ppTInfo = new Pointer[maxResult];
        OaIdl.MEMBERID[] rgMemId = new OaIdl.MEMBERID[maxResult];
        lHashVal = this.typelib.FindName(olestr, (WinDef.ULONG)lHashVal, ppTInfo, rgMemId, pcFound);
        COMUtils.checkRC((WinNT.HRESULT)((Object)lHashVal));
        FindName findName = new FindName(olestr.getValue(), ppTInfo, (OaIdl.MEMBERID[])var3_5, var2_3.getValue().shortValue());
        Ole32.INSTANCE.CoTaskMemFree(p);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void ReleaseTLibAttr(OaIdl.TLIBATTR pTLibAttr) {
        void var1_1;
        this.typelib.ReleaseTLibAttr((OaIdl.TLIBATTR)var1_1);
    }

    public WinDef.LCID getLcid() {
        return this.lcid;
    }

    public ITypeLib getTypelib() {
        return this.typelib;
    }

    public String getName() {
        return this.name;
    }

    public String getDocString() {
        return this.docString;
    }

    public int getHelpContext() {
        return this.helpContext;
    }

    public String getHelpFile() {
        return this.helpFile;
    }

    public static class FindName {
        private String nameBuf;
        private Pointer[] pTInfo;
        private OaIdl.MEMBERID[] rgMemId;
        private short pcFound;

        /*
         * WARNING - void declaration
         */
        FindName(String nameBuf, Pointer[] pTInfo, OaIdl.MEMBERID[] rgMemId, short pcFound) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.nameBuf = var1_1;
            this.pTInfo = new Pointer[pcFound];
            this.rgMemId = new OaIdl.MEMBERID[pcFound];
            this.pcFound = pcFound;
            System.arraycopy(var2_2, 0, this.pTInfo, 0, pcFound);
            System.arraycopy(var3_3, 0, this.rgMemId, 0, pcFound);
        }

        public String getNameBuf() {
            return this.nameBuf;
        }

        /*
         * WARNING - void declaration
         */
        public ITypeInfo[] getTInfo() {
            void var1_1;
            ITypeInfo[] values = new ITypeInfo[this.pcFound];
            for (int i = 0; i < this.pcFound; ++i) {
                values[i] = new TypeInfo(this.pTInfo[i]);
            }
            return var1_1;
        }

        public OaIdl.MEMBERID[] getMemId() {
            return this.rgMemId;
        }

        public short getFound() {
            return this.pcFound;
        }
    }

    public static class IsName {
        private String nameBuf;
        private boolean name;

        /*
         * WARNING - void declaration
         */
        public IsName(String nameBuf, boolean name) {
            void var2_2;
            void var1_1;
            this.nameBuf = var1_1;
            this.name = var2_2;
        }

        public String getNameBuf() {
            return this.nameBuf;
        }

        public boolean isName() {
            return this.name;
        }
    }

    public static class TypeLibDoc {
        private String name;
        private String docString;
        private int helpContext;
        private String helpFile;

        /*
         * WARNING - void declaration
         */
        public TypeLibDoc(String name, String docString, int helpContext, String helpFile) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.docString = var2_2;
            this.helpContext = var3_3;
            this.helpFile = helpFile;
        }

        public String getName() {
            return this.name;
        }

        public String getDocString() {
            return this.docString;
        }

        public int getHelpContext() {
            return this.helpContext;
        }

        public String getHelpFile() {
            return this.helpFile;
        }
    }
}

