/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.unix;

import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;

public class LibCUtil {
    private static final NativeLibrary LIBC = NativeLibrary.getInstance((String)"c");
    private static Function mmap = null;
    private static boolean mmap64 = false;
    private static Function ftruncate = null;
    private static boolean ftruncate64 = false;

    private LibCUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static Pointer mmap(Pointer addr, long length, int prot, int flags, int fd, long offset) {
        void var3_2;
        Pointer pointer;
        Object[] objectArray = new Object[6];
        Object[] params = objectArray;
        objectArray[0] = pointer;
        if (Native.SIZE_T_SIZE == 4) {
            LibCUtil.require32Bit(length, "length");
            params[1] = (int)length;
        } else {
            void var1_1;
            params[1] = (long)var1_1;
        }
        params[2] = (int)var3_2;
        params[3] = flags;
        params[4] = fd;
        if (mmap64 || Native.LONG_SIZE > 4) {
            params[5] = offset;
        } else {
            LibCUtil.require32Bit(offset, "offset");
            params[5] = (int)offset;
        }
        return mmap.invokePointer(params);
    }

    /*
     * WARNING - void declaration
     */
    public static int ftruncate(int fd, long length) {
        void var3_2;
        int n;
        Object[] objectArray = new Object[2];
        Object[] params = objectArray;
        objectArray[0] = n;
        if (ftruncate64 || Native.LONG_SIZE > 4) {
            params[1] = length;
        } else {
            void var1_1;
            LibCUtil.require32Bit(length, "length");
            params[1] = (int)var1_1;
        }
        return ftruncate.invokeInt((Object[])var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void require32Bit(long val, String value) {
        if (val > Integer.MAX_VALUE) {
            void var2_1;
            throw new IllegalArgumentException((String)var2_1 + " exceeds 32bit");
        }
    }

    static {
        try {
            mmap = LIBC.getFunction("mmap64", 64);
            mmap64 = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            mmap = LIBC.getFunction("mmap", 64);
        }
        try {
            ftruncate = LIBC.getFunction("ftruncate64", 64);
            ftruncate64 = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            ftruncate = LIBC.getFunction("ftruncate", 64);
        }
    }
}

