/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.IOReturnException;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;

public interface IOKit
extends Library {
    public static final IOKit INSTANCE = (IOKit)Native.load((String)"IOKit", IOKit.class);
    public static final int kIORegistryIterateRecursively = 1;
    public static final int kIORegistryIterateParents = 2;
    public static final int kIOReturnNoDevice = -536870208;
    public static final double kIOPSTimeRemainingUnlimited = -2.0;
    public static final double kIOPSTimeRemainingUnknown = -1.0;

    public int IOMasterPort(int var1, IntByReference var2);

    public CoreFoundation.CFMutableDictionaryRef IOServiceMatching(String var1);

    public CoreFoundation.CFMutableDictionaryRef IOServiceNameMatching(String var1);

    public CoreFoundation.CFMutableDictionaryRef IOBSDNameMatching(int var1, int var2, String var3);

    public IOService IOServiceGetMatchingService(int var1, CoreFoundation.CFDictionaryRef var2);

    public int IOServiceGetMatchingServices(int var1, CoreFoundation.CFDictionaryRef var2, PointerByReference var3);

    public IORegistryEntry IOIteratorNext(IOIterator var1);

    public CoreFoundation.CFTypeRef IORegistryEntryCreateCFProperty(IORegistryEntry var1, CoreFoundation.CFStringRef var2, CoreFoundation.CFAllocatorRef var3, int var4);

    public int IORegistryEntryCreateCFProperties(IORegistryEntry var1, PointerByReference var2, CoreFoundation.CFAllocatorRef var3, int var4);

    public CoreFoundation.CFTypeRef IORegistryEntrySearchCFProperty(IORegistryEntry var1, String var2, CoreFoundation.CFStringRef var3, CoreFoundation.CFAllocatorRef var4, int var5);

    public int IORegistryEntryGetRegistryEntryID(IORegistryEntry var1, LongByReference var2);

    public int IORegistryEntryGetName(IORegistryEntry var1, Pointer var2);

    public int IORegistryEntryGetChildIterator(IORegistryEntry var1, String var2, PointerByReference var3);

    public int IORegistryEntryGetChildEntry(IORegistryEntry var1, String var2, PointerByReference var3);

    public int IORegistryEntryGetParentEntry(IORegistryEntry var1, String var2, PointerByReference var3);

    public IORegistryEntry IORegistryGetRootEntry(int var1);

    public boolean IOObjectConformsTo(IOObject var1, String var2);

    public int IOObjectRelease(IOObject var1);

    public int IOServiceOpen(IOService var1, int var2, int var3, PointerByReference var4);

    public int IOServiceGetBusyState(IOService var1, IntByReference var2);

    public int IOServiceClose(IOConnect var1);

    public CoreFoundation.CFTypeRef IOPSCopyPowerSourcesInfo();

    public CoreFoundation.CFArrayRef IOPSCopyPowerSourcesList(CoreFoundation.CFTypeRef var1);

    public CoreFoundation.CFDictionaryRef IOPSGetPowerSourceDescription(CoreFoundation.CFTypeRef var1, CoreFoundation.CFTypeRef var2);

    public double IOPSGetTimeRemainingEstimate();

    public static class IOConnect
    extends IOService {
        public IOConnect() {
        }

        /*
         * WARNING - void declaration
         */
        public IOConnect(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class IOService
    extends IORegistryEntry {
        public IOService() {
        }

        /*
         * WARNING - void declaration
         */
        public IOService(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }
    }

    public static class IORegistryEntry
    extends IOObject {
        public IORegistryEntry() {
        }

        /*
         * WARNING - void declaration
         */
        public IORegistryEntry(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public long getRegistryEntryID() {
            void var1_1;
            LongByReference id = new LongByReference();
            int kr = INSTANCE.IORegistryEntryGetRegistryEntryID(this, id);
            if (kr != 0) {
                void var2_2;
                throw new IOReturnException((int)var2_2);
            }
            return var1_1.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public String getName() {
            void var1_1;
            Memory name = new Memory(128L);
            int kr = INSTANCE.IORegistryEntryGetName(this, (Pointer)name);
            if (kr != 0) {
                void var2_2;
                throw new IOReturnException((int)var2_2);
            }
            return var1_1.getString(0L);
        }

        /*
         * WARNING - void declaration
         */
        public IOIterator getChildIterator(String plane) {
            void var2_3;
            PointerByReference iter = new PointerByReference();
            int kr = INSTANCE.IORegistryEntryGetChildIterator(this, plane, iter);
            if (kr != 0) {
                void var1_2;
                throw new IOReturnException((int)var1_2);
            }
            return new IOIterator(var2_3.getValue());
        }

        /*
         * WARNING - void declaration
         */
        public IORegistryEntry getChildEntry(String plane) {
            void var2_3;
            PointerByReference child = new PointerByReference();
            int kr = INSTANCE.IORegistryEntryGetChildEntry(this, plane, child);
            if (kr == -536870208) {
                return null;
            }
            if (kr != 0) {
                void var1_2;
                throw new IOReturnException((int)var1_2);
            }
            return new IORegistryEntry(var2_3.getValue());
        }

        /*
         * WARNING - void declaration
         */
        public IORegistryEntry getParentEntry(String plane) {
            void var2_3;
            PointerByReference parent = new PointerByReference();
            int kr = INSTANCE.IORegistryEntryGetParentEntry(this, plane, parent);
            if (kr == -536870208) {
                return null;
            }
            if (kr != 0) {
                void var1_2;
                throw new IOReturnException((int)var1_2);
            }
            return new IORegistryEntry(var2_3.getValue());
        }

        /*
         * WARNING - void declaration
         */
        public CoreFoundation.CFTypeRef createCFProperty(CoreFoundation.CFStringRef key) {
            void var1_1;
            return INSTANCE.IORegistryEntryCreateCFProperty(this, (CoreFoundation.CFStringRef)var1_1, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
        }

        /*
         * WARNING - void declaration
         */
        public CoreFoundation.CFMutableDictionaryRef createCFProperties() {
            void var1_1;
            PointerByReference properties = new PointerByReference();
            int kr = INSTANCE.IORegistryEntryCreateCFProperties(this, properties, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
            if (kr != 0) {
                void var2_2;
                throw new IOReturnException((int)var2_2);
            }
            return new CoreFoundation.CFMutableDictionaryRef(var1_1.getValue());
        }

        /*
         * WARNING - void declaration
         */
        CoreFoundation.CFTypeRef searchCFProperty(String plane, CoreFoundation.CFStringRef key, int options) {
            void var3_3;
            void var2_2;
            void var1_1;
            return INSTANCE.IORegistryEntrySearchCFProperty(this, (String)var1_1, (CoreFoundation.CFStringRef)var2_2, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public String getStringProperty(String key) {
            void var2_2;
            CoreFoundation.CFStringRef cFStringRef;
            String value = null;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.createCFString(key);
            CoreFoundation.CFTypeRef valueAsCFType = this.createCFProperty(keyAsCFString);
            cFStringRef.release();
            if (valueAsCFType != null) {
                void var3_3;
                cFStringRef = new CoreFoundation.CFStringRef(valueAsCFType.getPointer());
                value = cFStringRef.stringValue();
                var3_3.release();
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Long getLongProperty(String key) {
            void var2_2;
            CoreFoundation.CFNumberRef cFNumberRef;
            Long value = null;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.createCFString(key);
            CoreFoundation.CFTypeRef valueAsCFType = this.createCFProperty(keyAsCFString);
            cFNumberRef.release();
            if (valueAsCFType != null) {
                void var3_3;
                cFNumberRef = new CoreFoundation.CFNumberRef(valueAsCFType.getPointer());
                value = cFNumberRef.longValue();
                var3_3.release();
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Integer getIntegerProperty(String key) {
            void var2_2;
            CoreFoundation.CFNumberRef cFNumberRef;
            Integer value = null;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.createCFString(key);
            CoreFoundation.CFTypeRef valueAsCFType = this.createCFProperty(keyAsCFString);
            cFNumberRef.release();
            if (valueAsCFType != null) {
                void var3_3;
                cFNumberRef = new CoreFoundation.CFNumberRef(valueAsCFType.getPointer());
                value = cFNumberRef.intValue();
                var3_3.release();
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Double getDoubleProperty(String key) {
            void var2_2;
            CoreFoundation.CFNumberRef cFNumberRef;
            Double value = null;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.createCFString(key);
            CoreFoundation.CFTypeRef valueAsCFType = this.createCFProperty(keyAsCFString);
            cFNumberRef.release();
            if (valueAsCFType != null) {
                void var3_3;
                cFNumberRef = new CoreFoundation.CFNumberRef(valueAsCFType.getPointer());
                value = cFNumberRef.doubleValue();
                var3_3.release();
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Boolean getBooleanProperty(String key) {
            void var2_2;
            CoreFoundation.CFBooleanRef cFBooleanRef;
            Boolean value = null;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.createCFString(key);
            CoreFoundation.CFTypeRef valueAsCFType = this.createCFProperty(keyAsCFString);
            cFBooleanRef.release();
            if (valueAsCFType != null) {
                void var3_3;
                cFBooleanRef = new CoreFoundation.CFBooleanRef(valueAsCFType.getPointer());
                value = cFBooleanRef.booleanValue();
                var3_3.release();
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public byte[] getByteArrayProperty(String key) {
            byte[] byArray;
            Object value = null;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.createCFString(key);
            CoreFoundation.CFTypeRef valueAsCFType = this.createCFProperty(keyAsCFString);
            keyAsCFString.release();
            if (valueAsCFType != null) {
                void var3_4;
                void var2_3;
                Pointer pointer;
                CoreFoundation.CFDataRef valueAsCFData = new CoreFoundation.CFDataRef(valueAsCFType.getPointer());
                int length = valueAsCFData.getLength();
                pointer = pointer.getBytePtr();
                byArray = pointer.getByteArray(0L, (int)var2_3);
                var3_4.release();
            }
            return byArray;
        }
    }

    public static class IOIterator
    extends IOObject {
        public IOIterator() {
        }

        /*
         * WARNING - void declaration
         */
        public IOIterator(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }

        public IORegistryEntry next() {
            return INSTANCE.IOIteratorNext(this);
        }
    }

    public static class IOObject
    extends PointerType {
        public IOObject() {
        }

        /*
         * WARNING - void declaration
         */
        public IOObject(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean conformsTo(String className) {
            void var1_1;
            return INSTANCE.IOObjectConformsTo(this, (String)var1_1);
        }

        public int release() {
            return INSTANCE.IOObjectRelease(this);
        }
    }
}

