/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;

public interface CoreFoundation
extends Library {
    public static final CoreFoundation INSTANCE = (CoreFoundation)Native.load((String)"CoreFoundation", CoreFoundation.class);
    public static final int kCFNotFound = -1;
    public static final int kCFStringEncodingASCII = 1536;
    public static final int kCFStringEncodingUTF8 = 0x8000100;
    public static final CFTypeID ARRAY_TYPE_ID = INSTANCE.CFArrayGetTypeID();
    public static final CFTypeID BOOLEAN_TYPE_ID = INSTANCE.CFBooleanGetTypeID();
    public static final CFTypeID DATA_TYPE_ID = INSTANCE.CFDataGetTypeID();
    public static final CFTypeID DATE_TYPE_ID = INSTANCE.CFDateGetTypeID();
    public static final CFTypeID DICTIONARY_TYPE_ID = INSTANCE.CFDictionaryGetTypeID();
    public static final CFTypeID NUMBER_TYPE_ID = INSTANCE.CFNumberGetTypeID();
    public static final CFTypeID STRING_TYPE_ID = INSTANCE.CFStringGetTypeID();

    public CFStringRef CFStringCreateWithCharacters(CFAllocatorRef var1, char[] var2, CFIndex var3);

    public CFNumberRef CFNumberCreate(CFAllocatorRef var1, CFIndex var2, ByReference var3);

    public CFArrayRef CFArrayCreate(CFAllocatorRef var1, Pointer var2, CFIndex var3, Pointer var4);

    public CFDataRef CFDataCreate(CFAllocatorRef var1, Pointer var2, CFIndex var3);

    public CFMutableDictionaryRef CFDictionaryCreateMutable(CFAllocatorRef var1, CFIndex var2, Pointer var3, Pointer var4);

    public CFStringRef CFCopyDescription(CFTypeRef var1);

    public void CFRelease(CFTypeRef var1);

    public CFTypeRef CFRetain(CFTypeRef var1);

    public CFIndex CFGetRetainCount(CFTypeRef var1);

    public CFIndex CFDictionaryGetCount(CFDictionaryRef var1);

    public Pointer CFDictionaryGetValue(CFDictionaryRef var1, PointerType var2);

    public byte CFDictionaryGetValueIfPresent(CFDictionaryRef var1, PointerType var2, PointerByReference var3);

    public void CFDictionarySetValue(CFMutableDictionaryRef var1, PointerType var2, PointerType var3);

    public byte CFStringGetCString(CFStringRef var1, Pointer var2, CFIndex var3, int var4);

    public byte CFBooleanGetValue(CFBooleanRef var1);

    public CFIndex CFArrayGetCount(CFArrayRef var1);

    public Pointer CFArrayGetValueAtIndex(CFArrayRef var1, CFIndex var2);

    public CFIndex CFNumberGetType(CFNumberRef var1);

    public byte CFNumberGetValue(CFNumberRef var1, CFIndex var2, ByReference var3);

    public CFIndex CFStringGetLength(CFStringRef var1);

    public CFIndex CFStringGetMaximumSizeForEncoding(CFIndex var1, int var2);

    public boolean CFEqual(CFTypeRef var1, CFTypeRef var2);

    public CFAllocatorRef CFAllocatorGetDefault();

    public CFIndex CFDataGetLength(CFDataRef var1);

    public Pointer CFDataGetBytePtr(CFDataRef var1);

    public CFTypeID CFGetTypeID(CFTypeRef var1);

    public CFTypeID CFGetTypeID(Pointer var1);

    public CFTypeID CFArrayGetTypeID();

    public CFTypeID CFBooleanGetTypeID();

    public CFTypeID CFDateGetTypeID();

    public CFTypeID CFDataGetTypeID();

    public CFTypeID CFDictionaryGetTypeID();

    public CFTypeID CFNumberGetTypeID();

    public CFTypeID CFStringGetTypeID();

    public static class CFTypeID
    extends NativeLong {
        private static final long serialVersionUID = 1L;

        public CFTypeID() {
        }

        /*
         * WARNING - void declaration
         */
        public CFTypeID(long value) {
            super((long)var1_1);
            void var1_1;
        }

        public String toString() {
            if (this.equals((Object)ARRAY_TYPE_ID)) {
                return "CFArray";
            }
            if (this.equals((Object)BOOLEAN_TYPE_ID)) {
                return "CFBoolean";
            }
            if (this.equals((Object)DATA_TYPE_ID)) {
                return "CFData";
            }
            if (this.equals((Object)DATE_TYPE_ID)) {
                return "CFDate";
            }
            if (this.equals((Object)DICTIONARY_TYPE_ID)) {
                return "CFDictionary";
            }
            if (this.equals((Object)NUMBER_TYPE_ID)) {
                return "CFNumber";
            }
            if (this.equals((Object)STRING_TYPE_ID)) {
                return "CFString";
            }
            return super.toString();
        }
    }

    public static class CFIndex
    extends NativeLong {
        private static final long serialVersionUID = 1L;

        public CFIndex() {
        }

        /*
         * WARNING - void declaration
         */
        public CFIndex(long value) {
            super((long)var1_1);
            void var1_1;
        }
    }

    public static class CFStringRef
    extends CFTypeRef {
        public CFStringRef() {
        }

        /*
         * WARNING - void declaration
         */
        public CFStringRef(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
            if (!this.isTypeID(STRING_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to CFString. Type ID: " + (Object)((Object)this.getTypeID()));
            }
        }

        public static CFStringRef createCFString(String s) {
            Object object;
            Object chars = s.toCharArray();
            return INSTANCE.CFStringCreateWithCharacters(null, (char[])chars, new CFIndex(((Object)object).length));
        }

        /*
         * WARNING - void declaration
         */
        public String stringValue() {
            void var1_1;
            CFIndex length = INSTANCE.CFStringGetLength(this);
            if (length.longValue() == 0L) {
                return "";
            }
            CFIndex maxSize = INSTANCE.CFStringGetMaximumSizeForEncoding(length, 0x8000100);
            if (maxSize.intValue() == -1) {
                throw new StringIndexOutOfBoundsException("CFString maximum number of bytes exceeds LONG_MAX.");
            }
            CFIndex cFIndex = maxSize;
            cFIndex.setValue(cFIndex.longValue() + 1L);
            Memory buf = new Memory(maxSize.longValue());
            if (0 != INSTANCE.CFStringGetCString(this, (Pointer)buf, (CFIndex)var1_1, 0x8000100)) {
                void var2_2;
                return var2_2.getString(0L, "UTF8");
            }
            throw new IllegalArgumentException("CFString conversion fails or the provided buffer is too small.");
        }

        public static class ByReference
        extends PointerByReference {
            public ByReference() {
                this(null);
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(CFStringRef value) {
                super(value != null ? var1_1.getPointer() : null);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public void setValue(Pointer value) {
                void var1_1;
                CFTypeID typeId;
                if (value != null && !STRING_TYPE_ID.equals((Object)(typeId = INSTANCE.CFGetTypeID(value)))) {
                    void var2_2;
                    throw new ClassCastException("Unable to cast to CFString. Type ID: " + var2_2);
                }
                super.setValue((Pointer)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public CFStringRef getStringRefValue() {
                void var1_1;
                Pointer value = super.getValue();
                if (value == null) {
                    return null;
                }
                return new CFStringRef((Pointer)var1_1);
            }
        }
    }

    public static class CFMutableDictionaryRef
    extends CFDictionaryRef {
        public CFMutableDictionaryRef() {
        }

        /*
         * WARNING - void declaration
         */
        public CFMutableDictionaryRef(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(PointerType key, PointerType value) {
            void var2_2;
            void var1_1;
            INSTANCE.CFDictionarySetValue(this, (PointerType)var1_1, (PointerType)var2_2);
        }
    }

    public static class CFDictionaryRef
    extends CFTypeRef {
        public CFDictionaryRef() {
        }

        /*
         * WARNING - void declaration
         */
        public CFDictionaryRef(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
            if (!this.isTypeID(DICTIONARY_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to CFDictionary. Type ID: " + (Object)((Object)this.getTypeID()));
            }
        }

        /*
         * WARNING - void declaration
         */
        public Pointer getValue(PointerType key) {
            void var1_1;
            return INSTANCE.CFDictionaryGetValue(this, (PointerType)var1_1);
        }

        public long getCount() {
            return INSTANCE.CFDictionaryGetCount(this).longValue();
        }

        /*
         * WARNING - void declaration
         */
        public boolean getValueIfPresent(PointerType key, PointerByReference value) {
            void var2_2;
            void var1_1;
            return INSTANCE.CFDictionaryGetValueIfPresent(this, (PointerType)var1_1, (PointerByReference)var2_2) > 0;
        }

        public static class ByReference
        extends PointerByReference {
            public ByReference() {
                this(null);
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(CFDictionaryRef value) {
                super(value != null ? var1_1.getPointer() : null);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public void setValue(Pointer value) {
                void var1_1;
                CFTypeID typeId;
                if (value != null && !DICTIONARY_TYPE_ID.equals((Object)(typeId = INSTANCE.CFGetTypeID(value)))) {
                    void var2_2;
                    throw new ClassCastException("Unable to cast to CFDictionary. Type ID: " + var2_2);
                }
                super.setValue((Pointer)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public CFDictionaryRef getDictionaryRefValue() {
                void var1_1;
                Pointer value = super.getValue();
                if (value == null) {
                    return null;
                }
                return new CFDictionaryRef((Pointer)var1_1);
            }
        }
    }

    public static class CFDataRef
    extends CFTypeRef {
        public CFDataRef() {
        }

        /*
         * WARNING - void declaration
         */
        public CFDataRef(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
            if (!this.isTypeID(DATA_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to CFData. Type ID: " + (Object)((Object)this.getTypeID()));
            }
        }

        public int getLength() {
            return INSTANCE.CFDataGetLength(this).intValue();
        }

        public Pointer getBytePtr() {
            return INSTANCE.CFDataGetBytePtr(this);
        }
    }

    public static class CFArrayRef
    extends CFTypeRef {
        public CFArrayRef() {
        }

        /*
         * WARNING - void declaration
         */
        public CFArrayRef(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
            if (!this.isTypeID(ARRAY_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to CFArray. Type ID: " + (Object)((Object)this.getTypeID()));
            }
        }

        public int getCount() {
            return INSTANCE.CFArrayGetCount(this).intValue();
        }

        /*
         * WARNING - void declaration
         */
        public Pointer getValueAtIndex(int idx) {
            void var1_1;
            return INSTANCE.CFArrayGetValueAtIndex(this, new CFIndex((long)var1_1));
        }
    }

    public static class CFBooleanRef
    extends CFTypeRef {
        public CFBooleanRef() {
        }

        /*
         * WARNING - void declaration
         */
        public CFBooleanRef(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
            if (!this.isTypeID(BOOLEAN_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to CFBoolean. Type ID: " + (Object)((Object)this.getTypeID()));
            }
        }

        public boolean booleanValue() {
            return 0 != INSTANCE.CFBooleanGetValue(this);
        }
    }

    public static enum CFNumberType {
        unusedZero,
        kCFNumberSInt8Type,
        kCFNumberSInt16Type,
        kCFNumberSInt32Type,
        kCFNumberSInt64Type,
        kCFNumberFloat32Type,
        kCFNumberFloat64Type,
        kCFNumberCharType,
        kCFNumberShortType,
        kCFNumberIntType,
        kCFNumberLongType,
        kCFNumberLongLongType,
        kCFNumberFloatType,
        kCFNumberDoubleType,
        kCFNumberCFIndexType,
        kCFNumberNSIntegerType,
        kCFNumberCGFloatType,
        kCFNumberMaxType;


        public final CFIndex typeIndex() {
            return new CFIndex(this.ordinal());
        }
    }

    public static class CFNumberRef
    extends CFTypeRef {
        public CFNumberRef() {
        }

        /*
         * WARNING - void declaration
         */
        public CFNumberRef(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
            if (!this.isTypeID(NUMBER_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to CFNumber. Type ID: " + (Object)((Object)this.getTypeID()));
            }
        }

        /*
         * WARNING - void declaration
         */
        public long longValue() {
            void var1_1;
            LongByReference lbr = new LongByReference();
            INSTANCE.CFNumberGetValue(this, CFNumberType.kCFNumberLongLongType.typeIndex(), (ByReference)lbr);
            return var1_1.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public int intValue() {
            void var1_1;
            IntByReference ibr = new IntByReference();
            INSTANCE.CFNumberGetValue(this, CFNumberType.kCFNumberIntType.typeIndex(), (ByReference)ibr);
            return var1_1.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public short shortValue() {
            void var1_1;
            ShortByReference sbr = new ShortByReference();
            INSTANCE.CFNumberGetValue(this, CFNumberType.kCFNumberShortType.typeIndex(), (ByReference)sbr);
            return var1_1.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public byte byteValue() {
            void var1_1;
            ByteByReference bbr = new ByteByReference();
            INSTANCE.CFNumberGetValue(this, CFNumberType.kCFNumberCharType.typeIndex(), (ByReference)bbr);
            return var1_1.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public double doubleValue() {
            void var1_1;
            DoubleByReference dbr = new DoubleByReference();
            INSTANCE.CFNumberGetValue(this, CFNumberType.kCFNumberDoubleType.typeIndex(), (ByReference)dbr);
            return var1_1.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public float floatValue() {
            void var1_1;
            FloatByReference fbr = new FloatByReference();
            INSTANCE.CFNumberGetValue(this, CFNumberType.kCFNumberFloatType.typeIndex(), (ByReference)fbr);
            return var1_1.getValue();
        }
    }

    public static class CFAllocatorRef
    extends CFTypeRef {
    }

    public static class CFTypeRef
    extends PointerType {
        public CFTypeRef() {
        }

        /*
         * WARNING - void declaration
         */
        public CFTypeRef(Pointer p) {
            super((Pointer)var1_1);
            void var1_1;
        }

        public CFTypeID getTypeID() {
            if (this.getPointer() == null) {
                return new CFTypeID(0L);
            }
            return INSTANCE.CFGetTypeID(this);
        }

        /*
         * WARNING - void declaration
         */
        public boolean isTypeID(CFTypeID typeID) {
            void var1_1;
            return this.getTypeID().equals(var1_1);
        }

        public void retain() {
            INSTANCE.CFRetain(this);
        }

        public void release() {
            INSTANCE.CFRelease(this);
        }
    }
}

