/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CodecsKt;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.auth.HeaderValueEncoding;
import io.ktor.http.auth.HttpAuthHeaderKt;
import io.ktor.http.parsing.ParseException;
import io.ktor.util.CryptoKt;
import io.ktor.util.Hash;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000f\u0010\u000e\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\b\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\b\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\n\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lio/ktor/http/auth/HttpAuthHeader;", "", "", "authScheme", "<init>", "(Ljava/lang/String;)V", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "render", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "()Ljava/lang/String;", "toString", "Ljava/lang/String;", "getAuthScheme", "Companion", "Single", "Parameterized", "Parameters", "Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "Lio/ktor/http/auth/HttpAuthHeader$Single;", "ktor-http"})
public abstract class HttpAuthHeader {
    public static final Companion Companion = new Companion(null);
    private final String authScheme;

    private HttpAuthHeader(String authScheme) {
        CharSequence charSequence;
        this.authScheme = charSequence;
        charSequence = this.authScheme;
        if (!HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence)) {
            throw new ParseException("Invalid authScheme value: it should be token, but instead it is " + this.authScheme, null, 2, null);
        }
    }

    public final String getAuthScheme() {
        return this.authScheme;
    }

    public abstract String render(HeaderValueEncoding var1);

    public abstract String render();

    public String toString() {
        return this.render();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ HttpAuthHeader(String authScheme, DefaultConstructorMarker $constructor_marker) {
        this((String)var1_1);
        void var1_1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJQ\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u00042\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Companion;", "", "<init>", "()V", "", "realm", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "basicAuthChallenge", "(Ljava/lang/String;Ljava/nio/charset/Charset;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "scheme", "Lio/ktor/http/auth/HttpAuthHeader;", "bearerAuthChallenge", "(Ljava/lang/String;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader;", "nonce", "", "domain", "opaque", "", "stale", "algorithm", "digestAuthChallenge", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final Parameterized basicAuthChallenge(String realm, Charset charset) {
            String string;
            Map map;
            void $this$basicAuthChallenge_u24lambda_u240;
            LinkedHashMap linkedHashMap;
            Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
            LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
            String string2 = "Basic";
            $this$basicAuthChallenge_u24lambda_u240.put("realm", map);
            if (charset != null) {
                $this$basicAuthChallenge_u24lambda_u240.put("charset", CharsetJVMKt.getName((Charset)((Object)string)));
            }
            map = linkedHashMap;
            string = string2;
            return new Parameterized(string, map, null, 4, null);
        }

        /*
         * WARNING - void declaration
         */
        public final HttpAuthHeader bearerAuthChallenge(String scheme, String realm) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            return new Parameterized((String)var1_1, realm == null ? MapsKt.emptyMap() : MapsKt.mapOf((Pair)TuplesKt.to((Object)"realm", (Object)var2_2)), null, 4, null);
        }

        public static /* synthetic */ HttpAuthHeader bearerAuthChallenge$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.bearerAuthChallenge(string, string2);
        }

        /*
         * WARNING - void declaration
         */
        public final Parameterized digestAuthChallenge(String realm, String nonce, List<String> domain, String opaque, Boolean stale, String algorithm) {
            String string;
            Map map;
            HeaderValueEncoding headerValueEncoding;
            void $this$digestAuthChallenge_u24lambda_u241;
            LinkedHashMap linkedHashMap;
            Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
            String string2 = "Digest";
            $this$digestAuthChallenge_u24lambda_u241.put("realm", HeaderValueWithParametersKt.quote((String)((Object)headerValueEncoding)));
            $this$digestAuthChallenge_u24lambda_u241.put("nonce", HeaderValueWithParametersKt.quote((String)((Object)map)));
            if (!((Collection)domain).isEmpty()) {
                $this$digestAuthChallenge_u24lambda_u241.put("domain", HeaderValueWithParametersKt.quote(CollectionsKt.joinToString$default((Iterable)((Iterable)((Object)string)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
            }
            if (opaque != null) {
                $this$digestAuthChallenge_u24lambda_u241.put("opaque", HeaderValueWithParametersKt.quote(opaque));
            }
            if (stale != null) {
                $this$digestAuthChallenge_u24lambda_u241.put("stale", stale.toString());
            }
            $this$digestAuthChallenge_u24lambda_u241.put("algorithm", algorithm);
            headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            map = linkedHashMap;
            string = string2;
            return new Parameterized(string, map, headerValueEncoding);
        }

        public static /* synthetic */ Parameterized digestAuthChallenge$default(Companion companion, String string, String string2, List list, String string3, Boolean bl, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = CryptoKt.generateNonce();
            }
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl = null;
            }
            if ((n & 0x20) != 0) {
                string4 = "MD5";
            }
            return companion.digestAuthChallenge(string, string2, list, string3, bl, string4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000b\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "Lio/ktor/http/auth/HttpAuthHeader;", "", "authScheme", "", "Lio/ktor/http/HeaderValueParam;", "parameters", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "<init>", "(Ljava/lang/String;Ljava/util/List;Lio/ktor/http/auth/HeaderValueEncoding;)V", "", "(Ljava/lang/String;Ljava/util/Map;Lio/ktor/http/auth/HeaderValueEncoding;)V", "name", "value", "withParameter", "(Ljava/lang/String;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "withReplacedParameter", "render", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "parameter", "(Ljava/lang/String;)Ljava/lang/String;", "encode", "(Ljava/lang/String;Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "()Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/util/List;", "getParameters", "()Ljava/util/List;", "Lio/ktor/http/auth/HeaderValueEncoding;", "getEncoding", "()Lio/ktor/http/auth/HeaderValueEncoding;", "ktor-http"})
    @SourceDebugExtension(value={"SMAP\nHttpAuthHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpAuthHeader.kt\nio/ktor/http/auth/HttpAuthHeader$Parameterized\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,464:1\n1863#2,2:465\n1557#2:467\n1628#2,3:468\n360#2,7:471\n1611#2,9:478\n1863#2:487\n1864#2:489\n1620#2:490\n295#2,2:491\n1#3:488\n*S KotlinDebug\n*F\n+ 1 HttpAuthHeader.kt\nio/ktor/http/auth/HttpAuthHeader$Parameterized\n*L\n279#1:465,2\n276#1:467\n276#1:468,3\n299#1:471,7\n303#1:478,9\n303#1:487\n303#1:489\n303#1:490\n326#1:491,2\n303#1:488\n*E\n"})
    public static final class Parameterized
    extends HttpAuthHeader {
        private final List<HeaderValueParam> parameters;
        private final HeaderValueEncoding encoding;

        /*
         * WARNING - void declaration
         */
        public Parameterized(String authScheme, List<HeaderValueParam> parameters, HeaderValueEncoding encoding) {
            void var3_3;
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)authScheme, (String)"authScheme");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
            super((String)object2, null);
            this.parameters = object;
            this.encoding = var3_3;
            object2 = this.parameters;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                object = (HeaderValueParam)object;
                object = ((HeaderValueParam)object).getName();
                if (HttpAuthHeaderKt.access$getToken68Pattern$p().matches(object)) continue;
                throw new ParseException("Parameter name should be a token", null, 2, null);
            }
        }

        public /* synthetic */ Parameterized(String string, List list, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string, list, headerValueEncoding);
        }

        public final List<HeaderValueParam> getParameters() {
            return this.parameters;
        }

        public final HeaderValueEncoding getEncoding() {
            return this.encoding;
        }

        /*
         * WARNING - void declaration
         */
        public Parameterized(String authScheme, Map<String, String> parameters, HeaderValueEncoding encoding) {
            void var3_3;
            void var1_1;
            Collection<HeaderValueParam> collection;
            Iterator iterator;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)authScheme, (String)"authScheme");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
            String string = authScheme;
            authScheme = parameters.entrySet();
            String string2 = string;
            Parameterized parameterized = this;
            parameters = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                item$iv$iv = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                collection.add(new HeaderValueParam((String)it.getKey(), (String)it.getValue()));
            }
            collection = (List)var1_1;
            parameterized(string2, (List<HeaderValueParam>)collection, (HeaderValueEncoding)var3_3);
        }

        public /* synthetic */ Parameterized(String string, Map map, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string, map, headerValueEncoding);
        }

        /*
         * WARNING - void declaration
         */
        public final Parameterized withParameter(String name, String value) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Parameterized(this.getAuthScheme(), CollectionsKt.plus((Collection)this.parameters, (Object)new HeaderValueParam((String)var1_1, (String)var2_2)), this.encoding);
        }

        /*
         * WARNING - void declaration
         */
        public final Parameterized withReplacedParameter(String name, String value) {
            void var1_1;
            Object $this$mapNotNullTo$iv$iv;
            int n;
            Object object;
            block8: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Object $this$indexOfFirst$iv = this.parameters;
                int index$iv = 0;
                $this$indexOfFirst$iv = $this$indexOfFirst$iv.iterator();
                while ($this$indexOfFirst$iv.hasNext()) {
                    object = $this$indexOfFirst$iv.next();
                    HeaderValueParam headerValueParam = (HeaderValueParam)object;
                    if (Intrinsics.areEqual((Object)headerValueParam.getName(), (Object)name)) {
                        n = index$iv;
                        break block8;
                    }
                    ++index$iv;
                }
                n = $this$indexOfFirst$iv = -1;
            }
            if (n == -1) {
                return this.withParameter(name, value);
            }
            boolean replaced = false;
            Object object2 = this.parameters;
            object = object2;
            Collection destination$iv$iv = new ArrayList();
            object2 = $this$mapNotNullTo$iv$iv;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                HeaderValueParam headerValueParam;
                Object e = object2.next();
                $this$mapNotNullTo$iv$iv = e;
                $this$mapNotNullTo$iv$iv = e;
                HeaderValueParam it = (HeaderValueParam)e;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) {
                    headerValueParam = it;
                } else if (!replaced) {
                    replaced = true;
                    headerValueParam = new HeaderValueParam(name, value);
                } else {
                    headerValueParam = null;
                }
                if (headerValueParam == null) continue;
                HeaderValueParam it$iv$iv = headerValueParam;
                destination$iv$iv.add(it$iv$iv);
            }
            List newParameters = (List)destination$iv$iv;
            return new Parameterized(this.getAuthScheme(), (List<HeaderValueParam>)var1_1, this.encoding);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String render(HeaderValueEncoding encoding) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
            if (this.parameters.isEmpty()) {
                return this.getAuthScheme();
            }
            return CollectionsKt.joinToString$default((Iterable)this.parameters, (CharSequence)", ", (CharSequence)(this.getAuthScheme() + ' '), null, (int)0, null, arg_0 -> Parameterized.render$lambda$4(this, (HeaderValueEncoding)var1_1, arg_0), (int)28, null);
        }

        /*
         * WARNING - void declaration
         */
        public final String parameter(String name) {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Object object = this.parameters;
                object = object.iterator();
                while (object.hasNext()) {
                    void var3_3;
                    Object element$iv = object.next();
                    HeaderValueParam headerValueParam = (HeaderValueParam)element$iv;
                    if (!Intrinsics.areEqual((Object)headerValueParam.getName(), (Object)name)) continue;
                    v0 = var3_3;
                    break block2;
                }
                v0 = null;
            }
            HeaderValueParam headerValueParam = v0;
            if (headerValueParam != null) {
                return headerValueParam.getValue();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final String encode(String $this$encode, HeaderValueEncoding encoding) {
            switch (WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
                case 1: {
                    return HeaderValueWithParametersKt.escapeIfNeeded($this$encode);
                }
                case 2: {
                    return HeaderValueWithParametersKt.quote($this$encode);
                }
                case 3: {
                    void var1_1;
                    return CodecsKt.encodeURLParameter$default((String)var1_1, false, 1, null);
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public final String render() {
            Parameterized parameterized = this;
            return ((HttpAuthHeader)parameterized).render(parameterized.encoding);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (!(other instanceof Parameterized)) {
                return false;
            }
            return StringsKt.equals((String)((Parameterized)other).getAuthScheme(), (String)this.getAuthScheme(), (boolean)true) && Intrinsics.areEqual(((Parameterized)var1_1).parameters, this.parameters);
        }

        public final int hashCode() {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            String string = this.getAuthScheme().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            objectArray[0] = string;
            objectArray2[1] = this.parameters;
            return Hash.INSTANCE.combine(objectArray2);
        }

        /*
         * WARNING - void declaration
         */
        private static final CharSequence render$lambda$4(Parameterized this$0, HeaderValueEncoding $encoding, HeaderValueParam it) {
            void var1_1;
            void var2_2;
            Parameterized parameterized;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getName() + '=' + parameterized.encode(var2_2.getValue(), (HeaderValueEncoding)var1_1);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HeaderValueEncoding.values().length];
                try {
                    nArray[HeaderValueEncoding.QUOTED_WHEN_REQUIRED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[HeaderValueEncoding.QUOTED_ALWAYS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[HeaderValueEncoding.URI_ENCODE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Parameters;", "", "<init>", "()V", "", "Realm", "Ljava/lang/String;", "Charset", "OAuthCallback", "OAuthConsumerKey", "OAuthNonce", "OAuthToken", "OAuthTokenSecret", "OAuthVerifier", "OAuthSignatureMethod", "OAuthTimestamp", "OAuthVersion", "OAuthSignature", "OAuthCallbackConfirmed", "ktor-http"})
    public static final class Parameters {
        public static final Parameters INSTANCE = new Parameters();
        public static final String Realm = "realm";
        public static final String Charset = "charset";
        public static final String OAuthCallback = "oauth_callback";
        public static final String OAuthConsumerKey = "oauth_consumer_key";
        public static final String OAuthNonce = "oauth_nonce";
        public static final String OAuthToken = "oauth_token";
        public static final String OAuthTokenSecret = "oauth_token_secret";
        public static final String OAuthVerifier = "oauth_verifier";
        public static final String OAuthSignatureMethod = "oauth_signature_method";
        public static final String OAuthTimestamp = "oauth_timestamp";
        public static final String OAuthVersion = "oauth_version";
        public static final String OAuthSignature = "oauth_signature";
        public static final String OAuthCallbackConfirmed = "oauth_callback_confirmed";

        private Parameters() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Single;", "Lio/ktor/http/auth/HttpAuthHeader;", "", "authScheme", "blob", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "render", "()Ljava/lang/String;", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getBlob", "ktor-http"})
    public static final class Single
    extends HttpAuthHeader {
        private final String blob;

        /*
         * WARNING - void declaration
         */
        public Single(String authScheme, String blob) {
            void var2_2;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)authScheme, (String)"authScheme");
            Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
            super((String)charSequence, null);
            this.blob = var2_2;
            charSequence = this.blob;
            if (!HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence)) {
                throw new ParseException("Invalid blob value: it should be token68", null, 2, null);
            }
        }

        public final String getBlob() {
            return this.blob;
        }

        @Override
        public final String render() {
            return this.getAuthScheme() + ' ' + this.blob;
        }

        @Override
        public final String render(HeaderValueEncoding encoding) {
            Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
            return ((HttpAuthHeader)this).render();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (!(other instanceof Single)) {
                return false;
            }
            return StringsKt.equals((String)((Single)other).getAuthScheme(), (String)this.getAuthScheme(), (boolean)true) && StringsKt.equals((String)((Single)var1_1).blob, (String)this.blob, (boolean)true);
        }

        public final int hashCode() {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            String string = this.getAuthScheme().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            objectArray[0] = string;
            Intrinsics.checkNotNullExpressionValue((Object)this.blob.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            return Hash.INSTANCE.combine(objectArray2);
        }
    }
}

