/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0005\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0004\u001a3\u0010\u000b\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a+\u0010\r\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u001a+\u0010\u000f\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a+\u0010\u0011\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000e\u001a+\u0010\u0012\u001a\u00020\n*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000e\u001a'\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a/\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a#\u0010\u0019\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0014\u001a\u0013\u0010\u001b\u001a\u00020\u001a*\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\" \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lio/ktor/http/URLBuilder;", "", "urlString", "takeFrom", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;)Lio/ktor/http/URLBuilder;", "takeFromUnsafe", "", "startIndex", "endIndex", "slashCount", "", "parseFile", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;III)V", "parseMailto", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;II)V", "parseQuery", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;II)I", "parseFragment", "fillHost", "findScheme", "(Ljava/lang/String;II)I", "", "char", "count", "(Ljava/lang/String;IIC)I", "indexOfColonInHostPort", "", "isLetter", "(C)Z", "", "ROOT_PATH", "Ljava/util/List;", "getROOT_PATH", "()Ljava/util/List;", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nURLParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLParser.kt\nio/ktor/http/URLParserKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n158#2,6:270\n170#2,6:276\n1#3:282\n*S KotlinDebug\n*F\n+ 1 URLParser.kt\nio/ktor/http/URLParserKt\n*L\n34#1:270,6\n35#1:276,6\n*E\n"})
public final class URLParserKt {
    private static final List<String> ROOT_PATH = CollectionsKt.listOf((Object)"");

    public static final List<String> getROOT_PATH() {
        return ROOT_PATH;
    }

    /*
     * WARNING - void declaration
     */
    public static final URLBuilder takeFrom(URLBuilder $this$takeFrom, String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (StringsKt.isBlank((CharSequence)urlString)) {
            return $this$takeFrom;
        }
        try {
            $this$takeFrom = URLParserKt.takeFromUnsafe($this$takeFrom, urlString);
        }
        catch (Throwable cause) {
            void var0_1;
            void var1_2;
            throw new URLParserException((String)var1_2, (Throwable)var0_1);
        }
        return uRLBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public static final URLBuilder takeFromUnsafe(URLBuilder $this$takeFromUnsafe, String urlString) {
        URLBuilder uRLBuilder;
        void var3_3;
        void var1_1;
        int n;
        int n2;
        int startIndex2;
        block19: {
            int n3;
            int n4;
            block18: {
                Intrinsics.checkNotNullParameter((Object)$this$takeFromUnsafe, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
                CharSequence $this$indexOfFirst$iv = urlString;
                n4 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n4; ++index$iv) {
                    char c = $this$indexOfFirst$iv.charAt(index$iv);
                    if (!(!CharsKt.isWhitespace((char)c))) continue;
                    n3 = index$iv;
                    break block18;
                }
                n3 = -1;
            }
            startIndex2 = n3;
            CharSequence $this$indexOfLast$iv = urlString;
            n4 = $this$indexOfLast$iv.length() + -1;
            if (n4 >= 0) {
                do {
                    int index$iv;
                    char c;
                    if (!(!CharsKt.isWhitespace((char)(c = $this$indexOfLast$iv.charAt(index$iv = n4--))))) continue;
                    n2 = index$iv;
                    break block19;
                } while (n4 >= 0);
            }
            n2 = -1;
        }
        int endIndex = n2 + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex2, endIndex);
        if (schemeLength > 0) {
            int n5 = startIndex2;
            String string = urlString.substring(n5, n5 + schemeLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String scheme = string;
            $this$takeFromUnsafe.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex2 += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex2, endIndex, '/');
        startIndex2 += slashCount;
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"file")) {
            URLParserKt.parseFile($this$takeFromUnsafe, urlString, startIndex2, endIndex, slashCount);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"mailto")) {
            if (!(slashCount == 0)) {
                String index$iv = "Failed requirement.";
                throw new IllegalArgumentException(index$iv.toString());
            }
            URLParserKt.parseMailto($this$takeFromUnsafe, urlString, startIndex2, endIndex);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"about")) {
            if (!(slashCount == 0)) {
                String index$iv = "Failed requirement.";
                throw new IllegalArgumentException(index$iv.toString());
            }
            String string = urlString.substring(startIndex2, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$takeFromUnsafe.setHost(string);
            return $this$takeFromUnsafe;
        }
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                Integer n6;
                Integer n7 = (schemeLength = ((Number)(n6 = Integer.valueOf(StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"@/\\?#"), (int)startIndex2, (boolean)false, (int)4, null)))).intValue()) > 0 ? n6 : null;
                delimiter = n7 != null ? n7 : endIndex;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex2, delimiter);
                if (passwordIndex != -1) {
                    String string = urlString.substring(startIndex2, passwordIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$takeFromUnsafe.setEncodedUser(string);
                    String string2 = urlString.substring(passwordIndex + 1, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    $this$takeFromUnsafe.setEncodedPassword(string2);
                } else {
                    String string = urlString.substring(startIndex2, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$takeFromUnsafe.setEncodedUser(string);
                }
                startIndex2 = delimiter + 1;
            }
            URLParserKt.fillHost($this$takeFromUnsafe, urlString, startIndex2, delimiter);
            startIndex2 = delimiter;
        }
        if (startIndex2 >= endIndex) {
            $this$takeFromUnsafe.setEncodedPathSegments(urlString.charAt(endIndex - 1) == '/' ? ROOT_PATH : CollectionsKt.emptyList());
            return $this$takeFromUnsafe;
        }
        $this$takeFromUnsafe.setEncodedPathSegments(slashCount == 0 ? CollectionsKt.dropLast($this$takeFromUnsafe.getEncodedPathSegments(), (int)1) : CollectionsKt.emptyList());
        Integer n8 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"?#"), (int)startIndex2, (boolean)false, (int)4, null);
        schemeLength = ((Number)n8).intValue();
        Integer n9 = schemeLength > 0 ? n8 : null;
        int pathEnd = n9 != null ? n9 : endIndex;
        if (pathEnd > startIndex2) {
            void var2_13;
            List list;
            List basePath;
            String string = urlString.substring(startIndex2, pathEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String rawPath = string;
            List list2 = $this$takeFromUnsafe.getEncodedPathSegments().size() == 1 && ((CharSequence)CollectionsKt.first($this$takeFromUnsafe.getEncodedPathSegments())).length() == 0 ? CollectionsKt.emptyList() : (basePath = $this$takeFromUnsafe.getEncodedPathSegments());
            if (Intrinsics.areEqual((Object)rawPath, (Object)"/")) {
                list = ROOT_PATH;
            } else {
                char[] cArray = new char[1];
                char[] startIndex2 = cArray;
                cArray[0] = 47;
                list = StringsKt.split$default((CharSequence)rawPath, (char[])startIndex2, (boolean)false, (int)0, (int)6, null);
            }
            List rawChunks = list;
            List relativePath = CollectionsKt.plus((Collection)(slashCount == 1 ? ROOT_PATH : CollectionsKt.emptyList()), (Iterable)rawChunks);
            $this$takeFromUnsafe.setEncodedPathSegments(CollectionsKt.plus((Collection)basePath, (Iterable)((Iterable)var2_13)));
            n = pathEnd;
        }
        if (n < endIndex && urlString.charAt(n) == '?') {
            n = URLParserKt.parseQuery($this$takeFromUnsafe, urlString, n, endIndex);
        }
        URLParserKt.parseFragment($this$takeFromUnsafe, (String)var1_1, n, (int)var3_3);
        return uRLBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private static final void parseFile(URLBuilder $this$parseFile, String urlString, int startIndex, int endIndex, int slashCount) {
        void var1_1;
        switch (slashCount) {
            case 2: {
                int nextSlash = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)startIndex, (boolean)false, (int)4, null);
                if (nextSlash == -1 || nextSlash == endIndex) {
                    String string = urlString.substring(startIndex, endIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$parseFile.setHost(string);
                    return;
                }
                String string = urlString.substring(startIndex, nextSlash);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$parseFile.setHost(string);
                String string2 = urlString.substring(nextSlash, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                URLBuilderKt.setEncodedPath($this$parseFile, string2);
                return;
            }
            case 3: {
                URLBuilder uRLBuilder;
                void var3_3;
                void var2_2;
                $this$parseFile.setHost("");
                StringBuilder stringBuilder = new StringBuilder("/");
                String string = urlString.substring((int)var2_2, (int)var3_3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                URLBuilderKt.setEncodedPath(uRLBuilder, stringBuilder.append(string).toString());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid file url: " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final void parseMailto(URLBuilder $this$parseMailto, String urlString, int startIndex, int endIndex) {
        URLBuilder uRLBuilder;
        void var3_3;
        void var1_1;
        void var2_2;
        int delimiter = StringsKt.indexOf$default((CharSequence)urlString, (String)"@", (int)startIndex, (boolean)false, (int)4, null);
        if (delimiter == -1) {
            throw new IllegalArgumentException("Invalid mailto url: " + urlString + ", it should contain '@'.");
        }
        String string = urlString.substring((int)var2_2, delimiter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        $this$parseMailto.setUser(CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null));
        String string2 = var1_1.substring(delimiter + 1, (int)var3_3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        uRLBuilder.setHost(string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final int parseQuery(URLBuilder $this$parseQuery, String urlString, int startIndex, int endIndex) {
        void var3_3;
        URLBuilder uRLBuilder;
        void var2_2;
        Parameters parameters;
        int fragmentStart;
        if (startIndex + 1 == endIndex) {
            $this$parseQuery.setTrailingQuery(true);
            return endIndex;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
        int n2 = ((Number)n).intValue();
        Integer n3 = n2 > 0 ? n : null;
        fragmentStart = n3 != null ? n3 : fragmentStart;
        String string = ((String)((Object)parameters)).substring((int)(var2_2 + true), fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        parameters = QueryKt.parseQueryString$default(string, 0, 0, false, 6, null);
        parameters.forEach((arg_0, arg_1) -> URLParserKt.parseQuery$lambda$5(uRLBuilder, arg_0, arg_1));
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final void parseFragment(URLBuilder $this$parseFragment, String urlString, int startIndex, int endIndex) {
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            URLBuilder uRLBuilder;
            void var3_3;
            void var2_2;
            void var1_1;
            String string = var1_1.substring((int)(var2_2 + true), (int)var3_3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            uRLBuilder.setEncodedFragment(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void fillHost(URLBuilder $this$fillHost, String urlString, int startIndex, int endIndex) {
        URLBuilder uRLBuilder;
        int n;
        void var2_2;
        Integer n2 = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int n3 = ((Number)n2).intValue();
        Integer n4 = n3 > 0 ? n2 : null;
        int colonIndex = n4 != null ? n4 : endIndex;
        String string = urlString.substring((int)var2_2, colonIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        $this$fillHost.setHost(string);
        if (colonIndex + 1 < endIndex) {
            void var3_3;
            void var1_1;
            String string2 = var1_1.substring(colonIndex + 1, (int)var3_3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            n = Integer.parseInt(string2);
        } else {
            n = 0;
        }
        uRLBuilder.setPort(n);
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        int current = startIndex;
        int incorrectSchemePosition = -1;
        char firstChar = urlString.charAt(current);
        if (!('a' <= firstChar ? firstChar < '{' : false)) {
            if (!('A' <= firstChar ? firstChar < '[' : false)) {
                incorrectSchemePosition = current;
            }
        }
        while (current < endIndex) {
            char c = urlString.charAt(current);
            if (c == ':') {
                if (incorrectSchemePosition != -1) {
                    throw new IllegalArgumentException("Illegal character in scheme at position " + incorrectSchemePosition);
                }
                return current - startIndex;
            }
            switch (c) {
                case '#': 
                case '/': 
                case '?': {
                    return -1;
                }
            }
            if (incorrectSchemePosition == -1) {
                if (!('a' <= c ? c < '{' : false)) {
                    if (!('A' <= c ? c < '[' : false)) {
                        if (!('0' <= c ? c < ':' : false) && c != '.' && c != '+' && c != '-') {
                            incorrectSchemePosition = current;
                        }
                    }
                }
            }
            ++current;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result = 0;
        while (startIndex + result < endIndex && urlString.charAt(startIndex + result) == c) {
            ++result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfColonInHostPort(String $this$indexOfColonInHostPort, int startIndex, int endIndex) {
        void index;
        boolean skip = false;
        while (index < endIndex) {
            switch ($this$indexOfColonInHostPort.charAt((int)index)) {
                case '[': {
                    skip = true;
                    break;
                }
                case ']': {
                    skip = false;
                    break;
                }
                case ':': {
                    if (skip) break;
                    return (int)index;
                }
            }
            ++index;
        }
        return -1;
    }

    private static final boolean isLetter(char $this$isLetter) {
        char c = Character.toLowerCase($this$isLetter);
        if ('a' <= c) {
            return c < '{';
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseQuery$lambda$5(URLBuilder $this_parseQuery, String key, List values) {
        void var2_2;
        void var1_1;
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        uRLBuilder.getEncodedParameters().appendAll((String)var1_1, (Iterable)var2_2);
        return Unit.INSTANCE;
    }
}

