/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.URLBuilderJvmKt;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.UrlDecodedParametersBuilder;
import io.ktor.http.UrlDecodedParametersBuilderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b0\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 R2\u00020\u0001:\u0001RBm\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u0014\"\u0004\b\u001e\u0010\u001fR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R*\u0010\u0007\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00068\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010+\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u0010\u0003\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010.\"\u0004\b2\u00100R$\u00103\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010\u001c\u001a\u0004\b4\u0010\u0014\"\u0004\b5\u0010\u001fR(\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\u0014\"\u0004\b7\u0010\u001fR$\u00108\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u0010\u001c\u001a\u0004\b9\u0010\u0014\"\u0004\b:\u0010\u001fR(\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0014\"\u0004\b<\u0010\u001fR\"\u0010=\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010\u001c\u001a\u0004\b>\u0010\u0014\"\u0004\b?\u0010\u001fR$\u0010\u000e\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010\u0014\"\u0004\bA\u0010\u001fR(\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00040\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010E\"\u0004\bI\u0010GR*\u0010K\u001a\u00020J2\u0006\u0010%\u001a\u00020J8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR$\u0010\r\u001a\u00020J2\u0006\u0010%\u001a\u00020J8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\r\u0010L\u001a\u0004\bQ\u0010N\u00a8\u0006S"}, d2={"Lio/ktor/http/URLBuilder;", "", "Lio/ktor/http/URLProtocol;", "protocol", "", "host", "", "port", "user", "password", "", "pathSegments", "Lio/ktor/http/Parameters;", "parameters", "fragment", "", "trailingQuery", "<init>", "(Lio/ktor/http/URLProtocol;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/List;Lio/ktor/http/Parameters;Ljava/lang/String;Z)V", "buildString", "()Ljava/lang/String;", "toString", "Lio/ktor/http/Url;", "build", "()Lio/ktor/http/Url;", "", "applyOrigin", "()V", "Ljava/lang/String;", "getHost", "setHost", "(Ljava/lang/String;)V", "Z", "getTrailingQuery", "()Z", "setTrailingQuery", "(Z)V", "value", "I", "getPort", "()I", "setPort", "(I)V", "protocolOrNull", "Lio/ktor/http/URLProtocol;", "getProtocolOrNull", "()Lio/ktor/http/URLProtocol;", "setProtocolOrNull", "(Lio/ktor/http/URLProtocol;)V", "getProtocol", "setProtocol", "encodedUser", "getEncodedUser", "setEncodedUser", "getUser", "setUser", "encodedPassword", "getEncodedPassword", "setEncodedPassword", "getPassword", "setPassword", "encodedFragment", "getEncodedFragment", "setEncodedFragment", "getFragment", "setFragment", "encodedPathSegments", "Ljava/util/List;", "getEncodedPathSegments", "()Ljava/util/List;", "setEncodedPathSegments", "(Ljava/util/List;)V", "getPathSegments", "setPathSegments", "Lio/ktor/http/ParametersBuilder;", "encodedParameters", "Lio/ktor/http/ParametersBuilder;", "getEncodedParameters", "()Lio/ktor/http/ParametersBuilder;", "setEncodedParameters", "(Lio/ktor/http/ParametersBuilder;)V", "getParameters", "Companion", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nURLBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLBuilder.kt\nio/ktor/http/URLBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,325:1\n1557#2:326\n1628#2,3:327\n1557#2:330\n1628#2,3:331\n1557#2:334\n1628#2,3:335\n*S KotlinDebug\n*F\n+ 1 URLBuilder.kt\nio/ktor/http/URLBuilder\n*L\n71#1:326\n71#1:327,3\n74#1:330\n74#1:331,3\n76#1:334\n76#1:335,3\n*E\n"})
public final class URLBuilder {
    public static final Companion Companion = new Companion(null);
    private String host;
    private boolean trailingQuery;
    private int port;
    private URLProtocol protocolOrNull;
    private String encodedUser;
    private String encodedPassword;
    private String encodedFragment;
    private List<String> encodedPathSegments;
    private ParametersBuilder encodedParameters;
    private ParametersBuilder parameters;
    private static final Url originUrl = URLUtilsKt.Url(URLBuilderJvmKt.getOrigin(Companion));

    /*
     * WARNING - void declaration
     */
    public URLBuilder(URLProtocol protocol, String host, int port, String user, String password, List<String> pathSegments, Parameters parameters, String fragment, boolean trailingQuery) {
        void var1_1;
        Iterator iterator;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.host = host;
        this.trailingQuery = trailingQuery;
        this.port = port;
        this.protocolOrNull = protocol;
        String string = user;
        this.encodedUser = string != null ? CodecsKt.encodeURLParameter$default(string, false, 1, null) : null;
        String string2 = password;
        this.encodedPassword = string2 != null ? CodecsKt.encodeURLParameter$default(string2, false, 1, null) : null;
        this.encodedFragment = CodecsKt.encodeURLQueryComponent$default(fragment, false, false, null, 7, null);
        protocol = pathSegments;
        URLBuilder uRLBuilder = this;
        host = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Object item$iv$iv = iterator.next();
            item$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            collection.add(CodecsKt.encodeURLPathPart((String)var3_4));
        }
        uRLBuilder.encodedPathSegments = (List)var1_1;
        this.encodedParameters = UrlDecodedParametersBuilderKt.encodeParameters(parameters);
        this.parameters = new UrlDecodedParametersBuilder(this.encodedParameters);
    }

    public /* synthetic */ URLBuilder(URLProtocol uRLProtocol, String string, int n, String string2, String string3, List list, Parameters parameters, String string4, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            uRLProtocol = null;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            string3 = null;
        }
        if ((n2 & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x40) != 0) {
            parameters = Parameters.Companion.getEmpty();
        }
        if ((n2 & 0x80) != 0) {
            string4 = "";
        }
        if ((n2 & 0x100) != 0) {
            bl = false;
        }
        this(uRLProtocol, string, n, string2, string3, list, parameters, string4, bl);
    }

    public final String getHost() {
        return this.host;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHost(String string) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = var1_1;
    }

    public final boolean getTrailingQuery() {
        return this.trailingQuery;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrailingQuery(boolean bl) {
        void var1_1;
        this.trailingQuery = var1_1;
    }

    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPort(int value2) {
        void var1_1;
        if (!(value2 >= 0 ? value2 < 65536 : false)) {
            String value2 = "Port must be between 0 and 65535, or 0 if not set. Provided: " + value2;
            throw new IllegalArgumentException(value2.toString());
        }
        this.port = var1_1;
    }

    public final URLProtocol getProtocolOrNull() {
        return this.protocolOrNull;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProtocolOrNull(URLProtocol uRLProtocol) {
        void var1_1;
        this.protocolOrNull = var1_1;
    }

    public final URLProtocol getProtocol() {
        URLProtocol uRLProtocol = this.protocolOrNull;
        if (uRLProtocol == null) {
            uRLProtocol = URLProtocol.Companion.getHTTP();
        }
        return uRLProtocol;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProtocol(URLProtocol value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.protocolOrNull = var1_1;
    }

    public final String getEncodedUser() {
        return this.encodedUser;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEncodedUser(String string) {
        void var1_1;
        this.encodedUser = var1_1;
    }

    public final String getUser() {
        String string = this.encodedUser;
        if (string != null) {
            return CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUser(String value) {
        void var1_1;
        void v0 = var1_1;
        this.encodedUser = v0 != null ? CodecsKt.encodeURLParameter$default((String)v0, false, 1, null) : null;
    }

    public final String getEncodedPassword() {
        return this.encodedPassword;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEncodedPassword(String string) {
        void var1_1;
        this.encodedPassword = var1_1;
    }

    public final String getPassword() {
        String string = this.encodedPassword;
        if (string != null) {
            return CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPassword(String value) {
        void var1_1;
        void v0 = var1_1;
        this.encodedPassword = v0 != null ? CodecsKt.encodeURLParameter$default((String)v0, false, 1, null) : null;
    }

    public final String getEncodedFragment() {
        return this.encodedFragment;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEncodedFragment(String string) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.encodedFragment = var1_1;
    }

    public final String getFragment() {
        return CodecsKt.decodeURLQueryComponent$default(this.encodedFragment, 0, 0, false, null, 15, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setFragment(String value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodedFragment = CodecsKt.encodeURLQueryComponent$default((String)var1_1, false, false, null, 7, null);
    }

    public final List<String> getEncodedPathSegments() {
        return this.encodedPathSegments;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEncodedPathSegments(List<String> list) {
        void var1_1;
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.encodedPathSegments = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> getPathSegments() {
        void var1_1;
        Iterable $this$map$iv = this.encodedPathSegments;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Object item$iv$iv = object.next();
            item$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            collection.add(CodecsKt.decodeURLPart$default((String)var3_3, 0, 0, null, 7, null));
        }
        return (List)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPathSegments(List<String> value) {
        void var1_1;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        value = value;
        URLBuilder uRLBuilder = this;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Object item$iv$iv = iterator.next();
            item$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            collection.add(CodecsKt.encodeURLPathPart((String)var3_4));
        }
        uRLBuilder.encodedPathSegments = (List)var1_1;
    }

    public final ParametersBuilder getEncodedParameters() {
        return this.encodedParameters;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEncodedParameters(ParametersBuilder value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodedParameters = value;
        this.parameters = new UrlDecodedParametersBuilder((ParametersBuilder)var1_1);
    }

    public final ParametersBuilder getParameters() {
        return this.parameters;
    }

    public final String buildString() {
        this.applyOrigin();
        String string = ((StringBuilder)URLBuilderKt.access$appendTo(this, new StringBuilder(256))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final String toString() {
        String string = ((StringBuilder)URLBuilderKt.access$appendTo(this, new StringBuilder(256))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final Url build() {
        this.applyOrigin();
        return new Url(this.protocolOrNull, this.host, this.port, this.getPathSegments(), this.parameters.build(), this.getFragment(), this.getUser(), this.getPassword(), this.trailingQuery, this.buildString());
    }

    private final void applyOrigin() {
        if (((CharSequence)this.host).length() > 0 || Intrinsics.areEqual((Object)this.getProtocol().getName(), (Object)"file")) {
            return;
        }
        this.host = originUrl.getHost();
        if (this.protocolOrNull == null) {
            this.protocolOrNull = originUrl.getProtocolOrNull();
        }
        if (this.port == 0) {
            this.setPort(originUrl.getSpecifiedPort());
        }
    }

    public URLBuilder() {
        this(null, null, 0, null, null, null, null, null, false, 511, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/http/URLBuilder$Companion;", "", "<init>", "()V", "Lio/ktor/http/Url;", "originUrl", "Lio/ktor/http/Url;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

