#import "font.typ" as fonts

#let toc(
  isCN: true,
  toc-title: [Table of Content]
) = {
  set outline(
  fill: box(
    width: 1fr, 
    repeat(h(5pt) + "." + h(5pt))) + h(5pt)
  )

  show outline: it => {
    show heading: title => {
      set align(center)
      if(isCN){
        set text(
          font: fonts.HeiTi,
          size: fonts.No2-Small,
        )
        title
        v(1em)
      }else{
        set text(
          font: fonts.HeiTi,
          size: fonts.No2-Small,
          weight: "bold",
        )
        title
        v(1em)
      }
    }
    it
  }

  show outline.entry: it => {

    v(0.5em, weak: false)
    set text(
      font: fonts.SongTi,
      size: fonts.No4,
    )
    if(it.level == 1){
      set text(
        weight: 700,
      )
      it
    }else{
      it
    }
  }

  if(isCN){
    pagebreak()
    outline(
      title: [目录]
    )
  }else{
    pagebreak()
    outline(
      title: toc-title
    )
  }
  
}