import pkg from '@opentiny/tiny-robot/package.json' with { type: 'json' }
import vueJsx from '@vitejs/plugin-vue-jsx'
import { fileURLToPath } from 'url'
import { defineConfig } from 'vitepress'
import { vitepressDemoPlugin } from 'vitepress-demo-plugin'

const { version } = pkg

const devAlias = {
  '@opentiny/tiny-robot': fileURLToPath(new URL('../../packages/components/src', import.meta.url)),
  '@opentiny/tiny-robot-kit': fileURLToPath(new URL('../../packages/kit/src', import.meta.url)),
  '@opentiny/tiny-robot-style': fileURLToPath(
    new URL('../../packages/components/src/styles/root.css', import.meta.url),
  ),
}

const prodAlias = {
  '@opentiny/tiny-robot-style': '@opentiny/tiny-robot/dist/style.css',
}

// 定义共享的侧边栏配置
const sharedSidebarItems = [
  {
    text: '指南',
    base: '/guide/',
    items: [
      { text: '快速开始', link: 'quick-start' },
      { text: '主题配置', link: 'theme-config' },
      { text: '更新日志', link: 'update-log' },
    ],
  },
  {
    text: '组件',
    base: '/components/',
    items: [
      { text: 'Container 容器', link: 'container' },
      { text: 'Bubble 气泡', link: 'bubble' },
      { text: 'Sender 消息输入框', link: 'sender' },
      { text: 'Prompts 提示集', link: 'prompts' },
      { text: 'Welcome 欢迎', link: 'welcome' },
      { text: 'Feedback 气泡反馈', link: 'feedback' },
      { text: 'History 历史', link: 'history' },
      { text: 'DropdownMenu 下拉菜单', link: 'dropdown-menu' },
      { text: 'SuggestionPopover 建议弹出框', link: 'suggestion-popover' },
      { text: 'SuggestionPills 建议按钮组', link: 'suggestion-pills' },
      { text: 'DragOverlay 拖拽浮层', link: 'drag-overlay' },
      { text: 'Attachments 附件卡片', link: 'attachments' },
      { text: 'McpServerPicker 插件选择器', link: 'mcp-server-picker' },
      { text: 'Theme 主题', link: 'theme' },
    ],
  },
  {
    text: '工具',
    base: '/tools/',
    items: [
      { text: 'AI模型交互工具类', link: 'ai-client' },
      { text: '消息数据管理', link: 'message' },
      { text: '会话数据管理', link: 'conversation' },
    ],
  },
]

// https://vitepress.dev/reference/site-config
export default defineConfig({
  title: 'TinyRobot',
  description: 'TinyRobot',
  srcDir: 'src',
  outDir: 'dist',
  base: process.env.VITEPRESS_BASE || '/',
  head: [
    [
      'link',
      {
        rel: 'icon',
        href: `${process.env.VITEPRESS_BASE ? process.env.VITEPRESS_BASE.replace(/\/$/, '') : ''}/logo-mini.svg`,
      },
    ],
  ],
  vite: {
    plugins: [vueJsx()],
    server: {
      open: true,
      proxy: process.env.VP_MODE === 'development' ? { '/playground': 'http://localhost:5184' } : undefined,
    },
    resolve: {
      alias: {
        ...(process.env.VP_MODE === 'development' ? devAlias : prodAlias),
      },
    },
    define: {
      __TINY_ROBOT_VERSION__: JSON.stringify(version),
    },
  },
  markdown: {
    config: (md) => {
      md.use(vitepressDemoPlugin, {
        playground: { show: true },
        codeTransformer: (code) => {
          return code.replace(/import\.meta\.env\.BASE_URL/g, `'${process.env.VITEPRESS_BASE || '/'}'`)
        },
      })
    },
  },
  themeConfig: {
    // https://vitepress.dev/reference/default-theme-config
    logo: '/logo-mini.svg',
    siteTitle: 'TinyRobot',
    nav: [
      { text: '指南', link: '/guide/quick-start', activeMatch: '/guide/' },
      { text: '演示', link: '/examples/assistant', activeMatch: '/examples/' },
    ],
    sidebar: {
      '/guide/': sharedSidebarItems,
      '/components/': sharedSidebarItems,
      '/tools/': sharedSidebarItems,
      '/examples/': [
        {
          text: '演示',
          base: '/examples/',
          items: [{ text: '综合示例', link: 'assistant' }],
        },
      ],
    },
    search: {
      provider: 'local',
    },
  },
})
