/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.logger;

import app.freerouting.logger.LogEntry;
import app.freerouting.logger.LogEntryType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LogEntries {
    private final List<LogEntry> entries = new ArrayList<LogEntry>();

    public int getWarningCount() {
        return (int)this.entries.stream().filter(e -> e.type == LogEntryType.Warning).count();
    }

    public int getErrorCount() {
        return (int)this.entries.stream().filter(e -> e.type == LogEntryType.Error).count();
    }

    public void clear() {
        this.entries.clear();
    }

    public String getAsString() {
        return this.entries.stream().map(LogEntry::toString).collect(Collectors.joining("\n", "", "\n"));
    }

    public String[] get() {
        return (String[])this.entries.stream().map(LogEntry::toString).toArray(String[]::new);
    }

    public LogEntry[] getEntries() {
        return this.entries.toArray(new LogEntry[0]);
    }

    public void add(LogEntryType type, String message) {
        this.add(type, message, null);
    }

    public void add(LogEntryType type, String message, Throwable exception) {
        this.entries.add(new LogEntry(type, message, exception));
    }
}

