/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.library;

import app.freerouting.board.LayerStructure;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.library.Padstack;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.util.Vector;

public class Padstacks
implements Serializable {
    public final LayerStructure board_layer_structure;
    private final Vector<Padstack> padstack_arr;

    public Padstacks(LayerStructure p_layer_structure) {
        this.board_layer_structure = p_layer_structure;
        this.padstack_arr = new Vector();
    }

    public Padstack get(String p_name) {
        for (Padstack curr_padstack : this.padstack_arr) {
            if (curr_padstack == null || !curr_padstack.name.equalsIgnoreCase(p_name)) continue;
            return curr_padstack;
        }
        return null;
    }

    public int count() {
        return this.padstack_arr.size();
    }

    public Padstack get(int p_padstack_no) {
        if (p_padstack_no <= 0 || p_padstack_no > this.padstack_arr.size()) {
            int padstack_count = this.padstack_arr.size();
            FRLogger.warn("Padstacks.get: 1 <= p_padstack_no <= " + padstack_count + " expected");
            return null;
        }
        Padstack result = this.padstack_arr.elementAt(p_padstack_no - 1);
        if (result != null && result.no != p_padstack_no) {
            FRLogger.warn("Padstacks.get: inconsistent padstack number");
        }
        return result;
    }

    public Padstack add(String p_name, ConvexShape[] p_shapes, boolean p_drill_allowed, boolean p_placed_absolute) {
        Padstack new_padstack = new Padstack(p_name, this.padstack_arr.size() + 1, p_shapes, p_drill_allowed, p_placed_absolute, this);
        this.padstack_arr.add(new_padstack);
        return new_padstack;
    }

    public Padstack add(ConvexShape[] p_shapes) {
        String new_name = "padstack#" + (this.padstack_arr.size() + 1);
        return this.add(new_name, p_shapes, false, false);
    }

    public Padstack add(ConvexShape p_shape, int p_from_layer, int p_to_layer) {
        ConvexShape[] shape_arr = new ConvexShape[this.board_layer_structure.arr.length];
        int from_layer = Math.max(p_from_layer, 0);
        int to_layer = Math.min(p_to_layer, this.board_layer_structure.arr.length - 1);
        for (int i = from_layer; i <= to_layer; ++i) {
            shape_arr[i] = p_shape;
        }
        return this.add(shape_arr);
    }
}

