/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.library;

import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.geometry.planar.Area;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.library.Packages;
import app.freerouting.library.Padstack;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public class Package
implements Comparable<Package>,
ObjectInfoPanel.Printable,
Serializable {
    public final String name;
    public final int no;
    public final Shape[] outline;
    public final Keepout[] keepout_arr;
    public final Keepout[] via_keepout_arr;
    public final Keepout[] place_keepout_arr;
    public final boolean is_front;
    private final Pin[] pin_arr;
    private final Packages package_list;

    public Package(String p_name, int p_no, Pin[] p_pin_arr, Shape[] p_outline, Keepout[] p_keepout_arr, Keepout[] p_via_keepout_arr, Keepout[] p_place_keepout_arr, boolean p_is_front, Packages p_package_list) {
        this.name = p_name;
        this.no = p_no;
        this.pin_arr = p_pin_arr;
        this.outline = p_outline;
        this.keepout_arr = p_keepout_arr;
        this.via_keepout_arr = p_via_keepout_arr;
        this.place_keepout_arr = p_place_keepout_arr;
        this.is_front = p_is_front;
        this.package_list = p_package_list;
    }

    @Override
    public int compareTo(Package p_other) {
        return this.name.compareToIgnoreCase(p_other.name);
    }

    public Pin get_pin(int p_no) {
        if (p_no < 0 || p_no >= this.pin_arr.length) {
            FRLogger.warn("Package.get_pin: p_no out of range");
            return null;
        }
        return this.pin_arr[p_no];
    }

    public int get_pin_no(String p_name) {
        for (int i = 0; i < this.pin_arr.length; ++i) {
            if (!this.pin_arr[i].name.equals(p_name)) continue;
            return i;
        }
        return -1;
    }

    public int pin_count() {
        return this.pin_arr.length;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.ObjectInfoPanel", p_locale);
        p_window.append_bold(resources.getString("package") + " ");
        p_window.append_bold(this.name);
        for (int i = 0; i < this.pin_arr.length; ++i) {
            Pin curr_pin = this.pin_arr[i];
            p_window.newline();
            p_window.indent();
            p_window.append(resources.getString("pin") + " ");
            p_window.append(curr_pin.name);
            p_window.append(", " + resources.getString("padstack") + " ");
            Padstack curr_padstack = this.package_list.padstack_list.get(curr_pin.padstack_no);
            p_window.append(curr_padstack.name, resources.getString("padstack_info"), curr_padstack);
            p_window.append(" " + resources.getString("at") + " ");
            p_window.append(curr_pin.relative_location.to_float());
            p_window.append(", " + resources.getString("rotation") + " ");
            p_window.append_without_transforming(curr_pin.rotation_in_degree);
        }
        p_window.newline();
    }

    public static class Pin
    implements Serializable {
        public final String name;
        public final int padstack_no;
        public final Vector relative_location;
        public final double rotation_in_degree;

        public Pin(String p_name, int p_padstack_no, Vector p_relative_location, double p_rotation_in_degree) {
            this.name = p_name;
            this.padstack_no = p_padstack_no;
            this.relative_location = p_relative_location;
            this.rotation_in_degree = p_rotation_in_degree;
        }
    }

    public static class Keepout
    implements Serializable {
        public final String name;
        public final Area area;
        public final int layer;

        public Keepout(String p_name, Area p_area, int p_layer) {
            this.name = p_name;
            this.area = p_area;
            this.layer = p_layer;
        }
    }
}

